/*
 * Header    :
 * File      : RescueEvalEngine.cxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/25
 * Time-stamp: "2002-04-28 01:16:39 kshinoda"
 * Comment   :
 * End       :
 */

#include "../itk/itk.h"
#include "../rescuelang/Posit.h"
#include "../rescuelang/FrameSexp.h"
#include "../rescuelang/EvalEngine.h"
#include "Environment.hxx"
#include "CivilianController.hxx"
#include "RescueEvalEngine.hxx"

using namespace Itk;
using namespace Rescue;

namespace RescueCivilian {
  //------------------------------------------------------------
  // RescueEvalEngine :: constructor
  RescueEvalEngine::RescueEvalEngine() : EvalEngine() {
    sight_limited() = False;
    initFuncTable();
  };
  RescueEvalEngine::RescueEvalEngine(Environment* env) : EvalEngine() {
    sight_limited() = False;
    m_env  = env;
    initFuncTable();
  };

  //------------------------------------------------------------
  //
  ObjectPool& RescueEvalEngine::objectpool() {
    return env().map();
  };
    


  //------------------------------------------------------------
  // sysfunc: for inputsensor
  Sexp* sysfunc_see(Sexp* form, EvalEngine* engine){

    RescueEvalEngine* rengine = dynamic_cast<RescueEvalEngine*>(engine);
    rengine->sight_limited() = True;

    Sexp* args = form->rest();
    Sexp* r = Sexp::TrueValue;
    r = engine->eval(args->first());
    return r;
  };

  Sexp* sysfunc_hear(Sexp* form, EvalEngine* engine){
    Sexp* args = form->rest();
    
    //SimpleSexp2* sender  = args->passoc(":sender");
    //SimpleSexp2* content = args->passoc(":content");
    // matching
    Sexp* r = Sexp::TrueValue;
    r = engine->eval(args->first());
    return r;
  };

  Sexp* sysfunc_know(Sexp* form, EvalEngine* engine){

    RescueEvalEngine* rengine = dynamic_cast<RescueEvalEngine*>(engine);
    rengine->sight_limited() = False;

    Sexp* args = form->rest();
    Sexp* r = Sexp::TrueValue;
    r = engine->eval(args->first());
    return r;
  };

//------------------------------------------------------------
// sysfunc: for object
  Sexp* sysfunc_world(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    FrameSexp* time = f->slotvalue(":time");

    FrameSexp* cond = f->slotvalue(":cond");

    // check time
    Flt v = Flt(rengine->env().controller().time());
    if(!check_attribute(time, rengine, v)){
      return Sexp::Nil;
    }
    // check cond
    if(!cond->isNil()){
      Sexp* result = engine->eval(cond);
      r = (result->equal(Sexp::TrueValue))? Sexp::TrueValue : Sexp::Nil;
    } else {
      r = Sexp::TrueValue;
    }
    return r;
  }

  Sexp* sysfunc_self(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);

    FrameSexp* x  = f->slotvalue(":x");
    FrameSexp* y  = f->slotvalue(":y");
    FrameSexp* id         = f->slotvalue(":id");
    FrameSexp* position   = f->slotvalue(":position");
    FrameSexp* stamina    = f->slotvalue(":stamina");
    FrameSexp* hp         = f->slotvalue(":hp");
    FrameSexp* damage     = f->slotvalue(":damage");
    FrameSexp* buriedness = f->slotvalue(":buriedness");
    
    FrameSexp* cond = f->slotvalue(":cond");

    Humanoid* self = rengine->env()._self();

    // check time
    Flt v = Flt(self->x());
    if(!check_attribute(x, rengine, v)){
      return r;
    }
    v = Flt(self->y());
    if(!check_attribute(y, rengine, v)){
      return r;
    }
    v = Flt(rengine->env().controller().selfid());
    if(!check_attribute(id, rengine, v)){
      return r;
    }
    v = Flt(self->position()->id());
    if(!check_attribute(position, rengine, v)){
      return r;
    }
    v = Flt(self->stamina());
    if(!check_attribute(stamina, rengine, v)){
      return r;
    }
    v = Flt(self->hp());
    if(!check_attribute(hp, rengine, v)){
      return r;
    }
    v = Flt(self->damage());
    if(!check_attribute(damage, rengine, v)){
      return r;
    }
    v = Flt(self->buriedness());
    if(!check_attribute(buriedness, rengine, v)){
      return r;
    }
    // check cond
    if(!cond->isNil()){
      Sexp* result = engine->eval(cond);
      r = (result->equal(Sexp::TrueValue))? Sexp::TrueValue : Sexp::Nil;
    } else 
      r = Sexp::TrueValue;
    return r;
  }

  Sexp* sysfunc_building(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f    = static_cast<FrameSexp*>(form);

    FrameSexp* x    = f->slotvalue(":x");
    FrameSexp* y    = f->slotvalue(":y");
    FrameSexp* id   = f->slotvalue(":id");
    FrameSexp* dist = f->slotvalue(":dist");
    FrameSexp* fieryness  = f->slotvalue(":fieryness");
    FrameSexp* brokenness = f->slotvalue(":brokenness");
    FrameSexp* floors     = f->slotvalue(":floors");

    FrameSexp* cond = f->slotvalue(":cond");
    
    for(Buildings::const_iterator it = rengine->env().buildings().begin();
	it != rengine->env().buildings().end(); it++){

      Building* building = (*it);

      if(isNull(building)) continue;

      // set rewindpoint
      EvalEngine::RewindPoint rp = rengine->rewindpoint();

      Flt v = Flt(building->id());
      if(!check_attribute(id, rengine, v)){
	rengine->rewind(rp) ;
	continue;
      }
      v = Flt(building->x());
      if(!check_attribute(x, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      v = Flt(building->y());
      if(!check_attribute(y, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      v = Flt(rengine->env().distance(building));
      if(rengine->sight_limited()){
	if(v > 30000){
	  rengine->rewind(rp);
	  continue;
	}
      }
      if(!check_attribute(dist, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      v = Flt(building->fieryness());
      if(!check_attribute(fieryness, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      v = Flt(building->brokenness());
      if(!check_attribute(brokenness, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      v = Flt(building->floors());
      if(!check_attribute(floors, rengine, v)){
	rengine->rewind(rp);
	continue;
      }
      if(!cond->isNil()){
	Sexp* result = engine->eval(cond);
	if(!result->equal(Sexp::TrueValue))
	  rengine->rewind(rp);
	else {
	  r = Sexp::TrueValue;
	  break;
	}
      } else {
	r = Sexp::TrueValue;
	break;
      }
    }
    return r;
  };
  
  Sexp* sysfunc_refuge(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f    = static_cast<FrameSexp*>(form);

    FrameSexp* id   = f->slotvalue(":id");
    FrameSexp* dist = f->slotvalue(":dist");

    FrameSexp* cond = f->slotvalue(":cond");


    Flt min = (Flt)S32_MAX;
    Flt max = (Flt)S32_MIN;
    
    Flt tmp_id = 0.0;
    for(Refuges::const_iterator it = rengine->env().refuges().begin();
	it != rengine->env().refuges().end(); it++){

      // Set RewindPoint 
      EvalEngine::RewindPoint rp = rengine->rewindpoint();

      Refuge* refuge = (*it);

      if(isNull(refuge)) continue;

      // check refuge ID
      Flt id_value = Flt(refuge->id());
      //printf("check id : %f\n",id_value);
      if(!check_attribute(id, rengine, id_value)){
	rengine->rewind(rp) ;
	continue;
      }
      // check refuge distance
      Flt dist_value = Flt(rengine->env().distance(refuge));

      //printf("check dist : %f\n",dist_value);
      if(!check_attribute(dist, rengine, dist_value)){
	if(dist->isSymbol()){
	  SubString search_type = dist->symVal();
	  r = Sexp::TrueValue;
	  if(search_type == "min"){
	    if(dist_value < min) {
	      min = dist_value;
	      tmp_id = id_value;
	    } 
	  } 
	  else if(search_type = "max") {
	    if(dist_value > max) {
	      max = dist_value; 
	      tmp_id = id_value;
	    }
	  } else {
	    ITK_WRN("error symbol " << search_type);
	    r = Sexp::Nil ;
	  }
	}
      }
#if 0

      //printf("check dist : %f\n",dist_value);
      if(!check_attribute(dist, rengine, dist_value)){
	if(dist->isSymbol()){
	  SubString search_type = dist->symVal();
	  r = Sexp::TrueValue;
	  if(search_type == "min"){
	    if(dist_value < min) {
	      min = dist_value;
	      tmp_id = id_value;
	    } 
	  } 
	  else if(search_type = "max") {
	    if(dist_value > max) {
	      max = dist_value; 
	      tmp_id = id_value;
	    }
	  } else {
	    ITK_WRN("error symbol " << search_type);
	    r = Sexp::Nil ;
	  }
	}
      }
#endif
      if(!cond->isNil()){
	Sexp* result = rengine->eval(cond);
	if(result->equal(Sexp::TrueValue)){
	  if(tmp_id == 0.0){
	    r = Sexp::TrueValue;
	    break;
	  } else {
	    engine->context().unifyLocal(id, engine->sheap().newFlt(tmp_id));
	    engine->context().letLocal  (id, engine->sheap().newFlt(tmp_id));
	    continue;
	  }
	}
	rengine->rewind(rp);
      } else if(tmp_id != 0.0) {
	engine->context().unifyLocal(id, engine->sheap().newFlt(tmp_id));
	engine->context().letLocal  (id, engine->sheap().newFlt(tmp_id));
	continue;
      } else {
	r = Sexp::TrueValue;
	break;
      }
    }
    return r;
  };
  
  //----------------------------------------------------------------------
  Sexp* sysfunc_node(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    //RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    return r;  
  };
  //----------------------------------------------------------------------
  Sexp* sysfunc_road(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    FrameSexp* id = f->slotvalue(":id");
    FrameSexp* x = f->slotvalue(":x");
    FrameSexp* y = f->slotvalue(":y");
    FrameSexp* width = f->slotvalue(":width");
    FrameSexp* block = f->slotvalue(":brock");
    FrameSexp* linesToHead = f->slotvalue(":linesToHead");
    FrameSexp* linesToTail = f->slotvalue(":linesToTail");
    
    FrameSexp* cond = f->slotvalue(":cond");
    Objects::const_iterator it = 
      rengine->objectpool().objects().begin();
    for(; it != rengine->objectpool().objects().end(); it++){
      Road* road = dynamic_cast<Road*>(*it);
      if(!road) continue;
      EvalEngine::RewindPoint rp = engine->rewindpoint();
      Flt v = Flt(road->id());
      if(!check_attribute(id, rengine, v)){
	engine->rewind(rp) ;
	continue;
      }
      v = Flt(road->x());
      if(!check_attribute(x, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(road->y());
      if(!check_attribute(y, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(road->block());
      if(!check_attribute(block, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(road->width());
      if(!check_attribute(width, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(road->linesToHead());
      if(!check_attribute(linesToHead, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(road->linesToTail());
      if(!check_attribute(linesToTail, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      // check object conditon to select
      if(!cond->isNil()){
	Sexp* result = engine->eval(cond);
	if(!result->equal(Sexp::TrueValue))
	  engine->rewind(rp);
	else {
	  r = Sexp::TrueValue;
	  break;
	}
      } else {
	r = Sexp::TrueValue;
	break;
      }
    }
    return r;
  };
  Sexp* sysfunc_humanoid(Sexp* form, EvalEngine* engine){

    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    FrameSexp* id   = f->slotvalue(":id");
    //FrameSexp* type = f->slotvalue(":type");
    FrameSexp* x    = f->slotvalue(":x");
    FrameSexp* y    = f->slotvalue(":y");
    FrameSexp* pos  = f->slotvalue(":position");
    FrameSexp* stamina    = f->slotvalue(":stamina");
    FrameSexp* hp         = f->slotvalue(":hp");
    FrameSexp* distance   = f->slotvalue(":distance");
    FrameSexp* damage     = f->slotvalue(":damage");
    FrameSexp* buriedness = f->slotvalue(":buriedness");
    
    FrameSexp* cond = f->slotvalue(":cond");
    
    if(rengine->env().civilians().size() == 0)
      return r;

    Humanoids::const_iterator it = rengine->env().civilians().begin();
    for(; it != rengine->env().civilians().end(); it++){
      Humanoid* humanoid = (*it);

      if(isNull(humanoid)) continue;

      if(humanoid->id() == rengine->env().controller().selfid())
	continue;
      
      Object* obj = rengine->objectpool().get(humanoid->id());
      
      Humanoid* h = dynamic_cast<Humanoid *>(obj);
      //ITK_DBG(1);
      MotionlessObject* hoge =
	dynamic_cast<MotionlessObject*>(h->position());
      //ITK_DBG(hoge->id());

      EvalEngine::RewindPoint rp = engine->rewindpoint();
      
      Flt v = Flt(humanoid->id());
      if(!check_attribute(id, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      if(!isNull(humanoid->position())){
	v = Flt(rengine->env().distance(humanoid));
	if(rengine->sight_limited()){
	  if(v > 30000){
	    rengine->rewind(rp);
	    continue;
	  }
	}
      } else {
	return Sexp::Nil;
      }
      v = S32_MAX;
      if(!check_attribute(distance, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->x());
      if(!check_attribute(x, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->y());
      if(!check_attribute(y, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->position()->id());
      if(!check_attribute(pos, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->stamina());
      if(!check_attribute(stamina, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->hp());
      if(!check_attribute(hp, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->damage());
      if(!check_attribute(damage, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      v = Flt(humanoid->buriedness());
      if(!check_attribute(buriedness, rengine, v)){
	engine->rewind(rp);
	continue;
      }
      // check object conditon to select
      if(!cond->isNil()){
	Sexp* result = engine->eval(cond);
	if(!result->equal(Sexp::TrueValue))
	  engine->rewind(rp);
	else {
	  r = Sexp::TrueValue;
	  break;
	}
      } else {
	r = Sexp::TrueValue;
	break;
      }
    }
    return r;
  };

  //------------------------------------------------------------
  // sysfunc: for outputsensor
  //--------------------------------------------------
  //
  Sexp* sysfunc_search(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;

    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);

    FrameSexp* object = f->slotvalue(":object");
    FrameSexp* id = f->slotvalue(":id");
    
    Objects::const_iterator it =
      rengine->objectpool().objects().begin();
    //S32 distance  = S32_MAX;
    Id  target_id = 0;
    if(!object->isNil()){
      SubString objectname = object->symVal();
      for(; it != rengine->objectpool().objects().end(); it++){
	if(objectname.equal("refuge")){
	  Refuge* refuge = dynamic_cast<Refuge*>(*it);
	  if(!refuge) continue; 
	  target_id = refuge->id();
	  break;
	}
      }
    }
    if(id->isNil()){
      Sexp* id_tmp = rengine->eval(id);
      if(id_tmp->isInt())
	target_id = (Id)(id_tmp->intVal());
    }
    if(target_id != 0){
      rengine->env().controller().move_to_refuge(target_id);
      r = RescueAgentBase::bodyAction;
    }
    return r;
  };
  //--------------------------------------------------
  //
  Sexp* sysfunc_move(Sexp* form, EvalEngine* engine){
    Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    FrameSexp* id = f->slotvalue(":id");
    Id target_id = 0;
    if(id->isNil()){
      ITK_WRN("error expression has no :id value/var name "<< form);
      return r;
    }
    if(rengine->isVar(id) || id->isFlt()){
      target_id = (Id)(rengine->eval(id)->fltVal());
    }
    if(target_id){
      rengine->env().controller().move_to(target_id);
      r = RescueAgentBase::bodyAction;
    }
    return r;
  };
  //--------------------------------------------------
  //
  Sexp* sysfunc_say(Sexp* form, EvalEngine* engine){
    //Sexp* r = Sexp::Nil;
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    //FrameSexp* receiver = f->slotvalue(":receiver");
    FrameSexp* content  = f->slotvalue(":content");
    if(!content->isNil()){
      rengine->env().controller().say_message(rengine->eval(content));
    }
    // return RescueAgentBase::sayAction;
    return RescueAgentBase::noAction;
  };


  //----------------------------------------------------------------------
  // for Situation Controller
  // sysfunc_sitaion_add::  (add target_posit_name)
  Sexp* sysfunc_situation_add(Sexp* form, EvalEngine* engine){
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);

    Sexp* posit_name = f->nth(1);
   if(posit_name)
     if(rengine->_agentbase()->situation_add(posit_name)){
       //ITK_DSC(rengine->_agentbase()->situation());
       return RescueAgentBase::changeSituation;
     }
   //ITK_DSC(rengine->_agentbase()->situation());
   return Sexp::Nil;
  };

  // sysfunc_sitaion_remove::  (remove target_posit_name)
  Sexp* sysfunc_situation_remove(Sexp* form, EvalEngine* engine){
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);

    Sexp* posit_name = f->nth(1);
    if(posit_name)
      if(rengine->_agentbase()->situation_remove(posit_name)){
	//ITK_DSC(rengine->_agentbase()->situation());
	return RescueAgentBase::changeSituation;
      }
    //ITK_DSC(rengine->_agentbase()->situation());
    return Sexp::Nil;
  };
  // sysfunc_sitaion_swap::  (swap target_posit_name)
  Sexp* sysfunc_situation_swap(Sexp* form, EvalEngine* engine){
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);

    if(f->length() != 3)  return Sexp::Nil;
    
    Sexp* remove_target = f->nth(1);
    Sexp* add_target    = f->nth(2);
    if(remove_target && add_target)
      if(rengine->_agentbase()->situation_swap(add_target, remove_target))
	return RescueAgentBase::changeSituation;
    //ITK_DSC(rengine->_agentbase()->situation());
    return Sexp::Nil;
    //ITK_DSC(rengine->_agentbase()->situation());
  };
  //------------------------------------------------------------
  // Utility Method
  Sexp* sysfunc_getdist(Sexp* form, EvalEngine* engine){
    RescueEvalEngine* rengine = static_cast<RescueEvalEngine*>(engine);
    FrameSexp* f = static_cast<FrameSexp*>(form);
    //ITK_DBG(rengine->context());
    //ITK_DSC(rengine->context().globalvar());
    if(f->length() != 3) return Sexp::Nil;

    Sexp* from_target = f->nth(1);
    Sexp* to_target   = f->nth(2);

    if((rengine->isVar(from_target) || from_target->isFlt())
       && (rengine->isVar(to_target) || to_target->isFlt())){
      MotionlessObject* from = dynamic_cast<MotionlessObject*>(rengine->objectpool().get((Id)(rengine->eval(from_target)->fltVal())));
      MotionlessObject* to   = dynamic_cast<MotionlessObject*>(rengine->objectpool().get((Id)(rengine->eval(to_target)->fltVal())));
      Flt dist = (Flt)(rengine->env().distance(from, to));
      return rengine->env().scenarioHeap().newFlt(dist);
    }
    return Sexp::Nil;
  };

  //------------------------------------------------------------
  // RescueEvalEngine :: check_attribute
  Bool check_attribute(FrameSexp* attr,
		       RescueEvalEngine* engine,
		       Flt& v){
    if(attr->isNil())
      return True;
    
    if(engine->isVar(attr)){
      engine->context().unifyLocal(attr, engine->sheap().newFlt(v));
      engine->context().letLocal  (attr, engine->sheap().newFlt(v));
      return True;
    } else if(attr->isFlt()){
      if(v == attr->fltVal())
	return True;
    } else if(attr->isCons()){
      Sexp* r = engine->eval(attr);
      if(r->isFlt())
	if(v == attr->isFlt())
	  return True;
    }
     return False;
  };
#if 0
  Bool check_attribute2(FrameSexp* attr,
			RescueEvalEngine* engine,
			Flt& v){
    if(attr->isNil)
      return True;
    
    if(engine->isVar(attr)){
      //TODO: if this variable has already value, then compare this with info
      return True;
    } else if(attr->isFlt()){
      if(v == attr->fltVal())
	return True;
    } else if(attr->isCons()){
      Sexp* r = engine->eval(attr);
      if(r->isFlt())
	if(v == attr->flt())
	  return True;
    }
    return False; 
  }  
#endif

  //------------------------------------------------------------
  // RescueEvalEngine::initFuncTable(Bool)
  void RescueEvalEngine::initFuncTable(Bool forcep) {
    static Bool initp2 = False;
    if(!initp2 || forcep){
      registerFunc("?see", &sysfunc_see);
#if 0
      registerFunc("?hear", &sysfunc_hear);
#endif
      registerFunc("?know", &sysfunc_know);

      registerFunc("world", &sysfunc_world);
      registerFunc("self", &sysfunc_self);
      registerFunc("building", &sysfunc_building);
      registerFunc("refuge", &sysfunc_refuge);
      registerFunc("road", &sysfunc_road);
      registerFunc("humanoid", &sysfunc_humanoid);

      registerFunc("!search", &sysfunc_search);
      registerFunc("!move", &sysfunc_move);
      registerFunc("!say", &sysfunc_say);

      registerFunc("!add", &sysfunc_situation_add);
      registerFunc("!remove", &sysfunc_situation_remove);
      registerFunc("!swap", &sysfunc_situation_swap);
      
      registerFunc("getdist", &sysfunc_getdist);
    }
  };
};
