/*
 * Header    :
 * File      : CivilianController.hxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/16
 * LastUpdate: 2001/11/16
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef __CivilianController_hxx__
#define __CivilianController_hxx__

#include <map>
#include <list>
#include "../itk/itk.h"
#include "../librescue/librescue.hxx"
#include "../rescuelang/EvalEngine.h"
#include "Environment.hxx"
#include "Controller.hxx"

namespace RescueCivilian {
  using namespace Rescue;
  using namespace Itk;

  typedef map<MotionlessObject*, S32> CounterTable;

  class CivilianController : public Controller {
    //--------------------------------------------------
    // CivilianController environemtal information
  public:  
    Environment m_env;
    ITK_DEF_ACCESS(Environment& env(), { return m_env; });

    //--------------------------------------------------
    //
  public:
    Bool needto_cyclep;
    Bool needToCycle(){ return needto_cyclep; };
    void needToCycle2(Sexp* result);
    void nextstep();

    //--------------------------------------------------
    // inter Knowledge Base
  public:
    CounterTable m_NumOfVisited;
    
    //--------------------------------------------------
    // CivilianController :: Constractor
  public:
    virtual ~CivilianController(){};
    CivilianController(Id selfId, const Address& to, const char* filename,
		       LongUDPSocket& socket, Input& input, Output& output) 
      : Controller(selfId, to, socket, input, output){
      env().scanRuleText(filename);
      env().setEnvironmentalInformation(0,input,this);
      init();
    };
    
  protected:
    void init(){
      needto_cyclep = False;
    }
    
  public:
    virtual Sexp* cycle();

    //--------------------------------------------------
    // CivilianController::sensed and heard
  public:
    virtual void sensed(S32 time, 
			LongUDPSocket& socket,
			Input& input, Output& output);
    virtual void heard(LongUDPSocket& socket, Id speaker, const char* message,
		       Input& input, Output& output);
  
  private:
    CivilianController(const CivilianController& source);
    CivilianController& operator= (const CivilianController& rhs);
    bool operator= (const CivilianController& rhs) const;

    //--------------------------------------------------
    // saerch road-path
    MotionlessObject* selectNode(MotionlessObject* current);
    Path setRoadPath(MotionlessObject* start, MotionlessObject* goal);
    Path circuitWalk();
    //--------------------------------------------------
    // utility
    S32 distance(MotionlessObject* from, MotionlessObject* to);
    S32 getAliveLinesToHead(Road* road);
    S32 getAliveLinesToTail(Road* road);
    void sortByHeuristicValue(Path open, CounterTable heuristic); 

    //--------------------------------------------------
    // action
  public:
    void move_to_refuge();
    void move_to_refuge(Id refuge_id);
    void move_to(Id target_id);
    void say_message(Sexp* message);
  };

};
#endif
