#! /bin/sh

if [ $# -ne 2 ]; then
    echo "usage: game.sh <team name> <map file>"
    exit 0
fi
if [ ! -f "$2" ]; then
    echo "error: $2 should be a map file name."
    exit 0
fi

teamname=$1
mapfile=$2

time=`date +%m%d-%H%M%S`

###################################################### EDIT THE DIRECTORY
basename=/tmp/${time}-`hostname`-$teamname-${mapfile##*/}
###################################################### EDIT THE DIRECTORY

logname=${basename}.log
mapname=${basename}.gisini.txt

cp -f "$mapfile" ./gisini.txt
chmod a+wr ./gisini.txt
if [ -e $logname ]; then
echo "error: $logname exits"
    exit 0
fi
if [ -e $mapname ]; then
    echo "error: $mapname exits"
    exit 0
fi
touch $logname
cp $mapfile $mapname

echo "log file: $logname"
echo "map file copy: $mapname"


xterm -e ./0gis.sh &
sleep 5
xterm -e ./1kernel.sh &
sleep 5
xterm -e ./kuwataviewer.sh -l 300 &
xterm -e ./3miscsimulator.sh &
xterm -e ./4morimototrafficsimulator.sh &
xterm -e ./5firesimulator.sh &
xterm -e ./6blockadessimulator.sh &
xterm -e ./7collapsesimulator.sh &
sleep 5

xterm -e ./8civilian.sh &

sleep 10

echo "start your agents (or ./YabAI.sh)"

