
#if !defined(MISCPARAMETER_HXX_INCLUDED) //{
#define MISCPARAMETER_HXX_INCLUDED

#include "Config.hxx"
#include "MISC_ENUM.hxx"
#include "PolygonData.hxx"

namespace Rescue{
//////////////////////////////////////////////////////////////////////////////////////

     class Config;
     class MiscCivilian;
     class PolygonData;

//     typedef std::vector<MiscCivilian*> MCivils;

     ////////////////////////////////////////////////////////////////////////////////
     // class MiscParameter // {
     // Config ե뤫ɤ߹ѥ᡼
     class MiscParameter{
     private:

     protected:

     public:
          S32 brokenPartial;
          S32 brokenHalf;
          S32 brokenAll;
          S32 magnitude;

          S32 buriedness[ATTB_MAX][BROKEN_MAX][SEISMIC_MAX];
          double rateDeathBroken[ATTB_MAX][BROKEN_MAX][SEISMIC_MAX];
          double rateSeriousBroken[ATTB_MAX][BROKEN_MAX][SEISMIC_MAX];
          double rateSlightBroken[ATTB_MAX][BROKEN_MAX][SEISMIC_MAX];

          double rateBury[ATTB_MAX][SEISMIC_MAX];

          PolygonData pData;

     public:
          MiscParameter(){
          }
          MiscParameter(const Config& config): pData(config.shindopolydata()){
               brokenPartial = config.brokenness_partial_collapsed();
               brokenHalf = config.brokenness_half_collapsed();
               brokenAll = config.brokenness_all_collapsed();

               magnitude = config.magnitude_dice();

               int i, j, k;
               for(i = 0; i < ATTB_MAX; i++){
                    for(j = 0; j < BROKEN_MAX; j++){
                         for(k = 0; k < SEISMIC_MAX; k++){
                              buriedness[i][j][k] = 0;
                              rateDeathBroken[i][j][k] = 1.0;
                              rateSeriousBroken[i][j][k] = 1.0;
                              rateSlightBroken[i][j][k] = 1.0;

                         }
                    }
               }

               for(i = 0; i < ATTB_MAX; i++){
                    for(j = 0; j < SEISMIC_MAX; j++){
                         rateBury[i][j] = 0.0;
                    }
               }

               // buriedness ν
               buriedness[WOOD][BROKEN_25][SEISMIC_5] = config.buriedness_wood_partial_5seismic();
               buriedness[WOOD][BROKEN_25][SEISMIC_6] = config.buriedness_wood_partial_6seismic();
               buriedness[WOOD][BROKEN_25][SEISMIC_7] = config.buriedness_wood_partial_7seismic();
               buriedness[WOOD][BROKEN_25][SEISMIC_8] = config.buriedness_wood_partial_8seismic();
               buriedness[WOOD][BROKEN_50][SEISMIC_5] = config.buriedness_wood_half_5seismic();
               buriedness[WOOD][BROKEN_50][SEISMIC_6] = config.buriedness_wood_half_6seismic();
               buriedness[WOOD][BROKEN_50][SEISMIC_7] = config.buriedness_wood_half_7seismic();
               buriedness[WOOD][BROKEN_50][SEISMIC_8] = config.buriedness_wood_half_8seismic();
               buriedness[WOOD][BROKEN_100][SEISMIC_5] = config.buriedness_wood_all_5seismic();
               buriedness[WOOD][BROKEN_100][SEISMIC_6] = config.buriedness_wood_all_6seismic();
               buriedness[WOOD][BROKEN_100][SEISMIC_7] = config.buriedness_wood_all_7seismic();
               buriedness[WOOD][BROKEN_100][SEISMIC_8] = config.buriedness_wood_all_8seismic();
               // buriednessν
               buriedness[STEEL][BROKEN_25][SEISMIC_5] = config.buriedness_steel_partial_5seismic();
               buriedness[STEEL][BROKEN_25][SEISMIC_6] = config.buriedness_steel_partial_6seismic();
               buriedness[STEEL][BROKEN_25][SEISMIC_7] = config.buriedness_steel_partial_7seismic();
               buriedness[STEEL][BROKEN_25][SEISMIC_8] = config.buriedness_steel_partial_8seismic();
               buriedness[STEEL][BROKEN_50][SEISMIC_5] = config.buriedness_steel_half_5seismic();
               buriedness[STEEL][BROKEN_50][SEISMIC_6] = config.buriedness_steel_half_6seismic();
               buriedness[STEEL][BROKEN_50][SEISMIC_7] = config.buriedness_steel_half_7seismic();
               buriedness[STEEL][BROKEN_50][SEISMIC_8] = config.buriedness_steel_half_8seismic();
               buriedness[STEEL][BROKEN_100][SEISMIC_5] = config.buriedness_steel_all_5seismic();
               buriedness[STEEL][BROKEN_100][SEISMIC_6] = config.buriedness_steel_all_6seismic();
               buriedness[STEEL][BROKEN_100][SEISMIC_7] = config.buriedness_steel_all_7seismic();
               buriedness[STEEL][BROKEN_100][SEISMIC_8] = config.buriedness_steel_all_8seismic();
               // buriednessν
               buriedness[RC][BROKEN_25][SEISMIC_5] = config.buriedness_rc_partial_5seismic();
               buriedness[RC][BROKEN_25][SEISMIC_6] = config.buriedness_rc_partial_6seismic();
               buriedness[RC][BROKEN_25][SEISMIC_7] = config.buriedness_rc_partial_7seismic();
               buriedness[RC][BROKEN_25][SEISMIC_8] = config.buriedness_rc_partial_8seismic();
               buriedness[RC][BROKEN_50][SEISMIC_5] = config.buriedness_rc_half_5seismic();
               buriedness[RC][BROKEN_50][SEISMIC_6] = config.buriedness_rc_half_6seismic();
               buriedness[RC][BROKEN_50][SEISMIC_7] = config.buriedness_rc_half_7seismic();
               buriedness[RC][BROKEN_50][SEISMIC_8] = config.buriedness_rc_half_8seismic();
               buriedness[RC][BROKEN_100][SEISMIC_5] = config.buriedness_rc_all_5seismic();
               buriedness[RC][BROKEN_100][SEISMIC_6] = config.buriedness_rc_all_6seismic();
               buriedness[RC][BROKEN_100][SEISMIC_7] = config.buriedness_rc_all_7seismic();
               buriedness[RC][BROKEN_100][SEISMIC_8] = config.buriedness_rc_all_8seismic();

               // rateDeathWood ν
               rateDeathBroken[WOOD][BROKEN_25][SEISMIC_5] = config.rate_wood_death_5seismic();
               rateDeathBroken[WOOD][BROKEN_25][SEISMIC_6] = config.rate_wood_death_6seismic();
               rateDeathBroken[WOOD][BROKEN_25][SEISMIC_7] = config.rate_wood_death_7seismic();
               rateDeathBroken[WOOD][BROKEN_25][SEISMIC_8] = config.rate_wood_death_8seismic();
               rateDeathBroken[WOOD][BROKEN_50][SEISMIC_5] = config.rate_wood_death_5seismic();
               rateDeathBroken[WOOD][BROKEN_50][SEISMIC_6] = config.rate_wood_death_6seismic();
               rateDeathBroken[WOOD][BROKEN_50][SEISMIC_7] = config.rate_wood_death_7seismic();
               rateDeathBroken[WOOD][BROKEN_50][SEISMIC_8] = config.rate_wood_death_8seismic();
               rateDeathBroken[WOOD][BROKEN_100][SEISMIC_5] = config.rate_wood_death_5seismic();
               rateDeathBroken[WOOD][BROKEN_100][SEISMIC_6] = config.rate_wood_death_6seismic();
               rateDeathBroken[WOOD][BROKEN_100][SEISMIC_7] = config.rate_wood_death_7seismic();
               rateDeathBroken[WOOD][BROKEN_100][SEISMIC_8] = config.rate_wood_death_8seismic();

               rateSeriousBroken[WOOD][BROKEN_25][SEISMIC_5] = config.rate_wood_serious_5seismic();
               rateSeriousBroken[WOOD][BROKEN_25][SEISMIC_6] = config.rate_wood_serious_6seismic();
               rateSeriousBroken[WOOD][BROKEN_25][SEISMIC_7] = config.rate_wood_serious_7seismic();
               rateSeriousBroken[WOOD][BROKEN_25][SEISMIC_8] = config.rate_wood_serious_8seismic();
               rateSeriousBroken[WOOD][BROKEN_50][SEISMIC_5] = config.rate_wood_serious_5seismic();
               rateSeriousBroken[WOOD][BROKEN_50][SEISMIC_6] = config.rate_wood_serious_6seismic();
               rateSeriousBroken[WOOD][BROKEN_50][SEISMIC_7] = config.rate_wood_serious_7seismic();
               rateSeriousBroken[WOOD][BROKEN_50][SEISMIC_8] = config.rate_wood_serious_8seismic();
               rateSeriousBroken[WOOD][BROKEN_100][SEISMIC_5] = config.rate_wood_serious_5seismic();
               rateSeriousBroken[WOOD][BROKEN_100][SEISMIC_6] = config.rate_wood_serious_6seismic();
               rateSeriousBroken[WOOD][BROKEN_100][SEISMIC_7] = config.rate_wood_serious_7seismic();
               rateSeriousBroken[WOOD][BROKEN_100][SEISMIC_8] = config.rate_wood_serious_8seismic();

               rateSlightBroken[WOOD][BROKEN_25][SEISMIC_5] = config.rate_wood_slight_5seismic();
               rateSlightBroken[WOOD][BROKEN_25][SEISMIC_6] = config.rate_wood_slight_6seismic();
               rateSlightBroken[WOOD][BROKEN_25][SEISMIC_7] = config.rate_wood_slight_7seismic();
               rateSlightBroken[WOOD][BROKEN_25][SEISMIC_8] = config.rate_wood_slight_8seismic();
               rateSlightBroken[WOOD][BROKEN_50][SEISMIC_5] = config.rate_wood_slight_5seismic();
               rateSlightBroken[WOOD][BROKEN_50][SEISMIC_6] = config.rate_wood_slight_6seismic();
               rateSlightBroken[WOOD][BROKEN_50][SEISMIC_7] = config.rate_wood_slight_7seismic();
               rateSlightBroken[WOOD][BROKEN_50][SEISMIC_8] = config.rate_wood_slight_8seismic();
               rateSlightBroken[WOOD][BROKEN_100][SEISMIC_5] = config.rate_wood_slight_5seismic();
               rateSlightBroken[WOOD][BROKEN_100][SEISMIC_6] = config.rate_wood_slight_6seismic();
               rateSlightBroken[WOOD][BROKEN_100][SEISMIC_7] = config.rate_wood_slight_7seismic();
               rateSlightBroken[WOOD][BROKEN_100][SEISMIC_8] = config.rate_wood_slight_8seismic();

               // rateDeathWood ν
               rateDeathBroken[STEEL][BROKEN_25][SEISMIC_5] = config.rate_steel_death_5seismic();
               rateDeathBroken[STEEL][BROKEN_25][SEISMIC_6] = config.rate_steel_death_6seismic();
               rateDeathBroken[STEEL][BROKEN_25][SEISMIC_7] = config.rate_steel_death_7seismic();
               rateDeathBroken[STEEL][BROKEN_25][SEISMIC_8] = config.rate_steel_death_8seismic();
               rateSeriousBroken[STEEL][BROKEN_50][SEISMIC_5] = config.rate_steel_serious_5seismic();
               rateSeriousBroken[STEEL][BROKEN_50][SEISMIC_6] = config.rate_steel_serious_6seismic();
               rateSeriousBroken[STEEL][BROKEN_50][SEISMIC_7] = config.rate_steel_serious_7seismic();
               rateSeriousBroken[STEEL][BROKEN_50][SEISMIC_8] = config.rate_steel_serious_8seismic();
               rateSlightBroken[STEEL][BROKEN_100][SEISMIC_5] = config.rate_steel_slight_5seismic();
               rateSlightBroken[STEEL][BROKEN_100][SEISMIC_6] = config.rate_steel_slight_6seismic();
               rateSlightBroken[STEEL][BROKEN_100][SEISMIC_7] = config.rate_steel_slight_7seismic();
               rateSlightBroken[STEEL][BROKEN_100][SEISMIC_8] = config.rate_steel_slight_8seismic();

               // rateDeathRc ν
               rateDeathBroken[RC][BROKEN_25][SEISMIC_5] = config.rate_rc_death_5seismic();
               rateDeathBroken[RC][BROKEN_25][SEISMIC_6] = config.rate_rc_death_6seismic();
               rateDeathBroken[RC][BROKEN_25][SEISMIC_7] = config.rate_rc_death_7seismic();
               rateDeathBroken[RC][BROKEN_25][SEISMIC_8] = config.rate_rc_death_8seismic();
               rateSeriousBroken[RC][BROKEN_50][SEISMIC_5] = config.rate_rc_serious_5seismic();
               rateSeriousBroken[RC][BROKEN_50][SEISMIC_6] = config.rate_rc_serious_6seismic();
               rateSeriousBroken[RC][BROKEN_50][SEISMIC_7] = config.rate_rc_serious_7seismic();
               rateSeriousBroken[RC][BROKEN_50][SEISMIC_8] = config.rate_rc_serious_8seismic();
               rateSlightBroken[RC][BROKEN_100][SEISMIC_5] = config.rate_rc_slight_5seismic();
               rateSlightBroken[RC][BROKEN_100][SEISMIC_6] = config.rate_rc_slight_6seismic();
               rateSlightBroken[RC][BROKEN_100][SEISMIC_7] = config.rate_rc_slight_7seismic();
               rateSlightBroken[RC][BROKEN_100][SEISMIC_8] = config.rate_rc_slight_8seismic();

               // Ψν
               rateBury[WOOD][SEISMIC_5] = config.rate_bury_wood_5seismic();
               rateBury[WOOD][SEISMIC_6] = config.rate_bury_wood_6seismic();
               rateBury[WOOD][SEISMIC_7] = config.rate_bury_wood_7seismic();
               rateBury[WOOD][SEISMIC_8] = config.rate_bury_wood_8seismic();
               rateBury[STEEL][SEISMIC_5] = config.rate_bury_steel_5seismic();
               rateBury[STEEL][SEISMIC_6] = config.rate_bury_steel_6seismic();
               rateBury[STEEL][SEISMIC_7] = config.rate_bury_steel_7seismic();
               rateBury[STEEL][SEISMIC_8] = config.rate_bury_steel_8seismic();
               rateBury[RC][SEISMIC_5] = config.rate_bury_rc_5seismic();
               rateBury[RC][SEISMIC_6] = config.rate_bury_rc_6seismic();
               rateBury[RC][SEISMIC_7] = config.rate_bury_rc_7seismic();
               rateBury[RC][SEISMIC_8] = config.rate_bury_rc_8seismic();

#if MISC_DEBUG
               // γǧ
               for(i = 0; i < ATTB_MAX; i++){
                    for(j = 0; j < BROKEN_MAX; j++){
                         for(k = 0; k < SEISMIC_MAX; k++){
                              printf("rateDeathBroken[%d][%d][%d]: %f\n",
                              i,j,k,rateDeathBroken[i][j][k]);
                              printf("rateSeriousBroken[%d][%d][%d]: %f\n",
                              i,j,k,rateSeriousBroken[i][j][k]);
                              printf("rateSlightBroken[%d][%d][%d]: %f\n",
                              i,j,k,rateSlightBroken[i][j][k]);
                         }
                    }
               }
               fflush(NULL);
#endif
          }

          ~MiscParameter(){
          }

          GradeBroken getBrokenGrade(S32 brokenness){
               GradeBroken Bgrade;
               S32 PARTIAL = brokenPartial;
               S32 HALF = brokenHalf;
               S32 ALL = brokenAll;
               if(brokenness <= PARTIAL)
                    Bgrade = BROKEN_25;
               // Ⱦ
               else if(brokenness <= HALF)
                    Bgrade = BROKEN_50;
               // 
               else if(brokenness <= ALL)
                    Bgrade = BROKEN_100;
               else
                    Bgrade = BROKEN_100;

               return Bgrade;
          }
     };
     // } class MiscParameter
     ////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#endif // } !defined(MISCPARAMETER_HXX_INCLUDED)
