// System.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(SYSTEM_HXX__INCLUDED) // {
#define SYSTEM_HXX__INCLUDED

#include "LongUDPSocket.hxx"
#include "Config.hxx"
#include "RescueObjectPool.hxx"
#include "Address.hxx"
#include "LongUDPSocket.hxx"
#include "Input.hxx"
#include "Output.hxx"

namespace Rescue
{
    /////////////////////////////////////////////////////////////////////////
    // System
    
    class Agent;
    /** kernel Υ */
    class System
    {
    private:
        
    protected:
        /** Хʥե */
        FILE* m_logFile;

        /** бѥå */
        LongUDPSocket* m_publicSocket;
        /** ȱѥå */
        LongUDPSocket* m_agentSocket;
        /** ߥ졼ѥå */
        LongUDPSocket* m_simulatorSocket;
        /** GISѥå */
        LongUDPSocket* m_gisSocket;
        /**  */
        Config m_config;
        /** ߥ졼θ߻(ñ:ߥ졼󥵥) */
        S32 m_time;
        /** kernel θ߻(ñms) */
        long m_systemTime;
        /** ƥब٤ƤΥ֥Ȥν */
        RescueObjectPool m_objectPool;
        /** Хåե */
        Input m_inputBuffer;
        /** Хåե */
        Output m_outputBuffer;
        /** ɥ쥹Υꥹ */
        typedef std::list<Address> Addresses;
    public:
        /** Ack Ԥ֥ */
        class AckWaiter {
        public:
            virtual ~AckWaiter() { }
            virtual void send() = 0;    // ack Ԥåtime ιϸƤӤ¦Ԥȡ
        };
    protected:
        /** simulator Υɥ쥹 Ack Ԥ֥ȤؤΥޥå */
        typedef std::map<Address, AutoPtr<AckWaiter> > AddressToAckWaiter;
        AddressToAckWaiter m_addressToAckWaiter;
        /** agent  ID  Ack Ԥ֥ȤؤΥޥå */
        typedef std::map<Id, AutoPtr<AckWaiter> > IdToAckWaiter;
        IdToAckWaiter m_idToAckWaiter;

        /** ³Τ륷ߥ졼Υɥ쥹Υꥹ */
        Addresses m_simulators;
        /** ³ƤGISΥɥ쥹 */
        Address m_gis;
        /** agent ֥Ȥ TypeID Υꥹ */
        std::vector<TypeId> m_agentTypes;
        /** Agent ֥ȤΥꥹȷ */
        typedef std::list<Agent*> Agents;
        /** ³Τʤ Agent ֥ȤΥꥹ */
        Agents* m_pFreeAgents;
        /** ³Τ Agent ֥ȤΥꥹ */
        Agents* m_pConnectedAgents;
        /** ߼¹Ԥ褦ȤƤ륳ޥɤμ̤ Agent Υꥹ */
        typedef std::map<Header, Agents> HeaderToAgents;
        HeaderToAgents m_commandToAngents;
        
        /** Ȥ³Ԥ */
        bool startOk(); // ⤦ߥ졼򳫻ϤƤ⤤
        void setUp();
        bool m_gisConnected;    // GIS ³Ԥ³ʤʤ false³Ѥߤʤ true
        /** ̤³Ȥ򥷥ƥϿ */
        void addFreeAgent(Agent* agent);
        /** ᥤ롼פ¹Ԥ */
        virtual void loop();
        void loopCore(long& count, int division);
        virtual void resetAgents();
        virtual void resetSimulators();

        /** from åꡢ롣*/
        void receiveMessages(LongUDPSocket& from);
        /** å1Ľ롣³Ԥ٤ɤ֤ */
        bool processMessage(const LongUDPSocket& from);
        virtual void processCommand(Agent* agent, Header header, S32 size, Input& input, const LongUDPSocket& from);
        void gisConnectOk(const LongUDPSocket& from);
        void agentConnect(const LongUDPSocket& from);
        void agentAcknowledge(const LongUDPSocket& from);
        void agentConnectError(const LongUDPSocket& from, S32 temporaryId, const char* message);
        void simulatorConnect(const LongUDPSocket& from);
        void simulatorAcknowledge(const LongUDPSocket& from);
        
        /** Ȥؾ */
        virtual void sendToAgents() = 0;
        /** ߥ졼ؾ */
        void sendToSimulators();
        /** ߥ졼GISع */
        void sendUpdate(S32 time);
        /** ѽ */
        void step();

    public:
        virtual void outputObjectForAgentsAtStart(const Object* o, Output& buffer);
        virtual void outputObjectForAgents(const Object* o, Output& buffer);

        virtual ~System();
        System(const std::vector<TypeId>& agentTypes);

        /** бѥå */
        LongUDPSocket& publicSocket();
        /** ȱѥå */
        LongUDPSocket& agentSocket();
        /** ߥ졼ѥå */
        LongUDPSocket& simulatorSocket();
        /** GISѥå */
        LongUDPSocket& gisSocket();
        /**  */
        Config& config();
        /** ƥब٤ƤΥ֥Ȥν */
        RescueObjectPool& objectPool();

        /* ::main Ϥ줿ѥ᥿ǥƥ¹Ԥ */
        void main(int argc, char const* const* argv); //throw(std::exception)
        
    private:
        System(const System& source);
        System& operator= (const System& rhs);
        bool operator== (const System& rhs) const;
    };
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "System.inl"
#endif

#endif // } !defined(SYSTEM_HXX__INCLUDED)
