// RescueObjectPool.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(RESCUEOBJECTPOOL_HXX__INCLUDED) // {
#define RESCUEOBJECTPOOL_HXX__INCLUDED

#include "ObjectPool.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// RescueObjectPool

	class Input;
	class Output;
	/** ֥Ȥν */
	class RescueObjectPool : public ObjectPool
	{
	private:
		
	protected:
		/** FlammableBuilding 򤽤ΰ֤˱ƥåϿ */
		int m_meshXBase;	// åθ֤ɸ
		int m_meshYBase;
		int m_meshXSize;	// åΣޥΥ
		int m_meshYSize;
		int m_meshXCount;	// åΥޥο
		int m_meshYCount;
		typedef std::vector< std::vector< Objects > > Mesh;
		Mesh m_mesh;
		Objects m_unregisterdBuilding;
		/*
		 * XSize
		 * <--->
		 * +---+---+  <-- YBase
		 * |   |   |
		 * +---+---+
		 * |   |   |
		 * +---+---+
		 *
		 */

	public:
		virtual ~RescueObjectPool();
		RescueObjectPool();

		virtual Object* newObject(TypeId type);

		/**
		* ֥ȤϿ롣
		* @param	newObject
		*				Ͽ륪֥ȡΥ֥Ȥ      
		*				ObjectPool ˤä delete 롣id ѤߤǤ뤳ȡ
		*/
		virtual void add(Object* newObject);

		/** αߤˤǽΤ FlammableBuilding 󤹤 */
		class Enumerator {
			friend RescueObjectPool;
		private:
			RescueObjectPool* m_owner;
			double m_centerX;
			double m_centerY;
			double m_squaredRadius;
			int m_x;
			int m_y;
			int m_xMin;
			int m_xMaz;
			int m_yMin;
			int m_yMaz;
			Objects::const_iterator m_it;
			Enumerator(RescueObjectPool* owner, S32 x, S32 y, S32 r);
			Object* nextCore();
		public:
			Object* next();
		};
		friend Enumerator;
		/** αߤˤƤ FlammableBuilding 󤹤 */
		Enumerator objectsInRound(S32 x, S32 y, S32 r);
		/** å()ۤ */
		void setUpMesh(int meshX, int meshY);
	public:

	private:
		RescueObjectPool(const RescueObjectPool& source);
		RescueObjectPool& operator= (const RescueObjectPool& rhs);
		bool operator== (const RescueObjectPool& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "RescueObjectPool.inl"
#endif

#endif // } !defined(RESCUEOBJECTPOOL_HXX__INCLUDED)
