// RescueObjectPool.cxx
//
/////////////////////////////////////////////////////////////////////////////

#include "common.hxx"
#include "RescueObjectPool.hxx"

#ifndef NDEBUG
#  include "RescueObjectPool.inl"
#endif

#include "FlammableBuilding.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// RescueObjectPool
	
	RescueObjectPool::~RescueObjectPool()
	{
	}

	Object* RescueObjectPool::newObject(TypeId type)
	{
		if(type == TYPE_BUILDING)
			return new FlammableBuilding(this);
		return ObjectPool::newObject(type);
	}

	void RescueObjectPool::setUpMesh(int meshX, int meshY)
	{
		m_meshXCount = meshX;
		m_meshYCount = meshY;

		m_unregisterdBuilding.clear();
		m_mesh.clear();
		m_mesh.resize(m_meshYCount);
		for(int i=0; i<m_meshYCount; i++)
			m_mesh[i].resize(m_meshXCount);

		S32 xMin = S32_MAX;
		S32 yMin = S32_MAX;
		S32 xMax = S32_MIN;
		S32 yMax = S32_MIN;
		Objects::const_iterator it = objects().begin();
		for(; it != objects().end(); it++) {
			FlammableBuilding* ro = dynamic_cast<FlammableBuilding*>(*it);
			if(ro != 0) {
				S32 x = ro->x();
				if(x < xMin)
					xMin = x;
				if(x > xMax)
					xMax = x;
				S32 y = ro->y();
				if(y < yMin)
					yMin = y;
				if(y > yMax)
					yMax = y;
			}
		}

		m_meshXBase = xMin;
		m_meshYBase = yMin;
		m_meshXSize = (xMax - xMin) / m_meshXCount + 1;
		m_meshYSize = (yMax - yMin) / m_meshYCount + 1;
		it = objects().begin();
		for(; it != objects().end(); it++) {
			Object* o = *it;
			if(dynamic_cast<RealObject*>(o) != 0) {
				FlammableBuilding* mlo = dynamic_cast<FlammableBuilding*>(o);
				if(mlo != 0) {
					int x = (mlo->x() - m_meshXBase) / m_meshXSize;
					if(x >= m_meshXCount)	x = m_meshXCount - 1;
					if(x < 0)				x = 0;
					int y = (mlo->y() - m_meshYBase) / m_meshYSize;
					if(y >= m_meshYCount)	y = m_meshYCount - 1;
					if(y < 0)				y = 0;
					m_mesh[y][x].push_back(mlo);
				}
			}
		}
	}
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
