// LongUDPSocket.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(LONGUDPSOCKET_HXX__INCLUDED) // {
#define LONGUDPSOCKET_HXX__INCLUDED

#include "UDPSocket.hxx"
#include "AutoPtr.hxx"
//#include "Vector.hxx"

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// LongUDPSocket
	
	class Input;
	class Output;
	class LongUDPSocket
	{
	private:
		friend Input;
		
	protected:
		std::string m_name;	// ϥե̾
		FILE* m_fp;			// ե롣Ϥʤʤ NULL
		mutable long m_sizeReceiveBuffer;
		S16 m_counter;	// ID 
		mutable UDPSocket m_socket;
		Address m_addressRecievedFrom;
		struct Page {
			unsigned int m_size;		// buffer  header ΤǡΥ
			unsigned int m_capacity;	// buffer  new Υ
			Byte* m_buffer;
			Page(int capacity) {
				m_capacity = capacity;
				m_buffer = new Byte[capacity];
				m_size = 0;
			}
			~Page() {
				delete[] m_buffer;
			}
			unsigned int size() {
				return m_size;
			}
			Byte* top() {
				return m_buffer + m_buffer[1];
			}
		private:
			Page(const Page&);
			void operator= (const Page&);
		};
		typedef std::vector<AutoPtr<Page> > Pages;
		struct Book {
			Address from;
			S16 id;
			Pages pages;
			Book(int size) : pages(size) {
			}
		};
		typedef std::list<AutoPtr<Book> > Books;
		mutable Books m_booksIncomplete;
		mutable Books m_booksComplete;
		
		void eat(bool block) const;

	public:
		virtual ~LongUDPSocket();
		/** ꤵ줿 Address ĥåȤȤƹۤ */
		LongUDPSocket(const Address& self = Address(INADDR_ANY, 0, true), const std::string& name = ""); //throw(SocketError)
		LongUDPSocket(const std::string& name); //throw(SocketError)
		
		/** to  */
		bool send(const Output& output, const Address& to, long logedID=-1);
		/**
		* åʤ true 򡢤 false ֤empty() ΤȤ 
		* receive  åޤǥ֥å롣!empty() ΤȤ  
		* receive Ϥ˽λ롣
		*/
		bool empty() const;
		/**
		* å롣
		* @return		 trueԤ false
		*/
		bool receive(Input& input, long logedID=-1);	// TODO: 顼㳰֤
		/** ľ receive Ǽå */
		const Address& addressRecievedFrom() const;

		/** åȤΤɤ줫åޤԤġॢȤξ 0 ֤ */
		static int wait(const std::vector<const LongUDPSocket*>& sockets, int ms);

	private:
		LongUDPSocket(const LongUDPSocket& source);
		LongUDPSocket& operator= (const LongUDPSocket& rhs);
		bool operator== (const LongUDPSocket& rhs) const;
	};
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#ifdef NDEBUG
#  include "LongUDPSocket.inl"
#endif

#endif // } !defined(LONGUDPSOCKET_HXX__INCLUDED)
