// FlammableBuilding.inl
//
/////////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
//#  include
#endif

#include "RescueObjectPool.hxx"

#ifndef NDEBUG
#  define inline
#else
#  define inline inline
#endif

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// FlammableBuilding
	
	inline FlammableBuilding::FlammableBuilding(RescueObjectPool* pool)
	{
		m_owner = pool;
		m_fuel = m_initialFuel;
		m_flame = 0;
	}
	
	inline void FlammableBuilding::ignite()
	{
		if(m_flame < 1)
			m_flame = 1;
	}
	inline void FlammableBuilding::extinguish()
	{
		m_flame = 0;
	}

	inline void FlammableBuilding::step(S32 time)
	{
		m_flame *= 1.3;
		if(m_flame >= m_initialFuel / 30)
			m_flame = m_initialFuel / 30;
		m_fuel -= (S32)m_flame;
		if(m_fuel < 0)
			m_fuel = 0;
		
		S32 fire;
		if(m_fuel >= m_initialFuel) {
			fire = 0;	// ̵
		} else {
			if(m_flame == 0) {
				fire = 4;	// ̵ǤϤʤǳƤʤ
			} else {
				if(m_fuel >= m_initialFuel*2/3) {
					fire = 1;	// ǳϤ
				} else if(m_fuel >= m_initialFuel*1/3) {
					fire = 2;	// 
					ignitePeriphery();
				} else if(m_fuel > 0) {
					fire = 3;	// 
				} else {
					fire = 6;	// ǳԤ
				}
			}
		}
		if(fire != fieryness())
			setFieryness(time, fire);
	}
	inline void FlammableBuilding::ignitePeriphery()
	{
		const long r = 30000;
		RescueObjectPool::Enumerator e = m_owner->objectsInRound(x(), y(), r);
		Object* o;
		while(o = e.next(), o != 0) {
			ASSERT(dynamic_cast<FlammableBuilding*>(o) != 0);
			FlammableBuilding* fb = (FlammableBuilding*)o;
			double dx = x() - fb->x();
			double dy = y() - fb->y();
			double s = (dx*dx + dy*dy) / (r*r);
			if(s < (double)rand()/RAND_MAX)
				fb->ignite();
		}
	}

	/*inline FlammableBuilding::FlammableBuilding(const FlammableBuilding& source)
	{
		FlammableBuilding();
		operator= (source);
	}
	inline FlammableBuilding& FlammableBuilding::operator= (const FlammableBuilding& rhs)
	{
		if(this == &rhs)
			return *this;
		return *this;
	}
	inline bool FlammableBuilding::operator== (const FlammableBuilding& rhs) const
	{
		if(this == &rhs)
			return true;
	}*/
	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue
#undef inline
