#include <stdlib.h>
#include <math.h>
#define  SLICES  100  //number of slices for integral

//prototypes
double psi(double x);

double Phi(double x){
  double z = 0; //the sigma part
  double y = 0; //the answer
  long int n = 0; //count up to SLICES
  
  for (n=0;n<=SLICES;n++){
    z += psi((double)n*x/(double)SLICES) + psi((double)(n+1)*x/(double)SLICES);
  }
  
  y = 0.5 + x*z/(2*(double)SLICES);
  return (y);
}

double psi(double x){
  //printf ("psi = %f\n", exp(-pow(x, 2)/2)/sqrt(2*M_PI) );
  const double pi = 3.14159265358979323846;
  return ( exp(-1*pow(x, 2)/2)/sqrt(2*pi) );
}
