// AutoPtr.hxx
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AUTOPTR_HXX__INCLUDED) // {
#define AUTOPTR_HXX__INCLUDED

namespace Rescue
{
	/////////////////////////////////////////////////////////////////////////
	// AutoPtr
#if 1
	// Ť std::auto_ptr ߴ(assertion դ)
	template<class T>
		class AutoPtr
	{
		static std::set<void*> m_livings;
		
	private:
		T* m_ptr;
		mutable bool m_indicator;
		
	protected:
		
	public:
		typedef T element_type;
		~AutoPtr() {
			if(m_ptr != 0) {
				if(m_indicator) {
					ASSERT(m_livings.erase((void*)m_ptr) > 0);
					delete m_ptr;
				}
			}
		}
		explicit AutoPtr(T *p = 0) {
			m_ptr = p;
			if(m_ptr != 0) {
				ASSERT(m_livings.insert((void*)m_ptr).second);
			}
			m_indicator = (m_ptr != 0);
		}
		AutoPtr(const AutoPtr<T>& rhs) {
			m_ptr = rhs.get();
			m_indicator = rhs.m_indicator;
			rhs.release();
		}
		AutoPtr<T>& operator= (const AutoPtr<T>& rhs) {
			if(m_ptr != 0) {
				if(m_indicator) {
					ASSERT(m_livings.erase((void*)m_ptr) > 0);
					delete m_ptr;
				}
			}
			m_ptr = rhs.get();
			m_indicator = rhs.m_indicator;
			rhs.release();
			return *this;
		}
		
		T& operator* () const {
			ASSERT(get());
			return *get();
		}
		T* operator->() const {
			ASSERT(get());
			return get();
		}
		T* get() const {
			if(m_ptr != 0) {
				ASSERT(m_livings.find((void*)m_ptr) != m_livings.end());
			}
			return m_ptr;
		}
		T* release() const {
			m_indicator = false;
			return get();
		}
	};

	template<class T>
		std::set<void*> AutoPtr<T>::m_livings;
#elif 0
	// std::auto_ptr ߴ(assertionդ)
	template <class T>
		class AutoPtr
	{
	private:
		mutable T* m_ptr;
#ifndef NDEBUG
		mutable bool m_broken;
#endif
		void setBroken(bool broken) const {
#ifndef NDEBUG
			m_broken = broken;
#endif
		}
		
	public:
		typedef T element_type;
		~AutoPtr() {
			delete m_ptr;
		}
		explicit AutoPtr(T* p = 0) {
			m_ptr = p;
			setBroken(false);
		}
		AutoPtr(const AutoPtr<T>& ap) {
			reset(ap.get());
			ap.m_ptr = 0;
			ap.setBroken(true);
		}
		AutoPtr<T>& operator=(const AutoPtr<T>& ap) {
			reset(ap.get());
			ap.m_ptr = 0;
			ap.setBroken(true);
			return *this;
		}
		T& operator*() const {
			ASSERT(get());
			return *get();
		}
		T* operator->() const {
			ASSERT(get());
			return get();
		}
		T* get() const {
			ASSERT(!m_broken);
			return m_ptr;
		}
		T* release() {
			T* result = m_ptr;
			delete m_ptr;
			m_ptr = 0;
			setBroken(false);
			return result;
		}
		void reset(T* p = 0) {
			delete m_ptr;
			m_ptr = p;
			setBroken(false);
		}
	};

#elif 1
	// ե󥹥ȤˤGC
	template<class T>
		class AutoPtr
	{
	public:
		typedef std::map<void*, int> Map;

	private:
		T* m_ptr;
		static Map m_referenceCounters;
		
	protected:
		void set(T* ptr) {
			m_ptr = ptr;
			if(m_ptr != 0) {
				Map::iterator it = m_referenceCounters.find((void*)m_ptr);
				if(it == m_referenceCounters.end())
					m_referenceCounters[(void*)m_ptr] = 1;
				else
					++it->second;
			}
		}
		void release() {
			if(m_ptr != 0) {
				Map::iterator it = m_referenceCounters.find((void*)m_ptr);
				ASSERT(it != m_referenceCounters.end());
				ASSERT(it->second >= 1);
				if(--(it->second) <= 0) {
					delete m_ptr;
					m_referenceCounters.erase(it);
				}
				m_ptr = 0;
			}
		}
		
	public:
		typedef T element_type;
		~AutoPtr() {
			release();
		}
		explicit AutoPtr(T *p = 0) {
			set(p);
		}
		AutoPtr(const AutoPtr<T>& rhs) {
			set(rhs.m_ptr);
		}
		AutoPtr<T>& operator= (const AutoPtr<T>& rhs) {
			if(m_ptr != rhs.m_ptr) {
				release();
				set(rhs.m_ptr);
				//rhs.release();
			}
			return *this;
		}
		
		T& operator* () const {
			ASSERT(get());
			return *get();
		}
		T* operator->() const {
			ASSERT(get());
			return get();
		}
		T* get() const {
			return m_ptr;
		}
	};

	template<class T>
		AutoPtr<T>::Map AutoPtr<T>::m_referenceCounters;
#else
	// Ť std::auto_ptr ߴ
	template<class T>
		class AutoPtr
	{
	private:
		T* m_ptr;
		mutable bool m_indicator;
		
	protected:
		
	public:
		typedef T element_type;
		~AutoPtr() {
			if(m_indicator)
				delete m_ptr;
		}
		explicit AutoPtr(T *p = 0) {
			m_ptr = p;
			m_indicator = (m_ptr != 0);
		}
		AutoPtr(const AutoPtr<T>& rhs) {
			m_ptr = rhs.m_ptr;
			m_indicator = rhs.m_indicator;
			rhs.release();
		}
		AutoPtr<T>& operator= (const AutoPtr<T>& rhs) {
			if(m_indicator)
				delete m_ptr;
			m_ptr = rhs.m_ptr;
			m_indicator = rhs.m_indicator;
			rhs.release();
			return *this;
		}
		
		T& operator* () const {
			ASSERT(get());
			return *get();
		}
		T* operator->() const {
			ASSERT(get());
			return get();
		}
		T* get() const {
			return m_ptr;
		}
		T* release() const {
			m_indicator = false;
			return m_ptr;
		}
	};
#endif

	
	/////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#endif // } !defined(AUTOPTR_HXX__INCLUDED)
