#include "common.hxx"
#include "basic.hxx"
#include "Config.hxx"
#include "Address.hxx"
#include "Input.hxx"
#include "Output.hxx"
#include "LongUDPSocket.hxx"
#include "ObjectPool.hxx"
#include "objects.hxx"
#include "simBlockage.h"
#include <iostream.h>
#define  MAX(x,y)  ( ( (x) >= (y) ) ? (x) : (y) )

using namespace Rescue; 

//prototypes
int main2(int argc, char** argv);
void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool, ExtRoads difRoads, ExtRoads::const_iterator drit, ExtRoad* extrPtr, int block_param, int area_per_repair_cost);


int main(int argc, char** argv)
{
  try {
    return main2(argc, argv);
  } catch(std::exception& e) {
    fprintf(stderr, "%s\n", (const char*)e.what());
  } catch(...) {
    fprintf(stderr, "error...\n");
  }
  return 1;
  
}

const char* shindopolydata = "";
int main2(int argc, char** argv)
{
  const char* host = "localhost";
  Config config;
  int block_param = 1000;
  
  // 
  int i;
  long int count = 0;
  for(i=1; i<argc; i++) {
    printf("argv[%d] = %s\n", i, argv[i]);
    if(argv[i][0] == '-') {
      if(strcmp(argv[i], "-file") == 0) {
        if(++i < argc) {
          config.readConfigFile(argv[i]);
        } else {
          fprintf(stderr, "error: '-file'\n");
        }
      } else {
        if(++i < argc) {
          if(!config.setValue(argv[i-1]+1, argv[i]))
            fprintf(stderr, "error: '%s'\n", argv[i]);
        } else {
          fprintf(stderr, "error: '%s'\n", argv[i-1]);
        }
      }
    } else {
      switch(count++) {
      case 0:
        block_param = (int)argv[i];
        break;
      case 1:
        host = argv[i];
        break;
      default:
        fprintf(stderr, "error: '%s'\n", argv[i]);
        break;
      }
    }
  }
  shindopolydata = config.shindopolydata().c_str();
  
  // åȺ
  LongUDPSocket socket;
  Input input;
  Output output;
  output.setWait(config.send_udp_wait());
  output.resetFrameSize(config.send_udp_size());
  Address to(host, config.port());      //
  
  //////////////////////////////////////////
  //Ƽ
  TypeId type;
  //Id objId; //֥Ȥֹ̤
  Objects all; //٤ƤΥ֥ȤΥꥹ  
  Objects::const_iterator oit;
  Objects::const_iterator suboit;
  Objects entranceList;
  Objects::const_iterator entit;
  Roads roads;
  Roads::const_iterator rit;
  Nodes nodes;
  Nodes::const_iterator nit;
  Buildings buildings;     
  Buildings::const_iterator bit;
  ExtRoads extRoads;  
  ExtRoads::const_iterator xrit;  
  ExtNodes extNodes;  
  ExtNodes::const_iterator xnit;  
  ExtRoads difRoads; //ΤäextRoadΥꥹ  
  ExtRoads::const_iterator drit;

  
  Object* objPtr; //ObjectsobjectļФƤ
  long int rNum = 0; //roadο
  long int subrNum =0; //orܰʾroadҤäƤnoderoad³
  long int brNum = 0; //number of blocked roads
  Road* rPtr;
  Node* nPtr;
  Building* bPtr;
  ExtRoad* extrPtr;
  ExtNode* extnPtr;
  short int shindo;  
  long int kscon = 0; //KS_CONNECT_OK
  long int kscom = 0; //KS_COMMANDS
  long int ksup = 0; //KS_UPDATE
  long int brokennessSum = 0; //ݲ٤(ݲå뤿)
  unsigned int kscom_success = 0; //KS_COMMANDSflag
  unsigned int ksup_success = 0; //KS_UPDATEflag
  float parameter = 0.0; //RoboCupñƻϩ / ǥñƻϩ
  
  long int results[100];

  //ΰΥץѥƥ
  areaProperty area[4];
  areaProperty* areaPtr;
  areaPtr = area;
  initArea(areaPtr);

  double bisum = 0;
  double bbar = 0;
  double Sb = 0;
  double dbar = 0;
  double Sd = 0;


  //ΰϿޤɤ߹
  long int polyNum;
  long int pointNum;
  coordinates *polyPtr = NULL;
  polyPtr = getPoly(&polyNum, &pointNum, polyPtr);
  
  
  // ³å
  printf("connecting...\n");
  output.clear();                                                               //ϥХåեˤ
  output.put(SK_CONNECT);                                               //ϥХåե SK_CONNECT (4ХȤ)Ϥ
  Output::Cursor base = output.put(~(S32)0);    //body ΥȤƤȤꤢߡͤϤƤơbase ˤΰ֤򵭲롣
  output.put(0);                                                                //ϥХåե 0 Ϥ
  output.setSize(base);                                         //base ǵ֤ˡbase 餳ޤǤ put Хȿꤹ롣
  output.put(HEADER_NULL);
  socket.send(output, to);                                      //output  put Х to 롣
  
  // å롼
  S32 time = 0;
  ObjectPool pool;
  for(;;) {
    try {
      socket.receive(input);    // TODO: 顼㳰֤     //ǡinput ߤ롣
      for(;;) {
        Header header = input.get();    //input (4ХȤ)ǡФheader 
        if(header == HEADER_NULL)
          break;
        
        S32 size = input.get();
        Input::Cursor start = input.cursor();   //ɤ߽ФƤ֤򵭲
        
        switch(header) {
        default:
          printf("Unknown header.\n");
          break;
        case KS_CONNECT_ERROR:
          printf("Connection failed.\n");
          return 1;
          
        //////////////////////////////////////////////////////start of case KS_CONNECT_OK
        case KS_CONNECT_OK:
          ++kscon;
          if (kscon >= 2) {
            printf("got KS_CONNECT %ld times, using first KS_CONNECT\n", kscon);
            break;
          }
          printf("Connect Ok %ld.\n", kscon);

          to = socket.addressRecievedFrom();    //ʹߤѹ
          pool.restructure(0, input);                   //ɥǥ롣
          // ack ֤
          output.clear();
          output.put(SK_ACKNOWLEDGE);
          output.put(~(S32)0);
          output.put(HEADER_NULL);
          socket.send(output, to);
          
          
          /////////////////////////////////////////////////////////
          //֥Ȥroads,nodes˻ʬ
          all = pool.objects();
          oit = all.begin();
          
          for ( ; oit != all.end(); oit++){
            objPtr = *oit;
            type = objPtr->type();            
            switch(type){
            case TYPE_ROAD:
              ++rNum;
              rPtr = dynamic_cast<Road*>(objPtr);
              roads.push_back(rPtr);
              break;
            case TYPE_NODE:
              nPtr = dynamic_cast<Node*>(objPtr);
              
              //subrNumupdate
              suboit = nPtr->edges().begin();
              count = 0;
              for ( ; suboit != nPtr->edges().end(); suboit++){
                objPtr = *suboit;
                if (objPtr->type() == TYPE_ROAD)
                  ++count;
              } //for ( ; suboit != nPtr->edges().end(); suboit++)
              if (count != 0 && count != 2)
                subrNum += count; //1or3ܰʾroadҤäƤû
              
              nodes.push_back(nPtr);
              break;
            } //switch
          } //for ( ; oit != all.end(); oit++)
          
          printf("number of roads = %ld\n", rNum);
          //printf("ʬλ\n");
          
          //RoboCupñƻϩ / ǥñƻϩ η׻
          parameter = (float)rNum / (float)((int)((float)subrNum+0.5)/2);
          printf("large road units / small road units = %f\n", parameter);
                    
          extrPtr = new ExtRoad[roads.size()]; //class
          extnPtr = new ExtNode[nodes.size()]; //class

          //////////////////////////////////////////////////////////////////
          //extRoads
          rit = roads.begin();
          for( ; rit != roads.end() ; rit++, extrPtr++){
            rPtr = *rit;
            
            //ExtRoad
            extrPtr->set_extId(rPtr->id());
            extrPtr->setHead(time, rPtr->head());
            extrPtr->setTail(time, rPtr->tail());
            extrPtr->setWidth(time, rPtr->width());
            extrPtr->setLength(time, rPtr->length());
            extrPtr->init_headBrokenAvr();
            extrPtr->init_tailBrokenAvr();
            extrPtr->set_shindo(0);
            
            ///////////////////////////////////////////////////////////////
            //road濴κɸݥꥴȽΥ⥸塼Ϥ,٤餦  
            //headxɸ(extrPtr->head())->x()
            shindo = (short int)getShindo( ((rPtr->head())->x()+(rPtr->tail())->x())/2,
                                           ((rPtr->head())->y()+(rPtr->tail())->y())/2,
                                           polyNum,
                                           polyPtr );
            extrPtr->set_shindo(shindo);

            // ƻ2mѤν
            /*if (shindo > 0)
              shindo = shindo -1;*/

            //////////////////////////////////////////
            //ƿΰˤroadܿ򥢥åץǡ
            switch(shindo){
            case 1: //٣ʲ
              ++(areaPtr->areaRNum);
              break;
            case 2: //٣
              ++((areaPtr+1)->areaRNum);
              break;
            case 3: //٣
              ++((areaPtr+2)->areaRNum);              
              break;
            case 4: //Ķ٣
              ++((areaPtr+3)->areaRNum);
              break;
            } //switch
            
            extRoads.push_back(extrPtr);
            
          }//( ; rit != roads.end(); rit++ extrPtr++)
          
          //printf("shido 1 : %d roads\n", areaPtr->areaRNum);
          //printf("shido 2 : %d roads\n", (areaPtr+1)->areaRNum);
          //printf("shido 3 : %d roads\n", (areaPtr+2)->areaRNum);
          //printf("shido 4 : %d roads\n", (areaPtr+3)->areaRNum);
          
          
          //////////////////////////////////////////////////////////////////
          //extNodes
          nit = nodes.begin();
          
          for( ; nit != nodes.end(); nit++, extnPtr++){
            nPtr = *nit;
            
            //ExtNodes
            extnPtr->set_Id(nPtr->id());
            extnPtr->init_brokens();
            extNodes.push_back(extnPtr);
            //printf("id of extNode = %d\n", extnPtr->get_extId());            
          }//for( ; nit != nodes.end() ; nit++ nPtr++)
          
          /*
            //test
            xnit = extNodes.begin();
            for ( ; xnit != extNodes.end(); xnit++){
            extnPtr = *xnit;
            printf("id of extNode = %d\n", extnPtr->get_extId());
            }
          */
          
          
          delete[]polyPtr;  //ݥꥴѥγ
          
          printf("end of KS_CONNECT_OK %ld\n", kscon);
          break; // case KS_CONNECT_OK
          //////////////////////////////////////////////////////end of case KS_CONNECT_OK
          
          
        case KS_COMMANDS:
          ++kscom;
          printf("KS_COMMANDS %ld\n", kscom);
          if (ksup_success == 1 && kscom_success == 1) { //Ƥʤв⤷ʤ
            printf("sending nothing...\nend of KS_COMMANDS %ld\n\n", kscom);
            break; //case KS_COMMANDS
          }
          if (ksup_success == 1 && kscom_success != 1) { //update⤦Ƥư٤Ƥʤʤ
            commands(time, input, output, socket, to, pool, difRoads, drit, extrPtr, block_param, config.area_per_repair_cost());
            printf("time = %ld.\n", (long)time);
            kscom_success = 1;
            printf("sended road blockades\n");
            break; //case KS_COMMANDS
          }
          break;
          
        /////////////////////////////////////////////////////////////start of KS_UPDATE
        case KS_UPDATE:
          ++ksup;
          printf("KS_UPDATE %ld\n", ksup);
          if (ksup_success == 1) {
            printf("reading nothing...\n");         
            break;
          }

          time = input.get();
          pool.restructure(time, input);
          
          //////////////////////////////////////////
          //buildingФbuildings         
          //printf("buildingФbuildings\n");
          all = pool.objects();
          oit = all.begin();          
          for ( ; oit != all.end(); oit++){            
            objPtr = *oit;
            type = objPtr->type();       
            switch(type){
            case TYPE_BUILDING:
              bPtr = dynamic_cast<Building*>(objPtr);
              brokennessSum += bPtr->brokenness();
              buildings.push_back(bPtr);
              break;
            } //switch
          } //( ; oit != all.end(); oit++)

          ///////buildingμߤޤԤäƤ뤫å
          printf("size of buildings list = %d\n", buildings.size());
          printf("sum of brokenness = %ld\n", brokennessSum);
          if (buildings.size() == 0 || brokennessSum == 0) {
            printf("couldn't get the building collapse info.\ntrying the next KS_UPDATE.\n");
            break;
          }
          printf("got the building collapse info\n");
          
          //////////////////////////////////////////////////////////////
          //ƤbuildingˤĤơݲ٤³ƤextNodeˤ 
          //printf("ƤbuildingˤĤơݲ٤³ƤextNodeˤ\n");
          
          bit = buildings.begin();
          for( ; bit != buildings.end(); bit++){
            bPtr = *bit;
            entranceList = bPtr->entrances(); //ObjectsnodeϤ
            
            //building³Ƥnodeݲپ򤿤
            entit = entranceList.begin();
            for( ; ; entit++){
              if (entit == entranceList.end())
                break;
              
              objPtr = *entit;
              nPtr = dynamic_cast<Node*>(objPtr);
              
              //nodeidȰפextNodeõ                            
              xnit = extNodes.begin();              
              for( ; xnit != extNodes.end() ; xnit++){
                extnPtr = *xnit;
                //printf("xnid, nid = %d, %d\n", extnPtr->get_extId(), nPtr->id());
                if(extnPtr->get_extId() == nPtr->id())
                  break;      
              } //for( ; xnit != extNodes.end() ; xnit++)              
              
              extnPtr->add_brokenSum(bPtr->brokenness()); //ݲ٤nodeˤ              
              //printf("brokenAvr of node %d = %d\n", extnPtr->get_extId(), extnPtr->get_brokenAvr());
              
            } //for( ; ; entit++)
            
          } //for( ; bit != buildings.end(); bit++)
          
          
          ///////////////////////////////////////////////////////////////
          //ƤextRoadˤĤơheadBrokenAvrtailBrokenAvr
          //ơΰ褴Ȥݲ٤¤ξümaxͤ¤򥢥åץǡ
          //printf("ƤextRoadˤĤơheadBrokenAvrtailBrokenAvr\n");
          //printf("ơΰǤΤbi¤\n");
          
          xrit = extRoads.begin();
          for( ; xrit != extRoads.end(); xrit++){
            extrPtr = *xrit;
            
            //extrPtr->head()/tail()idפextNodeõhead/tailBrokenAvr
            xnit = extNodes.begin();
            for( ; xnit != extNodes.end(); xnit++){
              extnPtr = *xnit;
              if (extnPtr->get_extId() == (extrPtr->head())->id()){
                extrPtr->set_headBrokenAvr(extnPtr->get_brokenAvr());
                //printf("headBrokenAvr of road %d = %d\n", extrPtr->get_extId(), extrPtr->get_headBrokenAvr());
              }
              if (extnPtr->get_extId() == (extrPtr->tail())->id()){
                extrPtr->set_tailBrokenAvr(extnPtr->get_brokenAvr());
                //printf("tailBrokenAvr of road %d = %d\n", extrPtr->get_extId(), extrPtr->get_tailBrokenAvr());
              }
            } //for( ; xnit != extNodes.end(); xnit++)

            //bi¤򥢥åץǡ

            bisum += MAX( extrPtr->get_headBrokenAvr(), extrPtr->get_tailBrokenAvr() );
            
          } //for( ; xrit != extRoads.end(); xrit++)

          
          /**************************************************************/
          /*biʿbbarbiɸкSb                      */
          /**************************************************************/
          //printf("ƿΰݲ٤ʿѡɸк\n");
          ////////
          //ʿ
          bbar = bisum / rNum;

          ////////////
          //ɸк
          int bi = 0; //roadݲ١MAXꤢ
          double squaresum = 0; //biɸк뤿(bi-bbar)^2
          
          xrit = extRoads.begin();
          for( ; xrit != extRoads.end(); xrit++){
            extrPtr = *xrit;
            
            bi = MAX(extrPtr->get_headBrokenAvr(), extrPtr->get_tailBrokenAvr());
            squaresum += pow((bi-bbar), 2);
          }
          
          //ɸкη׻
          Sb = sqrt(1/(double)rNum*squaresum);

          printf("bbar = %f, Sb = %f\n", bbar, Sb);

        
          /**************************************************************/
          /*dbarSd                                            */
          /**************************************************************/
          int j;
          double temp = 0.0;
          for (j=0;j<=3;j++){
            temp += (double)(areaPtr+j)->areaRNum * (areaPtr+j)->avrBlock;
          }
          dbar = temp / rNum;
          
          temp = 0.0;
          for (j=0;j<=3;j++){
            temp += (double)(areaPtr+j)->areaRNum * (pow((areaPtr+j)->hhBlock, 2) + pow(((areaPtr+j)->avrBlock - dbar), 2));
          }
          Sd = sqrt(1/(double)rNum*temp);
          
          printf("dbar = %f, Sd = %f\n", dbar, Sd);
          
          /**************************************************************/
          /*٤ƤroadФĺ                          */
          /*ơĺɤΤäroaddifObjs           */
          /**************************************************************/
          //printf("٤ƤroadФĺ\n");
          
          //results
          for (count = 0; count <= 99; count++) {
            results[count] = 0;
          }

          xrit = extRoads.begin();
          for( ; xrit != extRoads.end(); xrit++){
            extrPtr = *xrit;
            
            extrPtr->setBlock(time, getBlock(bbar, Sb, dbar, Sd, areaPtr, extrPtr));
            //cout << "blockage of road " << extrPtr->get_extId() << " = " << extrPtr->block() << "[mm]\n";
            
            //̤ɽ, results()򥢥åץǡ
            //printf("SI, blockage width\n");
            //printf("%d, %ld\n", extrPtr->get_shindo(), extrPtr->block());
            ++results[extrPtr->block()/100];

            if(extrPtr->block() != 0){
              ++brNum;
              difRoads.push_back(extrPtr); //ĺɤäʤdifRoadsɲ
            }
            
          } //for( ; xrit != extRoads.end(); xrit++)
          
          //printf("number of blocked roads = %ld\n", brNum);
          /*
          printf("blockades width/100, number of roads, percentage\n");
          for (count = 0; count <= 99; count++){
            printf("%ld, %ld, %f\n", count, results[count], (float)results[count]/rNum);
          }
          */
          
          ksup_success = 1;
          printf("end of KS_UPDATE %ld\n", ksup);
          break; //case KS_UPDATE

          } //switch (header)
        
        input.setCursor(start);
        input.skip(size);                                               //size Хȥåפ
      }
    } catch(std::exception& e) {
      fprintf(stderr, "%s\n", (const char*)e.what());
    } catch(...) {
      fprintf(stderr, "error...\n");
    }
  }
  
  delete[]extrPtr;
  delete[]extnPtr;

  return 0;
  
} //main

void commands(S32& time, Input& input, Output& output, LongUDPSocket& socket, Address& to, ObjectPool& pool, ExtRoads difRoads, ExtRoads::const_iterator drit, ExtRoad* extrPtr, int block_param, int area_per_repair_cost)
{
  // KS_COMMANDS 
  time = input.get();
  
  /* timeʳinputϼΤƤ
  Header type;
  while(type = input.get(), type != HEADER_NULL) {
    S32 size = input.get();
    Input::Cursor start = input.cursor();
    commands(time, type, input, pool);
    input.setCursor(start);
    input.skip(size);
  }
  */
  
  // ߥ졼̤
  //printf("outputting\n");
  output.clear();
  output.put(SK_UPDATE);
  Output::Cursor base = output.put(~(S32)0);
  
  drit = difRoads.begin();
  for( ; drit != difRoads.end(); drit++){  
    extrPtr = *drit;
    output.put(TYPE_ROAD);
    output.put(extrPtr->get_extId());
    output.put(PROPERTY_BLOCK);
    output.put(extrPtr->block());
    output.put(PROPERTY_REPAIR_COST);
    if (area_per_repair_cost <= 0) {
      output.put(extrPtr->block()/block_param);
    } else {
      S32 repairCost = (extrPtr->block() * extrPtr->length() + (area_per_repair_cost - 1)) / area_per_repair_cost;
      output.put(repairCost);
    }
    output.put(PROPERTY_NULL);
  } //for( ; drit != difRoads.end(); drit++)
  
  pool.output(output, time);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, to);
} //void commands

