#include <stdio.h>

#include "FrameSexp.h"
#include "EvalEngine.h"
#include "Posit.h"
#include "AgentBase.h"

using namespace Itk ;

//======================================================================

//--------------------------------------------------
// sub 1

void sub1(int argc, char** argv) {
   FrameSexp * fs =
      FrameSexp::scan("(foo :bar (foo1 :bar () :baz 7) :boo 3
		        :a (:list a b c d e))") ;
   ITK_DBG(fs) ;

   ITK_DBG(fs->chkSyntax()) ;
   
   ITK_DBG(fs->slotvalue(":bar")) ;
   ITK_DBG(fs->slotvalue(SString(":bar"))->slotvalue(":baz")) ;

   FrameSexp::Heap heap ;

   FrameSexp * fs2 = heap.newFrame("foo2") ;
   ITK_DBG(fs2) ;
   
   fs2->setSlot(heap.newSymbol("bar2"),
		heap.newInt(3),
		&heap) ;
   ITK_DBG(fs2) ;

   fs2->setSlot(heap.newSymbol("baz2"),
		heap.newFlt(2.718),
		&heap) ;
   ITK_DBG(fs2) ;

   nop() ;
   fs2->setSlot(heap.newSymbol("bar2"),
		heap.newFlt(3.14),
		&heap) ;
   ITK_DBG(fs2) ;
   
   ITK_DBG(fs2->slotvalue(heap.newSymbol("bar2"))) ;
} ;

//--------------------------------------------------
// sub 2

void sub2(int argc, char** argv) {

   FrameSexp::Scanner scanner ;

   SString str("(foo :bar (foo1 :bar () :baz 7) :boo 3
		        :a (:list a b c d e))") ;
   
   while(True) {
      Buffer buf(str) ;
      scanner.reset(buf) ;
      FrameSexp * frame = scanner.scan(True) ;
      frame->head() ;
      //ITK_DBG(frame) ;
   } ;
};

//--------------------------------------------------
// sub 3

void sub3(int argc, char** argv) {
   FrameSexp * fs =
      FrameSexp::scan("(foo :bar (foo1 :bar () :baz 7) :boo 3
		        :a (:list a b c d e))") ;
   ITK_DBG(fs) ;
   
   fs->outputLaTeX(cout) ;
   fs->outputHTML(cout) ;
   
}

//--------------------------------------------------
// sub 4

void sub4(int argc, char** argv) {
   FrameSexp::Heap heap ;
   FrameSexp::Scanner scanner(cin,False,&heap) ;
   FrameSexp * fs = scanner.scan() ;
   ITK_DBG(fs) ;
   
   fs->outputLaTeX(cout) ;
   fs->outputHTML(cout) ;
   
}

//--------------------------------------------------
// sub 5

void sub5(int argc, char** argv) {
   FrameSexp::Heap heap1 ;
   FrameSexp * fs1 =
      heap1.scan("(foo :bar (foo1 :bar () :baz 7) :boo 3
		        :a (:list a b c d e))") ;

   ITK_DBG(fs1) ;
   ITK_DSC(*fs1) ;

   FrameSexp::Heap heap2 ;
   nop() ;
   FrameSexp * fs2 = heap2.dup(fs1) ;

   ITK_DBG(fs2) ;
   ITK_DSC(*fs2) ;

   ITK_DBG(Ptr(fs1->car()->str.head)) ;
   ITK_DBG(Ptr(fs2->car()->str.head)) ;
}

//--------------------------------------------------
// sub 6

void sub6(int argc, char** argv) {
   Rescue::EvalEngine::Context context ;

   SimpleSexp2::Heap sheap ;

   //ITK_DSC(context) ;

   SubString v1("aho") ;
   SimpleSexp2 * s1 = sheap.scan("(aho baka)") ;

   context.unifyLocal(v1,s1) ;

   //ITK_DSC(context) ;

   ITK_DBG(context.findLocal(SubString("aho"))) ;

   ITK_DBG(context.findLocal(SubString("aho"))->value) ;

   SubString v2("baka") ;
   SimpleSexp2 * s2 = sheap.newInt(3) ;

   context.unifyLocal(v2,s2) ;
   ITK_DSC(context) ;

   ITK_DBG(context.unifyLocal(v1,s2)) ;
   ITK_DSC(context) ;

   ITK_DBG(context.findLocal(SubString("baka"))->value) ;
} 

//--------------------------------------------------
// sub 7

void sub7(int argc, char** argv) {

   Rescue::EvalEngine engine ;

   engine.describe(cerr) ;

   SimpleSexp2::Heap sheap ;

   engine.traceOn() ;

   SimpleSexp2 * s = sheap.scan("(or (and 0 (or () 1 2) () )
                                     (and (gsetq *v 3) ())
                                     (and T *v)
                                     (and 1 2 3))") ;

   engine.eval(s) ;
   ITK_DSC(engine.context());
   ITK_DBG(engine.context().unifyLocal("*v",sheap.scan("T"))) ;
   
   engine.eval(s) ;

}

//--------------------------------------------------
// sub 8

void sub8(int argc, char** argv) {

   Rescue::EvalEngine engine ;

   SimpleSexp2::Heap sheap ;

   engine.traceOn() ;

   SimpleSexp2 * s = sheap.scan("(do (setq *x (+ 1 2 3))
                                     (setq *y (- 2 3 4))
                                     (setq *z (* *x *y))
                                     (setq *w (/ 3 *z)))") ;

   engine.eval(s) ;

   ITK_DSC(engine.context()) ;
}

//--------------------------------------------------
// sub 9

SimpleSexp2 * sub9_a(SimpleSexp2 * form, Rescue::EvalEngine * engine) {

   FrameSexp * f = static_cast<FrameSexp *>(form) ;
   FrameSexp * var = f->slotvalue(":var") ;
   FrameSexp * cond = f->slotvalue(":cond") ;
   if(cond->isNil()) cond = static_cast<FrameSexp *>(FrameSexp::TrueValue) ;

   while(True) {
      Rescue::EvalEngine::RewindPoint rp = engine->rewindpoint() ;

      Flt v = fltRand(0.0,100.0) ;
      engine->context().unifyLocal(var,engine->sheap().newFlt(v)) ;
      engine->context().letLocal(var,engine->sheap().newFlt(v)) ;

      SimpleSexp2 * r = engine->eval(cond) ;
      if(!r->isNil()) break ;

      engine->rewind(rp) ;
   }

   return SimpleSexp2::TrueValue ;

}

void sub9(int argc, char** argv) {

   Rescue::EvalEngine eng[1000] ;
   
   ITK_DBG(eng[0]) ;

   Rescue::EvalEngine engine ;
   SimpleSexp2::Heap sheap ;

   Rescue::EvalEngine::registerFunc("foo",&sub9_a) ;

   engine.traceOn() ;

   SimpleSexp2 * form = sheap.scan("(progn (setq *x 30) 
                                           (ssetq *sx 20)
                                           (gsetq *gx 50)
                                           (foo :var *y 
                                                :cond (and (ssetq *z *y)
                                                           (< *y *x))))") ;

   form->fixTag() ;  // ***** very important

   nop() ;
   engine.evalTop(form,True) ;
   //engine.eval(form) ;

   ITK_DSC(engine.context()) ;

   engine.traceOff() ;

#if 0
   ITK_TIME("engine.eval() x 100",{
      for(Int i = 0 ; i < 100 ; i++) {
	 engine.evalTop(form,True) ;
	 //ITK_DSC(engine.context()) ;
      }
   }) ;

   ITK_TIME("engine.eval() x 1000",{
      for(Int i = 0 ; i < 1000 ; i++) {
	 engine.evalTop(form,True) ;
      }
   }) ;

   ITK_TIME("engine.eval() x 10000",{
      for(Int i = 0 ; i < 10000 ; i++) {
	 engine.evalTop(form,True) ;
      }
   }) ;

   ITK_TIME("engine.eval() x 100000",{
      for(Int i = 0 ; i < 100000 ; i++) {
	 engine.evalTop(form,True) ;
      }
   }) ;
#endif

}

//--------------------------------------------------
// sub 10

class Foo10 {
   public:
      Int bar ;
      void baz() const {
	 ITK_TRC0() ;
      } ;

      void baz() {
	 ITK_TRC0() ;
      } ;
      void baz0() const {
	 ITK_TRC0() ;
	 baz() ;
	 const_cast<Foo10 *>(this)->baz() ;
      } ;

      void baz1() {
	 ITK_TRC0() ;
	 baz() ;
	 const_cast<const Foo10 *>(this)->baz() ;
      } ;

      void baz2() const {
	 ITK_TRC0() ;
	 baz() ;
      } ;

      void baz2() {
	 ITK_TRC0() ;
	 const_cast<const Foo10 *>(this)->baz2() ;
      } ;
} ;

void sub10(int argc, char** argv) {
   Foo10 f0 ;
   const Foo10 & f1 = f0 ;

   ITK_EXE(f0.baz()) ;
   ITK_EXE(f1.baz()) ;
   ITK_EXE(f0.baz0()) ;
   ITK_EXE(f1.baz0()) ;
   ITK_EXE(f0.baz1()) ;
   ITK_EXE(f0.baz2()) ;
   ITK_EXE(f1.baz2()) ;
} ;

//--------------------------------------------------
// sub 11

void sub11(int argc, char** argv) {
   Rescue::Posit::Rule r1 ;
   ITK_DSC(r1) ;

   SimpleSexp2::Heap sheap ;
   
   SimpleSexp2 * rsexp = 
      sheap.scan("(defrule foo
                     :condition (and (< 1 2) (> 5 4))
                     :activity (* 3 4)
                     :action (do ()))") ;
   r1.set(rsexp,ITK_NULLPTR,sheap) ;
   //r1.set(rsexp) ;

   ITK_DSC(r1) ;
}

//--------------------------------------------------
// sub 12

void sub12(int argc, char** argv) {
   Rescue::Posit posit0 ;
   ITK_DSC(posit0) ;

   SimpleSexp2::Heap sheap ;
   
   SimpleSexp2 * sitsexp = 
      sheap.scan("(defposit foo
                     (defrule foo0
                       :condition (and (< 1 2) (> 5 4))
                       :activity (+ (* 3 4) 2)
                       :action (progn (print 1)))
                     (defrule foo00
                       :condition (and (< 1 2) (> 5 4) *y)
                       :activity (+ (* 3 4) 2 100000)
                       :action (progn (print 11)))
                     (defrule foo1
                       :condition (or (and (setq *x 3) ()) (< 4 2) (> 5 4))
                       :activity (* 5 6 3 4)
                       :action (progn (print (list a b *x)) 
				      (gsetq *y t) (print 2) (print *x)))
                     (defrule foo2
                       :condition (not (and (< 1 2) (> 5 4)))
                       :activity (* 3 4 (+ 1 2))
                       :action (progn (print 3))))") ;
  
   posit0.set(sitsexp,sheap) ;

   ITK_DSC(posit0) ;

   ITK_DSC(**posit0.ruleset().begin()) ;

   Rescue::AgentBase agent ;

   ITK_DSC(agent) ;

   agent.situation().add(&posit0) ;

   ITK_DSC(agent) ;

   agent.traceOn() ;

   agent.cycle() ; 

   agent.cycle() ; 

   agent.traceOff() ;
#if 0
   ITK_TIME("agent.cycle() x 10000",{
      for(Int i = 0 ; i < 10000 ; i++) {
	 agent.cycle() ;
      }
   }) ;
#endif
}


//======================================================================

int main(int argc, char** argv) {

//   sub1(argc,argv) ;
//   sub2(argc,argv) ;
//   sub3(argc,argv) ;
//   sub4(argc,argv) ;
//   sub5(argc,argv) ;
//   sub6(argc,argv) ;
//   sub7(argc,argv) ;
//   sub8(argc,argv) ;
//   sub9(argc,argv) ;
//   sub10(argc,argv) ;
   sub11(argc,argv) ;
   sub12(argc,argv) ;

   return 0 ;
} ;

