// -*- Mode:C++ -*-
//Header:
//File: Posit.h
//Name : Posit : Part Of SITuation
//Author: NODA, Itsuki
//Date: 2001/11/24
//

//ModifyHistory:
// 2001/11/24: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef _itk_Posit_h_
#define _itk_Posit_h_
//////////////////////////////////////////////////////////////////////

#include <list>
#include "EvalEngine.h"

namespace Rescue {

   using namespace Itk ;

   //======================================================================
   // class Posit
   /*--------------------*/
   /**
    *
    */

   class Posit : public WithDescriber {

	 //==================================================
	 //   : Posit
	 // class Rule
      public:
	 class Rule : public WithDescriber {

	       //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       //   : Rule : Posit
	       /*--------------------*/
	       /** @name member var */
	       //@{

	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       ITK_DEF_ACCESS(SubString & name(), { return name_ ;}) ;
	       SubString name_ ;

	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       ITK_DEF_ACCESS3(Sexp * , & condition(), { 
		  return condition_ ; }) ;
	       Sexp * condition_ ;


	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       ITK_DEF_ACCESS3(Sexp * , & activity(), { 
		  return activity_ ; }) ;
	       Sexp * activity_ ;


	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       ITK_DEF_ACCESS3(Sexp * , & action(), { return action_ ;}) ;
	       Sexp * action_ ;
	 
	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       ITK_DEF_ACCESS3(Posit *, & parent(), { return parent_ ;}) ;
	       Posit * parent_ ;
	 

	       //--------------------------------------------------
	       //   : Rule : Posit
	       /*--------------------*/
	       /**
		* constructor 
		*/
	    public:
	       Rule() { init() ; } ;
	 
	       //--------------------------------------------------
	       //   : Rule : Posit
	       /*--------------------*/
	       /**
		* initialize
		*/
	    public:
	       void init() {
		  name().setNull() ;
		  condition() = Sexp::Nil ;
		  activity() = Sexp::Nil ;
		  action() = Sexp::Nil ;
		  parent() = ITK_NULLPTR ;
	       } ;
	 
	       //--------------------------------------------------
	       //  : Ryle : Posit
	       // set
	       /*--------------------*/
	       /**
		* 
		* RuleForm
		* \begin{verbatim}
	        *  (defrule name 
		*               :condition condition
		*               :activity activity
		*               :action action)
		* \end{verbatim}
		*/
	    public:
	       static char * const RuleTagStr = "defrule" ;
	       static char * const ConditionTagStr = ":condition" ;
	       static char * const ActivityTagStr = ":activity" ;
	       static char * const ActionTagStr = ":action" ;

	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void set(Sexp * sexp, Posit * sit,
			Sexp::Heap * sheap = ITK_NULLPTR) ;
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       void set(Sexp * sexp, Posit * sit, Sexp::Heap & sheap) {
		  return set(sexp,sit,&sheap) ;
	       } ;

	       //--------------------------------------------------
	       //   : Rule : Posit
	       // checkCondition
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Bool 
	       checkCondition(EvalEngine * engine, 
			      EvalEngine::Context * context) ;

	       //--------------------------------------------------
	       //   : Rule : Posit
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Flt 
	       calcActivity(EvalEngine * engine, 
			    EvalEngine::Context * context) ;

	       //--------------------------------------------------
	       //   : Rule : Posit
	       // execAction
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       Sexp * 
	       execAction(EvalEngine * engine, 
			  EvalEngine::Context * context) ;

	       //--------------------------------------------------
	       //   : Rule : Posit
	       // describe
	       /*--------------------*/
	       /**
		* 
		*/
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#Rule[" << name() << "]" ;
		  
		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[parent]: " ;
		     if(isNull(parent())) ostr << parent() << endl ;
		     else                  ostr << *parent() << endl ;
		     ostr << "\t[condition]: " << condition() << endl ;
		     ostr << "\t[activity]: " << activity() << endl ;
		     ostr << "\t[action]: " << action() << endl ;
		  }
	       } ;
	       
	 } ;

	 //==================================================
	 //   : Posit
	 // class RuleSet
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 class RuleSet : public WithDescriber, 
			 public list < Rule * > {

	       //----------------------------------------
	       //   : RuleSet : Posit
	       // typedef 
	    public:
	       typedef iterator Itr ;
	       typedef const_iterator C_Itr ;
	       typedef reverse_iterator RevItr ;
	       typedef const_reverse_iterator C_RevItr ;

	       //----------------------------------------
	       //   : RuleSet : Posit
	       // constructor, destructor
	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       RuleSet() { init() ; } ;
	       virtual ~RuleSet() {} ;

	       //----------------------------------------
	       //   : RuleSet : Posit
	       // init()
	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       void init() {} ;

	       //----------------------------------------
	       //   : RuleSet : Posit
	       // push()
	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       Rule * push(Rule * r) {
		  push_back(r) ;
		  return r ;
	       } ;

	       //----------------------------------------
	       //   : RuleSet : Posit
	       // describe()
	       /*--------------------*/
	       /**
		*
		*/
	    public:
	       virtual void describe(ostream& ostr, 
				     const Bool detailp = True) const {
		  ostr << "#RuleSet[" << Ptr(this) << "]" ;
		  if(detailp) {
		     ostr << endl ;
		     ostr << "\t[rules]" << endl ;
		     for(C_Itr r = begin() ; r != end() ; r++) {
			ostr << "\t\t" << **r << endl ;
		     }
		  } 
	       }
	       
	 } ;

	 //==================================================
	 //   : Posit
	 // === BODY ===

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : Posit
	 // members

	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : Posit
	 // name
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 ITK_DEF_ACCESS(SubString & name(), { return name_ ;}) ;
	 SubString name_ ;
	 
	 
	 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 //   : Posit
	 // ruleset
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 ITK_DEF_ACCESS(RuleSet & ruleset(), { return ruleset_ ;}) ;
	 RuleSet ruleset_ ;
	 

	 //--------------------------------------------------
	 //   : Posit
	 // constructor / destructor
	 /*--------------------*/
	 /**
	  * constructor
	  */
      public:
	 Posit() {} ;
	 virtual ~Posit() {} ;

	 //--------------------------------------------------
	 //   : Posit
	 // set
	 /**
	  *
	  * Format:
	  * \begin{verbatim}
	  *   (defposit name
	  *      rule0
	  *      rule1
	  *      ...)
	  * \end{verbatim}
	  */
      public:
	 static char * const PositTagStr = "defposit" ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void set(Sexp * sexp, Sexp::Heap * sheap = ITK_NULLPTR) ;

	 /*--------------------*/
	 /**
	  * 
	  */
      public:
	 void set(Sexp * sexp, Sexp::Heap & sheap) {
	    return set(sexp,&sheap) ;
	 } ;

	 //--------------------------------------------------
	 //   : Posit
	 // describe
      public:
	 virtual void 
	 describe(ostream& ostr, const Bool detailp = True) const {
	    ostr << "#Posit[" << name() << "]" ;
	    if(detailp) {
	       ostr << endl ;
	       ostr << "\t[ruleset] : " ;
	       ruleset().describe(ostr,detailp) ;
	    } 
	 } ;

   } ;

} ;

//////////////////////////////////////////////////////////////////////
#endif

