// -*- Mode:C++ -*-
//Header:
//File: utility.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: separate each util/class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_utility_h_
#define _itk_utility_h_
////////////////////////////////////////////////////////////////////////

extern "C" {
#ifdef THREADED
#include <pthread.h>
#endif
}

#include "itk/TimeVal.h"

namespace Itk {

//======================================================================
// debug utility

/*--------------------*/
/**
 *
 */

#define ITK_HERE  __FILE__ << ":" << __LINE__ << ":" << endl \
		<< "   in function [ " << __PRETTY_FUNCTION__ << " ]"

/*--------------------*/
/**
 *
 */

#define ITK_WRN(form) cerr << "WRN:" << TimeVal::now() << ": " << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_ERR(form) cerr << "ERR:" << TimeVal::now() << ": " << ITK_HERE \
                           << endl << "\t" << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_D(form) "{" << #form << "}=" << (form) << " "

/*--------------------*/
/**
 *
 */

#define ITK_DBG(form)	cerr << "DBG: " << ITK_D(form) << endl

/*--------------------*/
/**
 *
 */

#define ITK_DSC(form)	{ cerr << "DBG: {" << #form << "}=" ;\
			  (form).describe(cerr) ; }
/*--------------------*/
/**
 *
 */

#define ITK_MSG(form) cerr << "DBG: " << form << endl ;

/*--------------------*/
/**
 *
 */

#define ITK_EXE(form) { cerr << "DBG: " << #form << endl ; form ; }

/*--------------------*/
/**
 *
 */

#define ITK_TRC0()   cerr << "TRC:" << ITK_HERE << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRC(form) cerr << "TRC:" << ITK_HERE << "| " << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRCin()    cerr << "TRC:" << ITK_HERE << "<-" << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRCout()   cerr << "TRC:" << ITK_HERE << "->" << endl

/*--------------------*/
/**
 *
 */

   typedef Int VbsLevel ;
   extern VbsLevel _VerboseLevel ;

/*--------------------*/
/**
 *
 */

#define ITK_VBS(level,form) if(_VerboseLevel >= level) {\
      cerr << TimeVal::now() << " " << form << endl ;\
      }

/*--------------------*/
/**
 *
 */

#define ITK_VBSC(level,form) if(_VerboseLevel >= level) {\
      cerr << TimeVal::now() << " " << form ;\
      cerr.flush() ;\
      }

/*--------------------*/
/**
 *
 */

#define ITK_SET_VBS(level) { _VerboseLevel = level ; }

/*--------------------*/
/**
 *
 */

#define ITK_TIME(label,form) {\
      TimeVal _itkStartTime_ ; _itkStartTime_.update() ; \
      cerr << _itkStartTime_ << ": >>> " << label << endl ;\
      form ;\
      TimeVal _itkEndTime_ ; _itkEndTime_.update() ; \
      cerr << _itkEndTime_ << ": <<< " << label << endl ;\
      cerr << "TIME: " << label << " takes " \
	   << _itkEndTime_ - _itkStartTime_ << "." << endl ;\
      }      

/*--------------------*/
/**
 *
 */

#define ITK_TIME1(form) ITK_TIME(#form,form)

//------------------------------------------------------------
// threaded version

/*--------------------*/
/**
 *
 */

#define ITK_THR  "th(" << Thread::thisThread()->name() << ")"

/*--------------------*/
/**
 *
 */

#define ITK_WRN_T(form) cerr << "WRN:" << ITK_THR << ":" << TimeVal::now() \
                            << ": " << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_ERR_T(form) cerr << "ERR:" << ITK_THR << ":" << TimeVal::now() \
                            << ": " << ITK_HERE \
                            << endl << "\t" << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_DBG_T(form)	cerr << "DBG:" << ITK_THR << ":" \
                             << " {" << #form << "}=" << (form) << endl
/*--------------------*/
/**
 *
 */

#define ITK_DSC_T(form)	{ cerr << "DBG:" << ITK_THR << ":" \
                               << " {" << #form << "}=" ;\
			       (form).describe(cerr) ; }

/*--------------------*/
/**
 *
 */

#define ITK_MSG_T(form) cerr << "DBG:" << ITK_THR << ": " << form << endl ;

/*--------------------*/
/**
 *
 */

#define ITK_EXE_T(form) { cerr << "DBG:" << ITK_THR << ": " << #form << endl ; form ; }

/*--------------------*/
/**
 *
 */

#define ITK_TRC0_T()   cerr << "TRC:" << ITK_THR << ":" << ITK_HERE << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRC_T(form) cerr << "TRC:" << ITK_THR << ":" << ITK_HERE \
                            << "| " << form << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRCin_T()  cerr << "TRC:" << ITK_THR << ":" << ITK_HERE \
                           << "<-" << endl

/*--------------------*/
/**
 *
 */

#define ITK_TRCout_T() cerr << "TRC:" << ITK_THR << ":" << ITK_HERE \
                           << "->" << endl


//------------------------------------------------------------
// nop

/*--------------------*/
/**
 *
 */

   void nop() ;


//======================================================================
// small value

/*--------------------*/
/**
 *
 */

#define ITK_EPS	1.2e-10

//======================================================================
// min max swap abs

/*--------------------*/
/**
 *
 */

   inline Int Max(const Int x, const Int y) { return (x>y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline Int Min(const Int x, const Int y) { return (x<y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline int Max(const int x, const int y) { return (x>y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline int Min(const int x, const int y) { return (x<y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline Flt Max(const Flt x, const Flt y) { 
      return (x>y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline Flt Min(const Flt x, const Flt y) { 
      return (x<y) ? x : y ; } 

/*--------------------*/
/**
 *
 */

   inline void Swap(Int& x, Int& y) { Int z = x ; x = y ; y = z ; } 

/*--------------------*/
/**
 *
 */

   inline void Swap(UInt& x, UInt& y) { UInt z = x ; x = y ; y = z ; } 

/*--------------------*/
/**
 *
 */

   inline void Swap(Flt& x, Flt& y) { Flt z = x ; x = y ; y = z ; } 

/*--------------------*/
/**
 *
 */

   inline void Swap(int& x, int& y) { int z = x ; x = y ; y = z ; } 

/*--------------------*/
/**
 *
 */

   inline Flt Abs(const Flt& x) {  return ((x > 0.0)?x:(-x)) ; } ;

/*--------------------*/
/**
 *
 */

   inline Int Abs(const Int& x) {  return ((x > 0)?x:(-x)) ; } ;

/*--------------------*/
/**
 *
 */

   inline Flt Sign(const Flt& x) { return ((x > 0.0)?  1.0:
					   (x < 0.0)? -1.0: 0.0) ; } ;
/*--------------------*/
/**
 *
 */

   inline Int Sign(const Int& x) { return ((x > 0)?  1:
					   (x < 0)? -1: 0) ; } ;

/*--------------------*/
/**
 *
 */

   inline Flt sq(const Flt& x) { return x * x ; } ;

//======================================================================
// bound number

/*--------------------*/
/**
 *
 */

   template <class Value>
   Value boundT(const Value & value, const Value & min, const Value & max) {
      if(value < min) return min ;
      if(value > max) return max ;
      return value ;
   } ;
      
/*--------------------*/
/**
 *
 */

   inline Int bound(const Int & value, const Int & min, const Int & max) {
      return boundT<Int>(value,min,max) ;
   }

/*--------------------*/
/**
 *
 */

   inline Flt bound(const Flt & value, const Flt & min, const Flt & max) {
      return boundT<Flt>(value,min,max) ;
   }


//======================================================================
// random

#ifdef RAND_MAX
# define FS_FLTRANDBASE (RAND_MAX/2) 
#else
# define FS_FLTRANDBASE ((1<<14)-1)
#endif

/*--------------------*/
/**
 *
 */

   extern void randomize(UInt seed) ;

/*--------------------*/
/**
 *
 */

   extern void randomizeByTime() ;

/*--------------------*/
/**
 *
 */

   extern Bool RandomizedP ;

/*--------------------*/
/**
 *
 */

   inline Int intRand(Int max) { return (random() % max) ; } ;

/*--------------------*/
/**
 *
 */

   inline Int intRand(Int min, Int max) { 
      return intRand(max - min) + min ; } ;

/*--------------------*/
/**
 *
 */

   inline Flt fltRand() { 
      return ((Flt)intRand(FS_FLTRANDBASE))/(Flt)FS_FLTRANDBASE ;
   } ;

/*--------------------*/
/**
 *
 */

   inline Flt fltRand(Flt max) { return max * fltRand() ; } ;

/*--------------------*/
/**
 *
 */

   inline Flt fltRand(Flt min, Flt max) {
      return fltRand(max - min) + min ;
   } ;

//======================================================================
// binomial 
//	return random value based on binomial distribution

/*--------------------*/
/**
 *
 */

   extern Int binomial(Int n, Flt p = 0.5) ;

//======================================================================
// sleep

/*--------------------*/
/**
 *
 */

   void sleep(const UInt sec, 
		     const UInt msec = 0, 
		     const UInt usec = 0) ;

/*--------------------*/
/**
 *
 */

   inline void msleep(const UInt msec) { sleep(0,msec,0) ; }

/*--------------------*/
/**
 *
 */

   inline void usleep(const UInt usec) { sleep(0,0,usec) ; }
   
/*--------------------*/
/**
 *
 */

   inline void sleep(const TimeVal& tv) { 
      sleep(tv.sec(),tv.msec(),tv.usec()) ; 
   } 

/*--------------------*/
/**
 *
 */

   Bool sleepUntil(const TimeVal& etime) ;

/*--------------------*/
/**
 *
 */

   void sleepForever() ;

//======================================================================
// transform network byteorder and host byteorder

   //--------------------------------------------------
   // network byteorder for double

/*--------------------*/
/**
 *
 */

   inline Flt myswap64(const Flt & x) {
      Flt y ;
      char * xp = (char *)(&x) ;
      char * yp = (char *)(&y) ;

      yp[0] = xp[7] ; yp[1] = xp[6] ; yp[2] = xp[5] ; yp[3] = xp[4] ; 
      yp[4] = xp[3] ; yp[5] = xp[2] ; yp[6] = xp[1] ; yp[7] = xp[0] ; 

      return y ;
   } ;

#if __BYTE_ORDER == __BIG_ENDIAN
   inline Flt myntohd(const Flt & x) { return x ; } ;
   inline Flt myhtond(const Flt & x) { return x ; } ;
#else
   inline Flt myntohd(const Flt & x) { return myswap64(x) ; } ;
   inline Flt myhtond(const Flt & x) { return myswap64(x) ; } ;
#endif

   //--------------------------------------------------
   // transformation for basic types

/*--------------------*/
/**
 *
 */

   inline void transN2H(char & v) { } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(char & v) { } ;
   
/*--------------------*/
/**
 *
 */

   inline void transN2H(short & v) { v = (short)ntohs((unsigned short)v);};

/*--------------------*/
/**
 *
 */

   inline void transH2N(short & v) { v = (short)htons((unsigned short)v);};

/*--------------------*/
/**
 *
 */

   inline void transN2H(unsigned short & v) { v = ntohs(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(unsigned short & v) { v = htons(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transN2H(Int & v) { v = (Int)ntohl((UInt)v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(Int & v) { v = (Int)htonl((UInt)v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transN2H(UInt & v) { v = ntohl(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(UInt & v) { v = htonl(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transN2H(float & v) { 
      union F__I { float fval ; int ival ; } vp ;
      vp.fval = v ;
      vp.ival = ntohl(vp.ival) ;
      v = vp.fval ;
   } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(float & v) { 
      union F__I { float fval ; int ival ; } vp ;
      vp.fval = v ;
      vp.ival = htonl(vp.ival) ;
      v = vp.fval ;
   } ;

/*--------------------*/
/**
 *
 */

   inline void transN2H(Flt & v) { v = myntohd(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(Flt & v) { v = myhtond(v) ; } ;

/*--------------------*/
/**
 *
 */

   inline void transN2H(TimeVal & v) { v.transN2H() ; } ;

/*--------------------*/
/**
 *
 */

   inline void transH2N(TimeVal & v) { v.transH2N() ; } ;

//======================================================================
// macro to access functions
//[usage]
//     class foo {
//	  Int _x ;
//      public:
//	  ITK_DEF_ACCESS(Int & x, { return _x ; })
//	  // will define 
//		Int & x() { return _x ; } ; 
//		const Int & x() const { return _x ; } ;

/*--------------------*/
/**
 *
 */

#define ITK_DEF_ACCESS(type_name_arg,body) \
   const type_name_arg const body ;\
   type_name_arg body ;

/*--------------------*/
/**
 *
 */

#define ITK_DEF_ACCESS3(type,func,body) \
   type const func const body ;\
   type func body ;

//======================================================================
// endlIndent

   /*--------------------*/
   /** 
    * send end of line and indent.
    * if indent is negative, then no endl and no indent.
    */

   inline Bool endlIndent(ostream & ostr = cout, Int indent = 0, 
			  char * indentstr = " ") {
	 if(indent >= 0) {
	    ostr << endl ;
	    for(Int i = 0 ; i < indent ; i++) ostr << indentstr ;
	    return True ;
	 } else {
	    return False ;
	 }
      } ;

   
}
////////////////////////////////////////////////////////////////////////
#endif



