#include <stdio.h>

#include "itk/itk.h"

using namespace Itk ;

//----------------------------------------------------------------------
void sub1(int argc, char** argv) {

   SimpleSexp2 * s1 = SimpleSexp2::scan("(a :b c)") ;
   ITK_DBG(s1) ;

   SimpleSexp2 * s2 = SimpleSexp2::scan("(abc (def ; ghi
jkl 1) 2 3 4)") ;
   ITK_DBG(s2) ;
   ITK_DSC(*s2) ;
   ITK_DBG(s1) ;

   SimpleSexp2 * s3 = SimpleSexp2::scan("(abc") ;
   ITK_DBG(s3) ;

   Itk::nop() ;
   SimpleSexp2 * s4 = SimpleSexp2::scan("") ;
   ITK_DBG(s4) ;

   SimpleSexp2 * s5 = SimpleSexp2::scan("(a b \"c d e f\" g)") ;
   ITK_DBG(s5) ;

   SimpleSexp2 * s6 = SimpleSexp2::scan("(a b \"c 
d e f\" g)") ;
   ITK_DBG(s6) ;

   cout << "Input S expression:" << ends ;
   SimpleSexp2 * s7 = SimpleSexp2::scan(cin) ;
   ITK_DBG(s7) ;

}

//----------------------------------------------------------------------
#define SEXPFILENAME "/usr/users/noda/.emacs"

void sub2(int argc, char** argv) {
   SimpleSexp2::Scanner scanner(new ifstream(SEXPFILENAME)) ;
   SimpleSexp2 * s;
   while(!(s = scanner.scan())->isEof()) {
      ITK_DBG(s) ;
   } ;

} ;


//----------------------------------------------------------------------
typedef SimpleSexp2* Cell ;
typedef SimpleSexp2::Heap CellHeap ;

void sub3(int argc, char** argv) {
   CellHeap heap ;

   Cell iv = heap.newInt(3) ;
   ITK_DBG(iv) ;
   ITK_DSC(*iv) ;

   Cell fv = heap.newFlt(5) ;
   ITK_DBG(fv) ;
   ITK_DSC(*fv) ;

   Cell sv = heap.newSymbol("xxx") ;
   ITK_DBG(sv) ;
   ITK_DSC(*sv) ;

   SubString s("yyy") ;
   Cell ssv = heap.newSymbol(s) ;
   ITK_DBG(ssv) ;
   ITK_DSC(*ssv) ;

   Cell ivx = heap.newAtom("4") ;
   ITK_DBG(ivx) ;
   ITK_DSC(*ivx) ;

   ITK_DBG(ivx->intVal()) ;
   ITK_DBG(ivx) ;
   ITK_DSC(*ivx) ;

   Cell fvx = heap.newAtom("3.14") ;
   ITK_DBG(fvx) ;
   ITK_DSC(*fvx) ;

   ITK_DBG(fvx->fltVal()) ;
   ITK_DBG(fvx) ;
   ITK_DSC(*fvx) ;
   
} ;

//----------------------------------------------------------------------
int main(int argc, char** argv) {
//   sub1(argc,argv) ;
//   sub2(argc,argv) ;
   sub3(argc,argv) ;

   return 0 ;
}

   
