// -*- Mode:C++ -*-
//Header:
//File: geoutility.h
//Author: NODA, Itsuki
//Date: 2001/03/05
//

//ModifyHistory:
// 2001/03/05: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_geoutility_h_
#define _itk_geoutility_h_
////////////////////////////////////////////////////////////////////////

extern "C" {

#include <math.h>

}

#include "itk/btype.h"

//======================================================================
// Itk namespace
//----------------------------------------------------------------------
namespace Itk {

   //----------------------------------------------------------------------
   // Basic Types (GeoVal, Angle)

#ifndef _Itk_GeoVal_Defined_
#define _Itk_GeoVal_Defined_

   /*--------------------*/
   /**
    *
    */

   typedef Flt GeoVal ;

#endif
#ifndef _Itk_Angle_Defined_
#define _Itk_Angle_Defined_

   /*--------------------*/
   /**
    *
    */

   typedef Flt Angle ;

#endif

   //----------------------------------------------------------------------
   // translate Deg <-> Rad

   /*--------------------*/
   /**
    *
    */

   const Flt Deg2Rad = M_PI / 180.0 ;

   /*--------------------*/
   /**
    *
    */

   const Flt Rad2Deg = 180.0 / M_PI ;

   /*--------------------*/
   /**
    *
    */

   inline Flt deg2rad(const Flt & x) { return x * Deg2Rad ; } 

   /*--------------------*/
   /**
    *
    */

   inline Angle rad2deg(const Flt & x) { return x * Rad2Deg ; }

   /*--------------------*/
   /**
    *
    */

   inline Flt Sin(const Flt & x) { return sin(deg2rad(x)) ; } 

   /*--------------------*/
   /**
    *
    */

   inline Flt Cos(const Flt & x) { return cos(deg2rad(x)) ; } 

   /*--------------------*/
   /**
    *
    */

   inline Flt Tan(const Flt & x) { return tan(deg2rad(x)) ; } 

   /*--------------------*/
   /**
    *
    */

   inline Angle ATan(const Flt & x) { return rad2deg(atan(x)) ; } 

   /*--------------------*/
   /**
    *
    */

   inline Angle ATan(const Flt & y, const Flt & x) { 
      return rad2deg(atan2(y,x)) ; 
   }

   //----------------------------------------------------------------------
   // normalize angle (degree)

   /*--------------------*/
   /**
    *
    */

   inline Angle & letNormalizeAngle(Angle & angle) {
      const Angle toobigAngle = 10000 ;
      if(Abs(angle) > toobigAngle) {
	 ITK_WRN("too big angle: " << angle) ;
	 angle = 0.0 ;
      } ;
      
      while(angle < -180.0) { angle += 360.0 ; } ;
      while(angle >  180.0) { angle -= 360.0 ; } ;
      return angle ;
   } 

   /*--------------------*/
   /**
    *
    */

   inline Angle & normalizeAngle(const Angle & angle) {
      Angle r = angle ;
      return letNormalizeAngle(r) ;
   }

   //----------------------------------------------------------------------
   // normalize angle (radian)

   /*--------------------*/
   /**
    *
    */

   inline Angle & letNormalizeAngleRad(Angle & angle) {
      while(angle < -M_PI) { angle += (2.0 * M_PI) ; } ;
      while(angle >  M_PI) { angle -= (2.0 * M_PI) ; } ;
      return angle ;
   } 

   /*--------------------*/
   /**
    *
    */

   inline Angle & normalizeAngleRad(const Angle & angle) {
      Angle r = angle ;
      return letNormalizeAngleRad(r) ;
   }

}

////////////////////////////////////////////////////////////////////////
#endif


