// -*- Mode: c++ -*-
//Header:
//File: btype.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: introduce Itk namespace
// 1999/11/07: Divide each class to separate file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_btype_h_
#define _itk_btype_h_
//////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

//======================================================================
// Includes
//

//----------------------------------------------------------------------
// include C header

extern "C" {

#include <math.h>
#include <stdlib.h>

#if HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif
//--------------------------------------------------
// for configure [#include <string.h>]
//
#if STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
   char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

//  I'm not sure this is correct fix of bug
#ifdef Solaris
# undef NBBY
#endif
#include <netinet/in.h>

}

//----------------------------------------------------------------------
// include C++ header

#include <iostream.h>
#include <iomanip.h>

//======================================================================
// Itk namespace
//----------------------------------------------------------------------
namespace Itk {

   //======================================================================
   // basic types

   /*--------------------*/
   /**
    *
    */

   typedef long Int ;

   /*--------------------*/
   /**
    *
    */

   typedef unsigned long UInt ;

   /*--------------------*/
   /**
    *
    */

   typedef double Flt ;

   //======================================================================
   // my Bool class  (for modify operator<<)

   /*--------------------*/
   /**
    *
    */

   class Bool {
     public:
         bool value ;

         static const bool False = false ;
         static const bool True = true ;

	 /*--------------------*/
	 /**
	  *
	  */

         Bool() { value = False ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

	 Bool(const Bool& src) { value = src.value ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

         Bool(const bool src) { value = src ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

         Bool& operator= (const Bool& src) {
            value = src.value ; return *this ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

         Bool& operator= (const int src) { value = src ; return *this ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

         Bool& operator= (const bool src) { value = src ; return *this ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

         operator bool () const { return value ; } ;
	 //       operator int () const { return (int)value ; } ;
   } ;

   //const Bool False = Bool(Bool::False) ;
   //const Bool True = Bool(Bool::True) ;

   /*--------------------*/
   /**
    *
    */

   const Bool False = Bool::False ;

   /*--------------------*/
   /**
    *
    */

   const Bool True = Bool::True ;

   /*--------------------*/
   /**
    *
    */

   inline ostream& operator<<(ostream& ostr, const Bool& b) {
      if(b.value == Bool::False) {
         ostr << "false" ;
      } else {
         ostr << "true" ;
      }
      return ostr ;
   }

   //======================================================================
   // my Ptr class  (for modify operator<<)

   /*--------------------*/
   /**
    *
    */

   class Ptr {
      public:
	 const void * ptr ;

	 /*--------------------*/
	 /**
	  *
	  */

	 Ptr() {} ;

	 /*--------------------*/
	 /**
	  *
	  */

	 Ptr(const void * const p) { ptr = p ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

	 Ptr(const Ptr& p) { ptr = p.ptr ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

	 operator const void*() const { return ptr ; } ;

	 /*--------------------*/
	 /**
	  *
	  */

	 operator const UInt() const { return (UInt)ptr ; } ;
   } ;

   /*--------------------*/
   /**
    *
    */

   inline ostream& operator<<(ostream& ostr, const Ptr p) {
      return ostr << "<" << p.ptr << ">" ;
   } 

   //======================================================================
   // NULL

/*--------------------*/
/**
 *
 */

#define ITK_NULLPTR 0

/*--------------------*/
/**
 *
 */

#define ITK_NULLCHR '\000'
   
   /*--------------------*/
   /**
    *
    */

   inline Bool isNull(const void * ptr) { return ptr == ITK_NULLPTR ; }

   /*--------------------*/
   /**
    *
    */

   inline Bool isNull(const char c) { return c == ITK_NULLPTR ; }

}

//////////////////////////////////////////////////////////////////////
#endif
