// -*- Mode: c++ -*-
//Header:
//File: IntervalTimer.h
//Author: NODA, Itsuki
//Date: 1999/05/18
//

//ModifyHistory:
// 1999/05/18: Start to create this file
// 1999/11/07: introduce Itk namespace
// 1999/11/07: Divide each class to separate file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_IntervalTimer_h_
#define _itk_IntervalTimer_h_
//////////////////////////////////////////////////////////////////////

extern "C" {
#include <math.h>
#include <sys/time.h>
}

#include <iostream.h>
#include <iomanip.h>

#include "itk/btype.h"
#include "itk/utility.h"
#include "itk/WithDescriber.h"
#include "itk/TimeVal.h"

namespace Itk {

   //======================================================================
   // class IntervalTimer

   /*--------------------*/
   /**
    *
    */

   class IntervalTimer : public WithDescriber {
	 //--------------------------------------------------
	 // member
      private:
	 TimeVal interval ;
	 TimeVal next ;
	 UInt counter ;

	 //--------------------------------------------------
	 // constructor
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 IntervalTimer() { init(TimeVal()) ; } ;
	 IntervalTimer(const TimeVal& itv) { init(itv) ; } ;

	 //--------------------------------------------------
	 // initialize
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void init(const TimeVal& itv) {
	    reset() ;
	    setInterval(itv) ;
	 } ;

	 //--------------------------------------------------
	 // reset
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void reset() { adjust() ; counter = 0 ; } ;

	 //--------------------------------------------------
	 // adjust
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void adjust() { next.update() ; } ;

	 //--------------------------------------------------
	 // set interval
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void setInterval(const TimeVal& itv) { interval = itv ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 const TimeVal & getInterval() const  { return interval ; } ;

	 //--------------------------------------------------
	 // set next
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void setNext(const TimeVal& tv) { next = tv ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 const TimeVal & getNext() const { return next ; } ;

	 //--------------------------------------------------
	 // inc / dec
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void inc() { next.inc(interval) ; counter++ ; } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void dec() { next.dec(interval) ; counter-- ; } ;

	 //--------------------------------------------------
	 // check expired
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool isExpired() { return next.isPast() ; } ;

	 //--------------------------------------------------
	 // sleepUntilNext()
	 //     return False if next is over

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool sleepUntilNext() { return sleepUntil(next) ; } ;

	 //--------------------------------------------------
	 // incSleep() ;
	 //     return False if next is over

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 Bool incSleep() { inc() ; return sleepUntilNext() ; } ;

	 //--------------------------------------------------
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describe(ostream& ostr, Bool detailp = True) const {
	    ostr << "#IntervalTimer[" << interval << "]" ;
	    if(detailp) { 
	       ostr << endl ;
	       ostr << "\tinterval=" << next << endl ;
	       ostr << "\tcounter=" << counter << endl ;
	    }
	 } ;
   } ;
} ;

//////////////////////////////////////////////////////////////////////
#endif

