// -*- Mode: c++ -*-
//Header:
//File: GetOpt.h
//Author: NODA, Itsuki
//Date: 2000/03/12
//

//ModifyHistory:
// 2000/03/12: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_GetOpt_h_
#define _itk_GetOpt_h_
//////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/utility.h"
#include "itk/SString.h"
#include "itk/Buffer.h"
#include <stdio.h>
#include <fstream.h>

namespace Itk {

   //======================================================================
   // class OptArg

   /*--------------------*/
   /**
    *
    */

   class OptArg {

	 //--------------------------------------------------
	 // Type
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 enum ScanType {
	    Flag, 	/* not used */
	    OnOff,
	    cstringVal,
	    SStringVal,
	    IntVal,
	    UIntVal,
	    FltVal,
	    FunctionCall,
	    Other
	 } ;
	 
	 //--------------------------------------------------
	 // special string
      public:
	 static const char* const onStr = "on" ;
	 static const char* const offStr = "off" ;
	 static const char prefixChr = '-' ;
	 static const char* const optHelpStr = "-help" ;
	 static const char* const optConfStr = "-conf" ;
	 static const char* const optMakeConfStr = "-makeconf" ;
	 static const char* const optSkipRestStr = "--" ;
	 

	 //--------------------------------------------------
	 // member

      public:
	 char* name ;
	 ScanType type ;
	 void * dest ;
	 void * aux ;
	 char * help ;
	 SubString str ;
	 Bool isGiven ;
   } ;

   //======================================================================
   // myGetOpt

   /*--------------------*/
   /**
    *
    */

   void myGetOpt(OptArg * optlist, int & argc, char** argv) ;

   /*--------------------*/
   /**
    *
    */

   void myGetOptSetDefault(OptArg * optlist) ;

   /*--------------------*/
   /**
    *
    */

   void myGetOptHelp(OptArg * optlist, char * commandname) ;


#ifdef _NEVER_DEFINED_

   //======================================================================
   // Sample

   Bool a ;
   Int b ;
   OptArg OptList[] = {
      {"foo",	OptArg::OnOff,	&a,	0, "-foo {on|off}  ;  switch foo."},

      {"bar",	OptArg::IntVal,	&b,	0, "-bar intbar    ;  switch bar."},
      {ITK_NULLPTR}} ;

#endif



} ;


//////////////////////////////////////////////////////////////////////
#endif
