// -*- Mode:C++ -*-
//Header:
//File: Excaption.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/11/08: rebuid for itk
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_Exception_h_
#define _itk_Exception_h_
////////////////////////////////////////////////////////////////////////

#include "itk/btype.h"
#include "itk/WithDescriber.h"

namespace Itk {

//======================================================================
// exception basic type
//

#define ITK_DFLT_EXCEPTION_NAME	"Exception"

   /*--------------------*/
   /**
    *
    */

   class Exception : public WithDescriber {
      public:
	 char* filename ;
	 UInt line ;
	 char* desc ;

	 //--------------------------------------------------
	 // name: give a name of exception class

	 virtual const char* name() const { 
	    return ITK_DFLT_EXCEPTION_NAME ; } ;

	 //--------------------------------------------------
	 // set: set exception information
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 void set(char* const f, UInt const l, char* const d) {
	    filename = f ;
	    line = l ;
	    desc = d ;
	 } ;

	 //--------------------------------------------------
	 // root substance
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 static Exception * root(char* const f, UInt const l, 
				 char* const d) {
	    static Exception _root ;
	    _root.set(f,l,d) ;
	    return &_root ;
	 } ;

	 //--------------------------------------------------
	 // describe
	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describe_aux(ostream& ostr) const { } ;

	 /*--------------------*/
	 /**
	  *
	  */
      public:
	 virtual void describe(ostream& ostr, 
			       const Bool detailp = True) const {
	    ostr << "#Exception[" << name() 
		 << "|" << filename << ":" << line ;
	    if(detailp) {
	       ostr << ":\"" << desc << "\"" ;
	       describe_aux(ostr) ;
	    }
	    ostr << "]" ;
	    if(detailp) ostr << endl ;
	 } ;
   } ;

//======================================================================
// exception macros
//

/*--------------------*/
/**
 *
 */

#define ITK_EXCEPTION(desc)	Exception::root(__FILE__,__LINE__,desc)

/*--------------------*/
/**
 *
 */

#define ITK_XPT(xtype,desc) \
	 (xtype*)(xtype::root(__FILE__,__LINE__,desc))

/*--------------------*/
/**
 *
 */

#define ITK_XPT1(xtype,desc,arg1) \
         (xtype*)(xtype::root(__FILE__,__LINE__,desc,arg1))

/*--------------------*/
/**
 *
 */

#define ITK_XPT2(xtype,desc,arg1,arg2) \
         (xtype*)(xtype::root(__FILE__,__LINE__,desc,arg1,arg2))

/*--------------------*/
/**
 *
 */

#define ITK_XPT3(xtype,desc,arg1,arg2,arg3) \
         (xtype*)(xtype::root(__FILEa__,__LINE__,desc,arg1,arg2,arg3))

/*--------------------*/
/**
 *
 */

#define ITK_XPT4(xtype,desc,arg1,arg2,arg3,arg4) \
         (xtype*)(xtype::root(__FILE__,__LINE__,desc,arg1,arg2,arg3,arg4))

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Memo:  Why such tricky exception handling
//
//   In order to enable to define hieralchical exception type,
// we must use virtual functions to keep information of the
// exception (for example, "name()").  In order to enable the usage of
// the virtual functions, try blocks must receive throws by
// catch(Exception&) or catch(Exception*) rather than catch(Exception)
// Therefore, in throw, the data must be allocated at the throw point
// or static data.  Exceptions, especially XptFailMemoryAlloc, occers
// no memory available, so that allocation (call new method) in the throw 
// point may cause another exception.  So, the best way is that
// all exception class instance is defined static.
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

//======================================================================
// fail memory allocation exception
//

   /*--------------------*/
   /**
    *
    */

   class XptFailMemoryAlloc : public Exception {
      public:
	 virtual const char * name() const { 
	    return "FailMemoryAlloc" ; } ;
      
	 static Exception* root(char* const f, 
				UInt const l, char* const d) {
	    static XptFailMemoryAlloc _root ;
	    _root.set(f,l,d) ;
	    return &_root ;
	 } ;
   } ;

//======================================================================
// exception example
//

   /*--------------------*/
   /**
    *
    */

   class XptExample : public Exception {
      public:
	 virtual const char* name() const { return "Example" ; } ;

	 static Exception * root(char* const f, 
				 UInt const l, char* const d) {
	    static XptExample _root ;
	    _root.set(f,l,d) ;
	    return &_root ;
	 } ;
   } ;

} ;

////////////////////////////////////////////////////////////////////////
#endif
