#include "../itk/itk.h"
#include "../librescue/librescue.hxx"

using namespace Rescue;

class Controller {
protected:
  Id m_selfId;
  Address m_to;
  ObjectPool m_pool;

public:
  virtual ~Controller() { }
  Controller(Id selfId, const Address& to, Input& input) {
    m_selfId = selfId;
    m_to = to;
    m_pool.restructure(0, input);
  }
  virtual void sensed(LongUDPSocket& socket, Input& input, Output& output) = 0;
  virtual void heard(LongUDPSocket& socket, Id speaker, const char* message, Input& input, Output& output);

private:
  Controller(const Controller& source);
  Controller& operator= (const Controller& rhs);
  bool operator== (const Controller& rhs) const;
};
void Controller::heard(LongUDPSocket& socket, Id speaker, const char* message, Input& input, Output& output) { }

int main2(int argc, char** argv);
typedef std::map<Id, AutoPtr<Controller> > IdToController;
void connectOk(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output);
void senseReveived(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output);
void hearReveived(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output);

int main(int argc, char** argv){
  return main2(argc, argv);
}

class SampleController : public Controller {
protected:
  Id m_destination;
  Id m_destination2;
public:
  SampleController(Id selfId, const Address& to, Input& input) : Controller(selfId, to, input) {
    m_destination = 0;
    m_destination2 = 0;
    long nearestLengthSquared = LONG_MAX;
    long farthestLengthSquared = 0;
    Objects::const_iterator it = m_pool.objects().begin();
    for(; it != m_pool.objects().end(); it++) {
      Refuge* refuge = dynamic_cast<Refuge*>(*it);
      if(refuge != 0) {
	MovingObject* me = (MovingObject*)m_pool.get(selfId);
	
	long xdiff = (long)(refuge->x() - me->x());
	long ydiff = (long)(refuge->y() - me->y());
	long value = xdiff*xdiff + ydiff*ydiff;
	if(value < nearestLengthSquared) {
	  nearestLengthSquared = value;
	  m_destination = refuge->id();
	}
	if(value > farthestLengthSquared) {
	  farthestLengthSquared = value;
	  m_destination2 = refuge->id();
	}
      }
    }
  }
  virtual void sensed(LongUDPSocket& socket, Input& input, Output& output);
  virtual void heard(LongUDPSocket& socket, Id speaker, const char* message, Input& input, Output& output);
  
private:
  SampleController(const SampleController& source);
  SampleController& operator= (const SampleController& rhs);
  bool operator== (const SampleController& rhs) const;
};

using namespace Itk;
typedef RingBufferT<Input*> LocalBuffer;

int main2(int argc, char** argv) {
  const char* host = "localhost";
  Config config;
  LocalBuffer buf("foo",100);

  int number = INT_MAX;   // ³륨Ȥο
  // 
  int i;
  int count = 0;
  for(i=1; i<argc; i++) {
    if(argv[i][0] == '-') {
      if(strcmp(argv[i], "-file") == 0) {
	if(++i < argc) {
	  config.readConfigFile(argv[i]);
	} else {
	  fprintf(stderr, "error: '-file'\n");
	}
      } else {
	if(++i < argc) {
	  if(!config.setValue(argv[i-1]+1, argv[i]))
	    fprintf(stderr, "error: '%s'\n", argv[i]);
	} else {
	  fprintf(stderr, "error: '%s'\n", argv[i-1]);
	}
      }
    } else {
      switch(count++) {
      case 0:
	host = argv[i];
	break;
      case 1:
	number = atoi(argv[i]);
	break;
      default:
	fprintf(stderr, "error: '%s'\n", argv[i]);
	break;
      }
    }
  }
  // åȺ
  LongUDPSocket socket(config.textlogname_samplecivilian());
  Input input;
  Output output;
  output.setWait(config.send_udp_wait());
  output.resetFrameSize(config.send_udp_size());
  Address to(host, config.port());    //

  int countttt = 0;
  // å롼
  IdToController idToController;
  for(;;) {
    //try {
    if(number-- > 0) {
      // ³å
      printf("connecting...\n");
      output.clear();
      output.put(AK_CONNECT);
      Output::Cursor base = output.put(~(S32)0);
      output.put((S32)number);    // temporaryId
      output.put((S32)0);         // version
      output.put(~(S32)0);
      output.setSize(base);
      output.put(HEADER_NULL);
      socket.send(output, to, -1);
    }
    // 
    socket.receive(input);

    for(;;) {
      Header header = input.get();
      if(header == HEADER_NULL)
	break;
      S32 size = input.get();
      
      Input::Cursor start = input.cursor();
      //fprintf(stderr, "Received header=0x%X.\n", (int)header);
      switch(header) {
      default:
	fprintf(stderr, "Unknown header. 0x%lX\n", (long)header);
	break;
      case KA_CONNECT_ERROR:
	{
	  std::string reason;
	  input.get();    // temporaryId
	  input.getString(reason);
	  fprintf(stderr, "Connection failed. '%s'\n", reason.c_str());
	  number = 0;
	  break;
	}
      case KA_CONNECT_OK:
	connectOk(idToController, socket, input, output);
	break;
      case KA_SENSE:
	senseReveived(idToController, socket, input, output);
	break;
      case KA_HEAR:
	hearReveived(idToController, socket, input, output);
	break;
      }
      input.setCursor(start);
      input.skip(size);
    }
  }
  return 0;
}

void connectOk(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output){
  /*S32 temporaryId = */ input.get();
  Id selfId = input.get();
  
  // ack
  output.clear();
  output.put(AK_ACKNOWLEDGE);
  Output::Cursor base = output.put(~(S32)0);
  output.put(selfId);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, socket.addressRecievedFrom(), -1);
    
  AutoPtr<Controller> controller = AutoPtr<Controller>(new SampleController(selfId, socket.addressRecievedFrom(), input));
  idToController[selfId] = controller;
  printf("connect ok: id=%ld\n", (long)selfId);
}

void senseReveived(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output){
  Id id = input.get();
  Controller* controller = idToController[id].get();
  controller->sensed(socket, input, output);
}

void hearReveived(IdToController& idToController, LongUDPSocket& socket, Input& input, Output& output){
  //printf("hearReveived\n");
  Id id = input.get();
  Controller* controller = idToController[id].get();
  Id speaker = input.get();
  std::string message;
  input.getString(message);
  controller->heard(socket, speaker, message.c_str(), input, output);
}


// ʲSampleController ѥ


typedef std::vector<const MotionlessObject*> Places;
class Comparer : public std::binary_function<Places, Places, bool> {
    double m_x, m_y;
public:
  Comparer() {
  }
  Comparer(double x, double y) {
    m_x = x;
    m_y = y;
  }
  bool operator()(const Places& lhs, const Places& rhs) const {
    const MotionlessObject* l = lhs.back();
    const MotionlessObject* r = rhs.back();
    double x1 = l->x() - m_x;
    double y1 = l->y() - m_y;
    double x2 = r->x() - m_x;
    double y2 = r->y() - m_y;
    return (x1 * x1 + y1 * y1 < x2 * x2 + y2 * y2);
  }
};


void SampleController::sensed(LongUDPSocket& socket, Input& input, Output& output){
  S32 time = input.get();
  m_pool.restructure(time, input);

  Object* selfObject = m_pool.get(m_selfId);
  Humanoid* self = dynamic_cast<Humanoid*>(selfObject);
  if(self == 0)
    return;
  
  const Object* destination = m_pool.get(m_destination);
  if(destination == 0)
    return;
  
  const MotionlessObject* current = dynamic_cast<MotionlessObject*>(self->position());
  if(current == 0)
    return;     // on a ambulance etc.
  
  if(self->buriedness() > 0)
    return;     // cannot move!

  bool arrive = false;
  const Node* nodeDestination = dynamic_cast<const Node*>(destination);
  if(nodeDestination != 0) {
    if(self->isOn(nodeDestination))
      arrive = true;
  } else {
    if(current == destination)
      arrive = true;
  }
  if(arrive) {
    // say to myself.
    output.clear();
    output.put(AK_SAY);
    Output::Cursor base = output.put(~(S32)0);
    output.put(m_selfId);                   // the ID of self
    output.putString("What a relief!");     // the message to say
    output.put(m_selfId);                   // the ID of target
    output.setSize(base);
    output.put(HEADER_NULL);
    //printf("saying\n");
    socket.send(output, m_to, time);
        
    m_destination = 0;

    return;
  }

  // õ
  typedef std::set<Places, Comparer> Set;

  Set set(Comparer(destination->x(), destination->y()));
  set.insert(Places(1, current));
  for(;;) {
    if(set.empty())
      return;
    Set::iterator bestIt = set.begin();
    const Places& best = *bestIt;
    if(best.back() == destination || best.size() > 50)
      break;  // ȯ50꿼õ齪λ
    Places tmp;
    const MotionlessObject* place = best.back();
    Objects::const_iterator it = place->neighbors().begin();
    for(; it != place->neighbors().end(); it++) {
      ASSERT(dynamic_cast<const MotionlessObject*>(*it) != 0);
      const MotionlessObject* neighbor = (const MotionlessObject*)*it;
      if(std::find(best.begin(), best.end(), neighbor) == best.end()) {
	tmp = best;
	tmp.push_back(neighbor);
	set.insert(tmp);
      }
    }
    set.erase(bestIt);
  }

  // ϥХåե
  output.clear();
  output.put(AK_MOVE);
  Output::Cursor base = output.put(~(S32)0);
  output.put(m_selfId);

  // õ̤
  const Places& best = *set.begin();
  Places::const_iterator it = best.begin();
  ASSERT(it != best.end());
  for(it++; it != best.end(); it++) {
    output.put((*it)->id());
  }
  output.put((Id)0);

  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, m_to, time);
}

void SampleController::heard(LongUDPSocket& socket, Id speaker, const char* message, Input& input, Output& output)
{
    printf("heard '%s'\n", message);
}
