/*
 * Header    :
 * File      : RescueAgentBase.cxx
 * Auther    : Kosuke Shinoda
 * Since     :
 * Time-stamp: <2002-02-04 02:51:36 kshinoda>
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#include <fstream>
#include "RescueAgentBase.hxx"

namespace RescueCivilian {
  using namespace Itk;
  using namespace Rescue;

  //--------------------------------------------------
  //
  Sexp RescueAgentBase::bodyAction_(Sexp::T_Atom, SubString("_body_action_"));
  Sexp* RescueAgentBase::bodyAction = &bodyAction_;
  Sexp RescueAgentBase::sayAction_(Sexp::T_Atom, SubString("_say_action_"));
  Sexp* RescueAgentBase::sayAction = &sayAction_;
  Sexp RescueAgentBase::changeSituation_(Sexp::T_Atom, SubString("_situation_chenge"));
  Sexp* RescueAgentBase::changeSituation = &changeSituation_;


  //--------------------------------------------------
  //
  void RescueAgentBase::init(){
  };
    
  
  //--------------------------------------------------
  // PositTable Operator
  Bool RescueAgentBase::find(Sexp* posit_name) {
    if(posit_name->isSymbol()) {
      PositTable::const_iterator it = positTable()->find(posit_name->symVal());
      if(it != positTable()->end()){
	return True;
      }
    }
    return False;
  };

  //--------------------------------------------------
  // PositTable
  void RescueAgentBase::setPositTable(const char* filename, Sexp::Heap* heap){
    std::ifstream from(filename);
    if(!from){
      ITK_WRN("Illigal filename : " << filename);
      return;
    }
    return setPositTable(from, heap);
  };
  void RescueAgentBase::setPositTable(istream* from, Sexp::Heap* heap){
    Sexp* posits = heap->scan(from);
    posits->fixTag();
    nop();
    return setPositTable(posits, heap);
  };
  void RescueAgentBase::setPositTable(Sexp* posits, Sexp::Heap* heap){
    for(Sexp* r = posits; r->isCons(); r = r->cdr()){
      Sexp* form = r->car();
      Sexp* header = form->first();
      if(!header->isCons()){
	if(header->equal(Posit::PositTagStr)){
	  Posit * posit = new Posit() ;
	  posit->set(form, heap);
	  positTable()->insert(pair<SubString, Posit*>(posit->name(), posit));
	} 
	else if(header->equal("gsetq")){
	  Sexp* var = form->nth(1);
	  Sexp* val = rescueengine().eval(form->nth(2));
	  if(!rescueengine().isVar(var)){
	    ITK_WRN("variable should be a symbol with prefix * :" << form) ;
	  }
	  globalvar().let(var->symVal(), val, True);
	  ITK_DSC(rescueengine().context().globalvar());
	} else {
	  ITK_WRN("Illegal description form : " << form);
	  continue;
	}
      }
    }
  };
  
  Posit* RescueAgentBase::getPosit(const char* positname){
    PositTable::const_iterator it =
      positTable()->find(SubString(const_cast<char*>(positname)));
    if(it != positTable()->end())
      return it->second;
    else {
      ITK_WRN("error posit name" << positname);
      return 0;
    }
  };

  Posit* RescueAgentBase::getPosit(SubString& positname){
    PositTable::const_iterator it = positTable()->find(positname);
    if(it != positTable()->end())
      return it->second;
    else {
      ITK_WRN("error posit name" << positname);
      return 0;
    }      
  };

  Posit* RescueAgentBase::getPosit(Sexp* positname){
    PositTable::const_iterator it = positTable()->find(positname->symVal());
    if(it != positTable()->end())
      return it->second;
    else {
      ITK_WRN("error posit name" << positname);
      return 0;
    }      
  };


  //--------------------------------------------------
  // RescueAgentBase::situation_add(Sexp*)
  Bool RescueAgentBase::situation_add(Sexp* in_positname){
    Posit* posit = 0;
    if(find(in_positname))
      posit = getPosit(in_positname->symVal());
    else
      return False;

    if(situation().find(posit) == situation().end())
      situation().add(posit);
    else {
      ITK_WRN("this posit already exists in situation : " << posit);
      return False;
    }
    return True;
  };
  Bool RescueAgentBase::situation_remove(Sexp* out_positname){
    Posit* posit = 0;
    if(find(out_positname))
      posit = getPosit(out_positname->symVal());
    else 
      return False;
    if(situation().find(posit) != situation().end())
      situation().remove(posit);
    else {
      ITK_WRN("no existance of this positname in situation: " << posit);
      return False;
    }
    return True;
  };
  Bool RescueAgentBase::situation_swap(Sexp* in_positname,
				       Sexp* out_positname){
    if(!situation_add(in_positname))
      return False;
    return situation_remove(out_positname);
  };
  void RescueAgentBase::situation_clear() {
    situation().clear();
  };

};
