/*
 * Header    :
 * File      : Controller.hxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/16
 * LastUpdate: 2001/11/16
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef __Controller_hxx__
#define __Controller_hxx__

#include "../itk/itk.h"
#include "../rescuelang/EvalEngine.h"
#include "../librescue/librescue.hxx"

using namespace Rescue;
using namespace Itk;

namespace RescueCivilian {
  
  typedef list<MotionlessObject*> Path;

  class Controller {
  public:
    S32     m_time;
    ITK_DEF_ACCESS(S32 time(), { return m_time; });
    Id      m_selfId;
    ITK_DEF_ACCESS(Id selfid(), { return m_selfId; });

  protected:
    Address m_to;
    ITK_DEF_ACCESS(Address& to(), { return m_to; });
  
    LongUDPSocket* m_socket;
    ITK_DEF_ACCESS(LongUDPSocket& socket(), { return *m_socket; });
    ITK_DEF_ACCESS3(LongUDPSocket*, &_socket(), { return m_socket; });

    Input*  m_input;
    ITK_DEF_ACCESS(Input& input(), { return *m_input; });
    ITK_DEF_ACCESS3(Input*, &_input(), { return m_input; });

    Output* m_output;
    ITK_DEF_ACCESS(Output& output(), { return *m_output; });
    ITK_DEF_ACCESS3(Output*, &_output(), { return m_output; });    

  public:
    virtual ~Controller() {}
    //--------------------------------------------------
    // Controller :: constructor
    Controller(Id selfId, const Address& to, 
	       LongUDPSocket& sock, Input& in, Output& out){
      m_selfId = selfId;
      m_to     = to;
      _socket() = &sock;
      _input()  = &in;
      _output() = &out;
      m_time = 0;
    };
  
    //--------------------------------------------------
    // Controller InputSensor
    virtual void sensed(S32 time, 
			LongUDPSocket& socket, 
			Input& input,Output& output) = 0;
    virtual void heard(LongUDPSocket& socket, Id speaker, 
		       const char* message,
		       Input& input, Output& output) = 0;
  public:
    virtual Bool needToCycle() = 0;
    virtual void needToCycle2(Sexp* result) = 0;
    virtual Sexp* cycle() = 0;
    virtual void nextstep() = 0;
    //--------------------------------------------------
    // Controller :: agent command
    void move(LongUDPSocket& socket, Path& path, Output& output);
    void say(LongUDPSocket& socket,const char* message, Output& output);
    void tell(LongUDPSocket& socket,const char* message,  Output& output);
    void extinguish(LongUDPSocket& socket, Id id, 
		    S32 x, S32 y, 
		    S32 amount_of_water, 
		    Output& output);
    
  private:
    Controller(const Controller& source);
    Controller& operator=(const Controller& rhs);
    bool operator== (const Controller& rhs) const;
  };
};
#endif
