/*
 * Decompiled with CFR 0.152.
 */
package viewerServer;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import rescue.LongUDPSocket;
import viewerServer.logController;
import viewerServer.logReceiver;
import viewerServer.mainFrame;

public class viewerServer
extends Thread {
    logController lc;
    mainFrame mf;
    logReceiver lr;
    static final int MAX_VIEWER = 8;
    viewerClients viewers = new viewerClients(8);
    LongUDPSocket _socket;
    static final int HEADER_NULL = 0;
    static final int AK_CONNECT = 16;
    static final int AK_ACKNOWLEDGE = 17;
    static final int KA_CONNECT_OK = 80;
    static final int KA_CONNECT_ERROR = 81;
    static final int KA_SENSE = 82;
    static final int SK_CONNECT = 32;
    static final int SK_ACKNOWLEDGE = 33;
    static final int SK_UPDATE = 34;
    static final int KS_CONNECT_OK = 96;
    static final int KS_CONNECT_ERROR = 97;
    static final int KS_COMMANDS = 98;
    static final int KS_UPDATE = 99;
    static final int ZK_CONNECT = 79;
    static final int KZ_DATA = 15;
    static final int VK_CONNECT = 32;
    static final int VK_ACKNOWLEDGE = 33;
    static final int KV_CONNECT_OK = 96;
    static final int KV_CONNECT_ERROR = 97;
    static final int KV_UPDATE = 99;
    static final int VV_REGISTER = 240;
    static final int VV_ACKNOWLEDGE = 241;
    static final int VV_QUERY = 242;
    static final int VV_SEND = 243;
    static final int VV_ATTENTION = 244;
    static final int VC_STATUS_OFFLINE = 0;
    static final int VC_STATUS_CONNECTED = 1;
    static final int VC_STATUS_WAITACK = 2;
    static final int VC_STATUS_READY = 3;
    static final int VC_STATUS_SNEDMSG = 4;
    static final int VC_STATUS_BROADCAST = 5;

    public viewerServer(int n, logController logController2, mainFrame mainFrame2, logReceiver logReceiver2) {
        this.lc = logController2;
        this.mf = mainFrame2;
        this.lr = logReceiver2;
        try {
            this._socket = new LongUDPSocket(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (mainFrame2.verbose()) {
            System.err.println("viewerServer: Socket " + n + " Ready");
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    int n;
                    if (this.mf.verbose()) {
                        System.err.println("viewerServer: Ready, waiting for connection");
                    }
                    DataInputStream dataInputStream = new DataInputStream(this._socket.receive());
                    InetAddress inetAddress = this._socket.getAddress();
                    viewerClient viewerClient2 = this.viewers.find(inetAddress, n = this._socket.getPort());
                    if (viewerClient2 == null) {
                        viewerClient2 = this.viewers.add(inetAddress, n);
                        if (viewerClient2 == null) {
                            System.err.println("Too many viewers (not connected)");
                        } else {
                            System.err.println("viewerServer:New connection from " + viewerClient2.info());
                            this.mf.setViewerInfo(viewerClient2.cid, viewerClient2.shortInfo(), "Connected", Color.green, "", 0);
                            viewerClient2.catchUp(this.lc.masterTime, this.lr);
                        }
                    } else {
                        System.err.println("viewerServer:Continue connection from " + viewerClient2.info());
                    }
                    this.parse(dataInputStream, viewerClient2);
                    viewerClient2.updateFrame();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    void parse(DataInputStream dataInputStream, viewerClient viewerClient2) {
        try {
            boolean bl = false;
            int n = dataInputStream.readInt();
            while (n != 0) {
                int n2 = dataInputStream.readInt();
                block1 : switch (n) {
                    case 32: {
                        this._socket.send(this.lr.getConnectMessage(), viewerClient2.address, viewerClient2.port);
                        viewerClient2.status = 2;
                        break;
                    }
                    case 33: {
                        if (viewerClient2.status == 2) {
                            viewerClient2.status = 3;
                            System.err.println(viewerClient2.info() + "is ready");
                            break;
                        }
                        System.err.println(viewerClient2.info() + "re-send data");
                        this._socket.send(this.lr.getConnectMessage(), viewerClient2.address, viewerClient2.port);
                        break;
                    }
                    case 240: {
                        System.err.println("VV_REGISTER from " + viewerClient2.shortInfo());
                        int n3 = dataInputStream.readInt();
                        String string = this.readString(dataInputStream, n2 - 4);
                        viewerClient2.register(n3, string.toString());
                        viewerClient2.setStatus(2);
                        viewerClient2.send(this.regAck(0, viewerClient2));
                        viewerClient2.setStatus(3);
                        break;
                    }
                    case 242: {
                        System.err.println("VV_QUERY from " + viewerClient2.shortInfo());
                        int n4 = dataInputStream.readInt();
                        switch (n4) {
                            case 1: {
                                break block1;
                            }
                            case 2: {
                                break block1;
                            }
                        }
                        break;
                    }
                    case 243: {
                        byte[] byArray;
                        System.err.println("VV_SEND from " + viewerClient2.shortInfo());
                        int n5 = dataInputStream.readInt();
                        int n6 = dataInputStream.readInt();
                        if (n6 == 0) {
                            viewerClient2.setStatus(5);
                            byArray = this.readBytes(dataInputStream, n2 - 8);
                            this.viewers.broadcast(viewerClient2, this.attention(n5, n6, byArray));
                            break;
                        }
                        viewerClient2.setStatus(4);
                        byArray = this.readBytes(dataInputStream, n2 - 8);
                        break;
                    }
                    default: {
                        System.err.println("OTHER MESSAGE, just ignored");
                    }
                }
                n = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    String readString(DataInputStream dataInputStream, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n / 2) {
            try {
                stringBuffer.append(dataInputStream.readChar());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    byte[] readBytes(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                byArray[n2] = dataInputStream.readByte();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return byArray;
    }

    byte[] regAck(int n, viewerClient viewerClient2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(241);
            dataOutputStream.writeInt(8);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(viewerClient2.cid);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] attention(int n, int n2, byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(244);
            dataOutputStream.writeInt(8 + byArray.length);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    void broadcast(byte[] byArray) {
        this.viewers.broadcast(null, byArray);
    }

    void broadcast(viewerClient viewerClient2, byte[] byArray) {
        this.viewers.broadcast(viewerClient2, byArray);
    }

    void sendMsg(String string, viewerClient viewerClient2) {
        this.sendMsg(string, viewerClient2.address, viewerClient2.port);
    }

    void sendMsg(String string, InetAddress inetAddress, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(243);
            dataOutputStream.writeInt(string.length() * 2 + 4);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeChars(string);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, inetAddress, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void catchUpAllClients(int n, logReceiver logReceiver2) {
        this.viewers.catchUpAllClients(n, logReceiver2);
    }

    class viewerClients {
        viewerClient[] viewers;
        int max = 0;
        int nextViewer;

        viewerClients(int n) {
            this.viewers = new viewerClient[n];
            this.max = n;
            this.nextViewer = 0;
        }

        viewerClient find(viewerClient viewerClient2) {
            return this.find(viewerClient2.address, viewerClient2.port);
        }

        viewerClient find(InetAddress inetAddress, int n) {
            int n2 = 0;
            while (n2 < this.nextViewer) {
                if (this.viewers[n2] != null && this.viewers[n2].equals(inetAddress, n)) {
                    return this.viewers[n2];
                }
                ++n2;
            }
            return null;
        }

        viewerClient add(InetAddress inetAddress, int n, String string) {
            viewerClient viewerClient2 = this.add(inetAddress, n);
            viewerClient2.setName(string);
            return viewerClient2;
        }

        viewerClient add(InetAddress inetAddress, int n) {
            viewerClient viewerClient2 = null;
            if (this.find(inetAddress, n) != null) {
                return null;
            }
            if (this.nextViewer > 8) {
                System.err.println("Too many viewers");
                return null;
            }
            this.viewers[this.nextViewer] = viewerClient2 = new viewerClient(inetAddress, n, this.nextViewer + 1);
            ++this.nextViewer;
            return viewerClient2;
        }

        void broadcast(viewerClient viewerClient2, byte[] byArray) {
            int n = 0;
            while (n < this.nextViewer) {
                viewerClient viewerClient3 = this.viewers[n];
                if (viewerClient3 != null && viewerClient3 != viewerClient2) {
                    if (viewerServer.this.mf.verbose()) {
                        System.err.println("Send to " + viewerClient3.info());
                    }
                    if (viewerClient3.status == 3 || viewerClient3.status == 4 || viewerClient3.status == 5) {
                        viewerClient3.send(byArray);
                        viewerClient3.status = 3;
                        viewerClient3.updateFrame();
                    }
                }
                ++n;
            }
        }

        void catchUpAllClients(int n, logReceiver logReceiver2) {
            int n2 = 0;
            while (n2 < this.nextViewer) {
                viewerClient viewerClient2 = this.viewers[n2];
                if (viewerClient2 != null) {
                    viewerClient2.catchUp(n, logReceiver2);
                }
                ++n2;
            }
        }
    }

    class viewerClient {
        int cid;
        InetAddress address;
        int port;
        int status = 0;
        int type;
        String nickName = null;
        int displayTime = -1;

        viewerClient(InetAddress inetAddress, int n, int n2) {
            this.address = inetAddress;
            this.port = n;
            this.cid = n2;
            this.status = 1;
            this.type = 0;
        }

        boolean equals(viewerClient viewerClient2) {
            return this.equals(viewerClient2.address, viewerClient2.port);
        }

        boolean equals(InetAddress inetAddress, int n) {
            return this.address.equals(inetAddress) && this.port == n;
        }

        void register(int n, String string) {
            this.type = n;
            this.nickName = string;
        }

        void setName(String string) {
            this.nickName = string;
        }

        String getName() {
            return this.nickName;
        }

        String info() {
            return " " + this.cid + ":[viewerClient: Address = " + this.address + ",Port = " + this.port + "]";
        }

        String shortInfo() {
            return " " + this.cid + ":[" + this.address + ", " + this.port + "]";
        }

        void incDisplayTime() {
            ++this.displayTime;
        }

        void resetDisplayTime() {
            this.displayTime = 0;
        }

        void setDisplayTime(int n) {
            this.displayTime = n;
        }

        void setStatus(int n) {
            this.status = n;
        }

        String status() {
            switch (this.status) {
                case 0: {
                    return "Offline";
                }
                case 1: {
                    return "Connected";
                }
                case 2: {
                    return "ack wait";
                }
                case 3: {
                    return "Ready";
                }
                case 4: {
                    return "Send";
                }
                case 5: {
                    return "Broadcast";
                }
            }
            return "Unknown";
        }

        Color statusColor() {
            switch (this.status) {
                case 0: {
                    return Color.gray;
                }
                case 1: {
                    return Color.yellow;
                }
                case 2: {
                    return Color.cyan;
                }
                case 3: {
                    return Color.green;
                }
                case 4: {
                    return Color.orange;
                }
                case 5: {
                    return Color.red;
                }
            }
            return Color.blue;
        }

        void print() {
            System.out.print(this.info());
        }

        void println() {
            System.out.println(this.info());
        }

        void send(int n, byte[] byArray) {
            this.send(byArray);
            this.displayTime = n;
            this.updateFrameTime();
        }

        void send(byte[] byArray) {
            try {
                viewerServer.this._socket.send(byArray, this.address, this.port);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        void catchUp(int n, logReceiver logReceiver2) {
            int n2 = this.displayTime + 1;
            while (n2 <= n) {
                this.send(n2, logReceiver2.getMessage(n2));
                ++n2;
            }
            this.displayTime = n;
        }

        void updateFrame() {
            viewerServer.this.mf.setViewerInfo(this.cid, this.shortInfo(), this.status(), this.statusColor(), this.nickName, this.displayTime);
        }

        void updateFrameTime() {
            viewerServer.this.mf.setViewerInfo(this.cid, this.displayTime);
        }
    }
}

