/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import viewer.Map;
import viewer.logPool;
import viewer.sizedPanel;
import viewer.statCanvas;

public class statFrame
extends Frame {
    private logPool lp;
    private Map m;
    int num;
    static String[] modeName = new String[]{"Evaluation(2002)", "Current Status(VBar)", "Summary(Text)", "Damage Report(Text)", "BuildingDamage(Pie)", "TimeLine(HBar)", "HumanDamage", "RoadDamage", "BuildingDamage2(Pie)", "BuildingDamage(VBar)", "Evaluation(2001)", "History"};
    Choice displayMode;
    Choice lang;
    Label label1;
    statCanvas canvas1;
    Label title;

    public statFrame(String string, int n, logPool logPool2, Map map, int n2) {
        super(string);
        this.lp = logPool2;
        this.m = map;
        this.num = n;
        this.addWindowListener(new statWindowAdapter());
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        this.add("North", panel);
        this.title = new Label("TITLE DISPLAY PANEL", 1);
        this.title.setFont(new Font("Helvetica", 3, 18));
        this.title.setForeground(new Color(0x404040));
        sizedPanel sizedPanel2 = new sizedPanel(this.title, 300, 30);
        panel.add(sizedPanel2);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this.add("Center", panel2);
        this.canvas1 = new statCanvas(logPool2, n2, Map.unitBuildingValue, Map.unitRoadValue, Map.timeLimit, Map.lang);
        this.canvas1.setBounds(0, 0, 200, 220);
        panel2.add(this.canvas1);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(0, 1, 1));
        this.add("South", panel3);
        this.label1 = new Label("Mode", 1);
        this.label1.setFont(new Font("Helvetica", 1, 14));
        this.label1.setForeground(new Color(0x404040));
        panel3.add(this.label1);
        this.displayMode = new Choice();
        n = 0;
        while (n < modeName.length) {
            this.displayMode.addItem(modeName[n]);
            ++n;
        }
        try {
            this.displayMode.select(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setModeTitle(n2);
        this.displayMode.setBounds(20, 220, 130, 40);
        panel3.add(this.displayMode);
        this.lang = new Choice();
        this.lang.addItem("English");
        this.lang.addItem("Japanese");
        try {
            this.lang.select(Map.lang);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.canvas1.setLang(this.lang.getSelectedIndex());
        this.lang.setBounds(20, 120, 130, 40);
        panel3.add(this.lang);
        SymItem symItem = new SymItem();
        this.displayMode.addItemListener(symItem);
        this.lang.addItemListener(symItem);
    }

    public void update() {
        Image image = this.canvas1.createImage(this.canvas1.getSize().width, this.canvas1.getSize().height);
        Graphics graphics = image.getGraphics();
        this.paint(graphics);
        this.canvas1.getGraphics().drawImage(image, 0, 0, this.canvas1);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        this.canvas1.update(graphics);
    }

    void displayMode_ItemStateChanged(ItemEvent itemEvent) {
        this.canvas1.setDisplayMode(this.displayMode.getSelectedIndex());
        this.setModeTitle(this.displayMode.getSelectedIndex());
    }

    void lang_ItemStateChanged(ItemEvent itemEvent) {
        this.canvas1.setLang(this.lang.getSelectedIndex());
        Map.lang = this.lang.getSelectedIndex();
    }

    void setModeTitle(int n) {
        this.title.setText(modeName[n]);
    }

    class statWindowAdapter
    extends WindowAdapter {
        statWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            statFrame.this.m.statFrameDisposed(statFrame.this.num);
            statFrame.this.dispose();
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == statFrame.this.displayMode) {
                statFrame.this.displayMode_ItemStateChanged(itemEvent);
            }
            if (object == statFrame.this.lang) {
                statFrame.this.lang_ItemStateChanged(itemEvent);
            }
        }
    }
}

