/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import rescue.Pool;
import viewer.CookedDataInputStream;
import viewer.Map;
import viewer.building;
import viewer.coordinates;
import viewer.cursor;
import viewer.drawing;
import viewer.logPool;
import viewer.mapCanvas;
import viewer.node;
import viewer.road;
import viewer.userModel;

public class buildingMap
extends Frame {
    URL baseURL;
    static long figureID;
    static coordinates offset;
    static coordinates min;
    static coordinates max;
    static coordinates saveMin;
    static coordinates saveMax;
    static float mRatio;
    long nBuilding;
    long nNode;
    long nRoad;
    Hashtable positionObject = new Hashtable(45000);
    Hashtable buildings = new Hashtable(15000);
    Hashtable nodes = new Hashtable(15000);
    Hashtable roads = new Hashtable(15000);
    drawing hw = new drawing();
    public userModel[] ums;
    public int cumn = 0;
    public float displayScale;
    public float newDisplayScale = this.displayScale = 1.0f;
    boolean changed = true;
    static coordinates distance;
    static coordinates origin;
    static coordinates newOrigin;
    static coordinates sentOrigin;
    static float sentDisplayScale;
    static boolean displayPositionValid;
    logPool lp = null;
    static Map mp;
    public Image iconRM;
    public Image iconDR;
    public Image iconFF;
    public Image[] iconMan = new Image[10];
    public Image iconFR;
    public Image iconBubble;
    public Image iconSaved;
    public Image iconDead;
    public Image iconSearch;
    public Image iconFire;
    public double damageBuilding;
    public double damageRoad;
    static double unitBValue;
    static double unitRValue;
    public double areaBurned = 0.0;
    public double areaAll = 0.0;
    public Image[] cursorImage = new Image[7];
    public Image bbubble;
    private String[] cursorFilename = new String[]{"icon/cursor-red.gif", "icon/cursor-blue.gif", "icon/cursor-green.gif", "icon/cursor-magenta.gif", "icon/cursor-orange.gif", "icon/cursor-yellow.gif", "icon/cursor-cyan.gif"};
    public cursor cur;
    static final float margin = 0.1f;
    static Dimension cSize;

    public road getRoad(Integer n) {
        return (road)this.roads.get(n);
    }

    public building getBuilding(Integer n) {
        return (building)this.buildings.get(n);
    }

    public node getNode(Integer n) {
        return (node)this.nodes.get(n);
    }

    public coordinates center() {
        return new coordinates((int)((double)(buildingMap.saveMax.x + buildingMap.saveMin.x) * 0.5), (int)((double)(buildingMap.saveMax.y + buildingMap.saveMin.y) * 0.5));
    }

    public double scale() {
        return Math.max(buildingMap.saveMax.x - buildingMap.saveMin.x, buildingMap.saveMax.y - buildingMap.saveMin.y);
    }

    public buildingMap(URL uRL, Map map, MediaTracker mediaTracker) {
        this.baseURL = uRL;
        mp = map;
        try {
            this.iconRM = this.createImage((ImageProducer)this.getClass().getResource("icon/patrolcar.gif").getContent());
            mediaTracker.addImage(this.iconRM, 2);
            this.iconDR = this.createImage((ImageProducer)this.getClass().getResource("icon/ambulance.gif").getContent());
            mediaTracker.addImage(this.iconDR, 3);
            this.iconFF = this.createImage((ImageProducer)this.getClass().getResource("icon/fireengine.gif").getContent());
            mediaTracker.addImage(this.iconFF, 4);
            this.iconFR = this.createImage((ImageProducer)this.getClass().getResource("icon/fire.gif").getContent());
            mediaTracker.addImage(this.iconFF, 5);
            int n = 0;
            while (n < 10) {
                String string = new String("icon/man0" + n + ".gif");
                this.iconMan[n] = this.createImage((ImageProducer)this.getClass().getResource(string).getContent());
                mediaTracker.addImage(this.iconMan[n], 6 + n);
                ++n;
            }
            this.iconBubble = this.createImage((ImageProducer)this.getClass().getResource("icon/bubble.gif").getContent());
            this.iconSaved = this.createImage((ImageProducer)this.getClass().getResource("icon/saved.gif").getContent());
            this.iconDead = this.createImage((ImageProducer)this.getClass().getResource("icon/dead.gif").getContent());
            this.iconSearch = this.createImage((ImageProducer)this.getClass().getResource("icon/search.gif").getContent());
            this.iconFire = this.createImage((ImageProducer)this.getClass().getResource("icon/fire.gif").getContent());
            this.bbubble = this.createImage((ImageProducer)this.getClass().getResource("icon/bbubble.gif").getContent());
            int n2 = 0;
            while (n2 < 7) {
                this.cursorImage[n2] = this.createImage((ImageProducer)this.getClass().getResource(this.cursorFilename[n2]).getContent());
                ++n2;
            }
            if (this.iconRM == null) {
                System.err.println("icon load failed");
            }
            this.hw.newBubbleIcon(0.0f, 0.0f, this.bbubble);
        }
        catch (Exception exception) {
            System.err.println("Can't load icon");
        }
        map.soundEffect(0);
        this.ums = new userModel[6];
        this.ums[0] = new userModel();
        this.ums[0].setAudience();
        this.ums[1] = new userModel();
        this.ums[1].setSupervisor();
        this.ums[2] = new userModel();
        this.ums[2].setAgentDeveloper();
        this.ums[3] = new userModel();
        this.ums[3].setSimulatorDeveloper();
        this.ums[4] = new userModel();
        this.ums[4].setGeek();
        this.ums[5] = new userModel();
        this.ums[5].setCustom();
        this.cumn = 5;
        this.cur = new cursor(0.0f, 0.0f, this.cursorImage[0]);
    }

    public boolean loadBuilding(String string) {
        InputStream inputStream = null;
        CookedDataInputStream cookedDataInputStream = null;
        try {
            Class<?> clazz = this.getClass();
            inputStream = clazz.getResourceAsStream(string);
            cookedDataInputStream = new CookedDataInputStream(inputStream);
            this.nBuilding = this.loadBuildingHeader(cookedDataInputStream);
            int n = 0;
            while ((long)n < this.nBuilding) {
                building building2 = new building(cookedDataInputStream, this);
                this.buildings.put(building2.id, building2);
                if (building2.center.x < buildingMap.min.x) {
                    buildingMap.min.x = building2.center.x;
                }
                if (building2.center.y < buildingMap.min.y) {
                    buildingMap.min.y = building2.center.y;
                }
                if (building2.center.x > buildingMap.max.x) {
                    buildingMap.max.x = building2.center.x;
                }
                if (building2.center.y > buildingMap.max.y) {
                    buildingMap.max.y = building2.center.y;
                }
                if (this.positionObject.get(building2.center.hashValue()) != null) {
                    System.err.println("Duplicated Hash Value " + building2.id + "HashValue = " + building2.center.hashValue());
                }
                this.positionObject.put(building2.center.hashValue(), building2);
                ++n;
            }
            cookedDataInputStream.close();
            inputStream.close();
            saveMax = new coordinates(max);
            saveMin = new coordinates(min);
            mRatio = (float)(buildingMap.max.x - buildingMap.min.x) / (float)(buildingMap.max.y - buildingMap.min.y);
            origin = new coordinates(buildingMap.min.x, buildingMap.min.y);
            newOrigin = new coordinates(origin);
            sentOrigin = new coordinates(0, 0);
        }
        catch (Exception exception) {
            System.err.println("File IO Error: " + string);
            return false;
        }
        return true;
    }

    long loadBuildingHeader(CookedDataInputStream cookedDataInputStream) {
        long l = 0L;
        try {
            figureID = cookedDataInputStream.readCookedUnsigned();
            buildingMap.offset.x = cookedDataInputStream.readCookedLong();
            buildingMap.offset.y = cookedDataInputStream.readCookedLong();
            l = cookedDataInputStream.readCookedUnsigned();
        }
        catch (Exception exception) {
            System.err.println("polygon: FATAL: Mal Formed Header");
            return l;
        }
        return l;
    }

    long skipHeader(CookedDataInputStream cookedDataInputStream) {
        long l = 0L;
        try {
            long l2 = cookedDataInputStream.readCookedUnsigned();
            l2 = cookedDataInputStream.readCookedLong();
            l2 = cookedDataInputStream.readCookedLong();
            l = cookedDataInputStream.readCookedUnsigned();
        }
        catch (Exception exception) {
            System.err.println("polygon: FATAL: Mal Formed Header");
            return 0L;
        }
        return l;
    }

    public void printBuildingHeader() {
        System.out.println("FIGURE ID:" + figureID);
        System.out.print("OFFSET =");
        offset.print();
        System.out.println("#BUILDING:" + this.nBuilding);
        System.out.print("min(original) = ");
        saveMin.print();
        System.out.print("max(original) = ");
        saveMax.print();
        System.out.print("min = ");
        min.print();
        System.out.print("max = ");
        max.print();
        System.out.print("distance = ");
        distance.print();
        System.out.print("origin = ");
        origin.print();
    }

    public synchronized boolean adjustRatio(mapCanvas mapCanvas2) {
        if (buildingMap.cSize.width == mapCanvas2.getSize().width && buildingMap.cSize.height == mapCanvas2.getSize().height) {
            return false;
        }
        min = new coordinates(saveMin);
        max = new coordinates(saveMax);
        distance = new coordinates(buildingMap.max.x - buildingMap.min.x, buildingMap.max.y - buildingMap.min.y);
        buildingMap.min.x = (int)((float)buildingMap.min.x - (float)buildingMap.distance.x * 0.1f);
        buildingMap.min.y = (int)((float)buildingMap.min.y - (float)buildingMap.distance.y * 0.1f);
        buildingMap.max.x = (int)((float)buildingMap.max.x + (float)buildingMap.distance.x * 0.1f);
        buildingMap.max.y = (int)((float)buildingMap.max.y + (float)buildingMap.distance.y * 0.1f);
        float f = (float)mapCanvas2.getSize().width / (float)mapCanvas2.getSize().height;
        buildingMap.cSize.width = mapCanvas2.getSize().width;
        buildingMap.cSize.height = mapCanvas2.getSize().height;
        if (f < mRatio) {
            float f2 = (float)buildingMap.distance.x / f - (float)buildingMap.distance.y;
            buildingMap.min.y = (int)((float)buildingMap.min.y - f2 / 2.0f);
            buildingMap.max.y = (int)((float)buildingMap.max.y + f2 / 2.0f);
        } else {
            float f3 = (float)buildingMap.distance.y * f - (float)buildingMap.distance.x;
            buildingMap.min.x = (int)((float)buildingMap.min.x - f3 / 2.0f);
            buildingMap.max.x = (int)((float)buildingMap.max.x + f3 / 2.0f);
        }
        distance = new coordinates(buildingMap.max.x - buildingMap.min.x, buildingMap.max.y - buildingMap.min.y);
        this.sanityAdjust();
        if (Map.verbose) {
            this.printBuildingHeader();
        }
        displayPositionValid = false;
        return true;
    }

    public boolean loadNode(String string) {
        InputStream inputStream = null;
        CookedDataInputStream cookedDataInputStream = null;
        try {
            Class<?> clazz = this.getClass();
            inputStream = clazz.getResourceAsStream(string);
            cookedDataInputStream = new CookedDataInputStream(inputStream);
            this.nNode = this.skipHeader(cookedDataInputStream);
            int n = 0;
            while ((long)n < this.nNode) {
                node node2 = new node(cookedDataInputStream, this);
                this.nodes.put(node2.id, node2);
                ++n;
            }
            cookedDataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println("File IO Error: " + string);
            return false;
        }
        return true;
    }

    public boolean loadRoad(String string) {
        InputStream inputStream = null;
        CookedDataInputStream cookedDataInputStream = null;
        try {
            Class<?> clazz = this.getClass();
            inputStream = clazz.getResourceAsStream(string);
            cookedDataInputStream = new CookedDataInputStream(inputStream);
            this.nRoad = this.skipHeader(cookedDataInputStream);
            int n = 0;
            while ((long)n < this.nRoad) {
                road road2 = new road(cookedDataInputStream, this);
                this.roads.put(road2.id, road2);
                node node2 = (node)this.nodes.get(road2.startNodeID);
                node node3 = (node)this.nodes.get(road2.endNodeID);
                if (node2.pos.x < buildingMap.min.x) {
                    buildingMap.min.x = node2.pos.x;
                }
                if (node2.pos.y < buildingMap.min.y) {
                    buildingMap.min.y = node2.pos.y;
                }
                if (node3.pos.x > buildingMap.max.x) {
                    buildingMap.max.x = node3.pos.x;
                }
                if (node3.pos.y > buildingMap.max.y) {
                    buildingMap.max.y = node3.pos.y;
                }
                if (this.positionObject.get(road2.center().hashValue()) != null) {
                    System.err.println("Duplicated Hash Value " + road2.id + "HashValue = " + road2.center().hashValue());
                }
                this.positionObject.put(road2.center().hashValue(), road2);
                ++n;
            }
            cookedDataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println("File IO Error: " + string);
            return false;
        }
        return true;
    }

    public void attachObject(logPool logPool2) {
        this.lp = logPool2;
    }

    public boolean zoomIn(TextField textField) {
        if ((double)this.newDisplayScale < 64.0) {
            newOrigin.set((int)((float)buildingMap.newOrigin.x + (float)buildingMap.distance.x / this.newDisplayScale / 4.0f), (int)((float)buildingMap.newOrigin.y + (float)buildingMap.distance.y / this.newDisplayScale / 4.0f));
            this.newDisplayScale = (float)((double)this.newDisplayScale * 2.0);
            textField.setText("X" + (int)this.newDisplayScale);
            this.changed = true;
        }
        return this.changed;
    }

    public boolean zoomOut(TextField textField) {
        if ((double)this.newDisplayScale > 1.0) {
            this.newDisplayScale = (float)((double)this.newDisplayScale / 2.0);
            newOrigin.set((int)((float)buildingMap.newOrigin.x - (float)buildingMap.distance.x / this.newDisplayScale / 4.0f), (int)((float)buildingMap.newOrigin.y - (float)buildingMap.distance.y / this.newDisplayScale / 4.0f));
            this.sanityAdjust();
            textField.setText("X" + (int)this.newDisplayScale);
            this.changed = true;
        }
        return this.changed;
    }

    public boolean setDisplayScale(float f, TextField textField) {
        if ((double)f != 1.0 && (double)f != 2.0 && (double)f != 4.0 && (double)f != 8.0 && (double)f != 16.0 && (double)f != 32.0 && (double)f != 64.0) {
            System.err.println("Invalid scale " + f);
            return this.changed;
        }
        if (f == this.newDisplayScale) {
            return this.changed;
        }
        if (this.newDisplayScale < f) {
            newOrigin.set((int)((float)buildingMap.newOrigin.x + ((float)buildingMap.distance.x / this.newDisplayScale - (float)buildingMap.distance.x / f) / 2.0f), (int)((float)buildingMap.newOrigin.y + ((float)buildingMap.distance.y / this.newDisplayScale - (float)buildingMap.distance.y / f) / 2.0f));
        } else {
            newOrigin.set((int)((float)buildingMap.newOrigin.x - ((float)buildingMap.distance.x / f - (float)buildingMap.distance.x / this.newDisplayScale) / 2.0f), (int)((float)buildingMap.newOrigin.y - ((float)buildingMap.distance.y / f - (float)buildingMap.distance.y / this.newDisplayScale) / 2.0f));
            this.sanityAdjust();
        }
        this.newDisplayScale = f;
        textField.setText("X" + (int)this.newDisplayScale);
        this.changed = true;
        return true;
    }

    boolean sanityPosition(long l, long l2) {
        return l >= (long)buildingMap.min.x && !((float)l + (float)buildingMap.distance.x / this.newDisplayScale > (float)buildingMap.max.x) && l2 >= (long)buildingMap.min.y && !((float)l2 + (float)buildingMap.distance.y / this.newDisplayScale > (float)buildingMap.max.y);
    }

    boolean sanityAdjust() {
        boolean bl = false;
        if (buildingMap.newOrigin.x <= buildingMap.min.x) {
            buildingMap.newOrigin.x = buildingMap.min.x;
            bl = true;
        } else if ((float)buildingMap.newOrigin.x + (float)buildingMap.distance.x / this.newDisplayScale >= (float)buildingMap.max.x) {
            buildingMap.newOrigin.x = buildingMap.max.x - (int)((float)buildingMap.distance.x / this.newDisplayScale);
            bl = true;
        }
        if (buildingMap.newOrigin.y <= buildingMap.min.y) {
            buildingMap.newOrigin.y = buildingMap.min.y;
            bl = true;
        } else if ((float)buildingMap.newOrigin.y + (float)buildingMap.distance.y / this.newDisplayScale >= (float)buildingMap.max.y) {
            buildingMap.newOrigin.y = buildingMap.max.y - (int)((float)buildingMap.distance.y / this.newDisplayScale);
            bl = true;
        }
        return bl;
    }

    public boolean scrollAbsX(int n) {
        if (this.sanityPosition(n, buildingMap.newOrigin.y) && buildingMap.newOrigin.x != n) {
            buildingMap.newOrigin.x = n;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean scrollAbsY(int n) {
        int n2 = (int)((float)(buildingMap.max.y + buildingMap.min.y) - (float)buildingMap.distance.y / this.newDisplayScale - (float)n);
        if (this.sanityPosition(buildingMap.newOrigin.x, n2) && buildingMap.newOrigin.y != n2) {
            buildingMap.newOrigin.y = n2;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean scrollRelativeXY(int n, int n2) {
        int n3 = buildingMap.newOrigin.x + n;
        int n4 = buildingMap.newOrigin.y - n2;
        if (this.sanityPosition(n3, n4)) {
            buildingMap.newOrigin.x = n3;
            buildingMap.newOrigin.y = n4;
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean scrollAbsXY(int n, int n2) {
        int n3 = buildingMap.newOrigin.x;
        int n4 = buildingMap.newOrigin.y;
        buildingMap.newOrigin.x = n - (int)((float)buildingMap.distance.x / this.displayScale / 2.0f);
        buildingMap.newOrigin.y = n2 - (int)((float)buildingMap.distance.y / this.displayScale / 2.0f);
        this.sanityAdjust();
        this.changed = buildingMap.newOrigin.x != n3 || buildingMap.newOrigin.y != n4;
        return this.changed;
    }

    boolean setScreenParam(int n, int n2, float f) {
        buildingMap.newOrigin.x = n;
        buildingMap.newOrigin.y = n2;
        this.newDisplayScale = f;
        buildingMap.mp.displayScale.setText("X" + (int)this.newDisplayScale);
        this.changed = true;
        return true;
    }

    boolean sentDisplayChanged() {
        if (buildingMap.newOrigin.x != buildingMap.sentOrigin.x) {
            return true;
        }
        if (buildingMap.newOrigin.y != buildingMap.sentOrigin.y) {
            return true;
        }
        return this.newDisplayScale != sentDisplayScale;
    }

    void setSentDisplayInfo() {
        buildingMap.sentOrigin.x = buildingMap.newOrigin.x;
        buildingMap.sentOrigin.y = buildingMap.newOrigin.y;
        sentDisplayScale = this.newDisplayScale;
    }

    public boolean focus(TextField textField) {
        float f;
        if (this.ums[this.cumn].eventAutoScale && (f = this.lp.suitableScale(this.ums[this.cumn])) > 1.0f) {
            this.setDisplayScale(f, textField);
        }
        coordinates coordinates2 = this.lp.centerOfAgents(this.ums[this.cumn]);
        return coordinates2.x == 0 && coordinates2.y == 0 ? false : this.scrollAbsXY(coordinates2.x, coordinates2.y);
    }

    public void focusObject(int n, int n2, String string) {
        coordinates coordinates2 = new coordinates();
        Pool._Object _Object2 = (Pool._Object)this.lp._pool.map.get(new Integer(n));
        String string2 = null;
        if (_Object2 == null) {
            System.err.println("Object : " + n + " not found");
            return;
        }
        if (_Object2 instanceof Pool.Humanoid) {
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this.lp._pool.map.get(humanoid.position);
            coordinates2 = this.lp.agentPosition(_Object2);
            string2 = this.lp.objectInfo(_Object2);
        } else if (_Object2 instanceof Pool.Building) {
            building building2 = this.findBuilding(n);
            if (building2 == null) {
                System.err.println("Building : " + n + " not found");
                return;
            }
            coordinates2 = building2.center;
            string2 = building2.descriptionAll();
        } else if (_Object2 instanceof Pool.Road) {
            road road2 = this.findRoad(n);
            if (road2 == null) {
                System.err.println("Road : " + n + " not found");
                return;
            }
            coordinates2 = road2.center();
            string2 = road2.descriptionAll();
        }
        if (n2 == 1) {
            this.scrollAbsXY(coordinates2.x, coordinates2.y);
        }
        this.hw.changeBubbleIcon(coordinates2.x, coordinates2.y, string);
        mp.setInfoText("Received Message : " + string, string2);
    }

    public boolean horizontalscroll(int n) {
        long l = buildingMap.newOrigin.x;
        buildingMap.newOrigin.x += n;
        this.sanityAdjust();
        this.changed = (long)buildingMap.newOrigin.x != l;
        return this.changed;
    }

    public boolean verticalscroll(int n) {
        long l = buildingMap.newOrigin.y;
        buildingMap.newOrigin.y += n;
        this.sanityAdjust();
        this.changed = (long)buildingMap.newOrigin.y != l;
        return this.changed;
    }

    public synchronized void draw(mapCanvas mapCanvas2, Graphics graphics) {
        boolean bl;
        Object object;
        this.adjustRatio(mapCanvas2);
        this.damageRoad = 0.0;
        this.damageBuilding = 0.0;
        this.areaAll = 0.0;
        this.areaBurned = 0.0;
        Image image = mapCanvas2.createImage(mapCanvas2.getSize().width, mapCanvas2.getSize().height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(Color.gray);
        graphics2.fillRect(0, 0, mapCanvas2.getSize().width, mapCanvas2.getSize().height);
        origin.set(newOrigin);
        this.displayScale = this.newDisplayScale;
        displayPositionValid = false;
        Enumeration enumeration = this.roads.keys();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            road road2 = (road)this.roads.get(object);
            road2.draw(mapCanvas2, graphics2);
            this.damageRoad += road2.damage(unitRValue);
        }
        object = this.buildings.keys();
        boolean bl2 = false;
        boolean bl3 = false;
        while (object.hasMoreElements()) {
            Integer n = (Integer)object.nextElement();
            building building2 = (building)this.buildings.get(n);
            if (building2.draw(mapCanvas2, graphics2) && building2.pb != null) {
                if (building2.justBurned()) {
                    bl2 = true;
                }
                if (building2.justExtinguished()) {
                    bl3 = true;
                }
            }
            this.damageBuilding += building2.damage(unitBValue);
            this.areaBurned += building2.burnedArea();
            if (building2.pb != null) {
                this.areaAll += (double)building2.areaAll;
            }
            building2.clearStatus();
        }
        if (bl3) {
            mp.soundEffect(3);
        }
        if (bl = this.lp.drawMovingObject(mapCanvas2, graphics2)) {
            mp.soundEffect(1);
        }
        this.cur.draw(mapCanvas2, graphics2);
        this.hw.draw(mapCanvas2, graphics2);
        graphics.drawImage(image, 0, 0, mapCanvas2);
        graphics2.dispose();
        this.changed = false;
    }

    public building findBuilding(int n, int n2) {
        Enumeration enumeration = this.buildings.keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            building building2 = (building)this.buildings.get(n3);
            if (!building2.inside(n, n2)) continue;
            return building2;
        }
        return null;
    }

    public building findBuilding(int n) {
        Enumeration enumeration = this.buildings.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            building building2 = (building)this.buildings.get(n2);
            if (building2.pb.id != n) continue;
            return building2;
        }
        return null;
    }

    public road findRoad(int n, int n2) {
        Enumeration enumeration = this.roads.keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            road road2 = (road)this.roads.get(n3);
            if (!road2.inside(n, n2)) continue;
            return road2;
        }
        return null;
    }

    public road findRoad(int n) {
        Enumeration enumeration = this.roads.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            road road2 = (road)this.roads.get(n2);
            if (road2.pr.id != n) continue;
            return road2;
        }
        return null;
    }

    static {
        offset = new coordinates();
        min = new coordinates(Integer.MAX_VALUE, Integer.MAX_VALUE);
        max = new coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
        displayPositionValid = false;
        unitBValue = 1.0;
        unitRValue = 1.0;
        cSize = new Dimension(300, 300);
    }
}

