/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import rescue.Pool;
import viewer.CookedDataInputStream;
import viewer.buildingMap;
import viewer.coordinates;
import viewer.displayObject;
import viewer.mapCanvas;
import viewer.node;

public class building
extends displayObject {
    int size;
    public coordinates center = new coordinates();
    int floor;
    int attribute;
    int isBurning;
    int percentageOfBurned;
    int percentageOfBroken;
    int nConnectNode;
    Integer[] connectNode;
    int buildingId;
    int area1f;
    int areaAll;
    int type;
    int nNode;
    coordinates[] nodes;
    Polygon p = null;
    Polygon l = null;
    public Pool.Building pb = null;
    static double[] fnTbl = new double[]{0.0, 25.0, 50.0, 75.0, 100.0, 25.0, 0.0, 100.0, 100.0};

    public building(CookedDataInputStream cookedDataInputStream, buildingMap buildingMap2) {
        int n;
        displayObject.bm = buildingMap2;
        this.size = cookedDataInputStream.readCookedUnsigned();
        this.id = new Integer(cookedDataInputStream.readCookedUnsigned());
        this.center.x = cookedDataInputStream.readCookedUnsigned();
        this.center.y = cookedDataInputStream.readCookedUnsigned();
        this.floor = cookedDataInputStream.readCookedUnsigned();
        this.attribute = cookedDataInputStream.readCookedUnsigned();
        this.isBurning = cookedDataInputStream.readCookedUnsigned();
        this.percentageOfBurned = cookedDataInputStream.readCookedUnsigned();
        this.percentageOfBroken = cookedDataInputStream.readCookedUnsigned();
        this.nConnectNode = cookedDataInputStream.readCookedUnsigned();
        if (this.nConnectNode > 0) {
            this.connectNode = new Integer[this.nConnectNode];
            n = 0;
            while (n < this.nConnectNode) {
                this.connectNode[n] = new Integer(cookedDataInputStream.readCookedUnsigned());
                ++n;
            }
        }
        this.buildingId = cookedDataInputStream.readCookedUnsigned();
        this.area1f = cookedDataInputStream.readCookedUnsigned();
        this.areaAll = cookedDataInputStream.readCookedUnsigned();
        this.type = cookedDataInputStream.readCookedUnsigned();
        this.nNode = cookedDataInputStream.readCookedUnsigned();
        this.nodes = new coordinates[this.nNode];
        n = 0;
        while (n < this.nNode) {
            int n2 = cookedDataInputStream.readCookedUnsigned();
            int n3 = cookedDataInputStream.readCookedUnsigned();
            this.nodes[n] = new coordinates(n2, n3);
            ++n;
        }
    }

    private void createPobject(mapCanvas mapCanvas2, Graphics graphics) {
        int n;
        this.checkDisplaySize(mapCanvas2);
        this.p = new Polygon();
        if (displayObject.bm.ums[displayObject.bm.cumn].showBuildingOutline) {
            n = 0;
            while (n < this.nNode) {
                this.p.addPoint(this.xx(this.nodes[n].x), this.yy(this.nodes[n].y));
                ++n;
            }
        } else {
            n = 1500;
            this.p.addPoint(this.xx(this.center.x - n), this.yy(this.center.y - n));
            this.p.addPoint(this.xx(this.center.x + n), this.yy(this.center.y - n));
            this.p.addPoint(this.xx(this.center.x + n), this.yy(this.center.y + n));
            this.p.addPoint(this.xx(this.center.x - n), this.yy(this.center.y + n));
            this.p.addPoint(this.xx(this.center.x - n), this.yy(this.center.y - n));
        }
        this.l = new Polygon();
        this.l.addPoint(this.xx(this.center.x), this.yy(this.center.y));
        n = 0;
        while (n < this.nConnectNode) {
            node node2 = (node)displayObject.bm.nodes.get(this.connectNode[n]);
            this.l.addPoint(this.xx(node2.pos.x), this.yy(node2.pos.y));
            ++n;
        }
    }

    public Color statColor() {
        if (this.pb != null) {
            Color color;
            if (this.pb instanceof Pool.FireStation) {
                color = Color.blue;
            } else if (this.pb instanceof Pool.AmbulanceCenter) {
                color = Color.white;
            } else if (this.pb instanceof Pool.PoliceOffice) {
                color = Color.yellow;
            } else if (this.pb instanceof Pool.Refuge) {
                color = Color.white;
            } else {
                switch (this.pb.fieryness) {
                    case 1: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? new Color(255, 255, 0) : Color.gray;
                        break;
                    }
                    case 2: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? new Color(255, 80, 0) : Color.gray;
                        break;
                    }
                    case 3: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? Color.red : Color.gray;
                        break;
                    }
                    case 4: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? Color.black : Color.gray;
                        break;
                    }
                    case 5: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? new Color(0, (int)((double)this.pb.brokenness * 2.55), 255) : Color.gray;
                        break;
                    }
                    case 7: {
                        color = displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? new Color(90, (int)((double)this.pb.brokenness * 1.1), 0) : Color.gray;
                        break;
                    }
                    default: {
                        color = Color.lightGray;
                        break;
                    }
                    case 0: {
                        color = this.pb.ignition != 0 && displayObject.bm.ums[displayObject.bm.cumn].showBuildingBurning ? new Color(255, 255, 0) : (displayObject.bm.ums[displayObject.bm.cumn].showBuildingBroken ? new Color(0, (int)((double)(100 - this.pb.brokenness) * 2.55), 0) : Color.gray);
                    }
                }
            }
            return color;
        }
        return Color.gray;
    }

    public boolean draw(mapCanvas mapCanvas2, Graphics graphics) {
        if (!this.isOnScreen()) {
            this.p = null;
            return false;
        }
        if (displayObject.bm.changed || this.p == null) {
            this.createPobject(mapCanvas2, graphics);
        }
        if (this.pb != null) {
            graphics.setColor(this.statColor());
            graphics.fillPolygon(this.p);
            int n = this.iconSize();
            if (this.pb.justExtinguished) {
                this.drawIcon(graphics, displayObject.bm, this.center.x, this.center.y, displayObject.bm.iconBubble, n, 0);
            }
            if (this.pb.justBurned) {
                this.drawIcon(graphics, displayObject.bm, this.center.x, this.center.y, displayObject.bm.iconFire, n, 0);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawPolygon(this.p);
        if (displayObject.bm.ums[displayObject.bm.cumn].showRoadPathway) {
            graphics.setColor(Color.green);
            graphics.drawPolygon(this.l);
        }
        if (displayObject.bm.ums[displayObject.bm.cumn].showBuildingDetails && (double)displayObject.bm.displayScale > 16.0) {
            graphics.setColor(Color.black);
            graphics.drawString("ID:" + this.id, this.xx(this.center.x), this.yy(this.center.y));
        }
        return true;
    }

    public void print() {
        System.out.println("** BUILDING INFOMATION **");
        System.out.println("ID=" + this.id);
        System.out.print("Center:");
        this.center.print();
        System.out.println("#floor" + this.floor);
        System.out.println("Attr:" + this.attribute);
        System.out.println("isBurning:" + this.isBurning);
        System.out.println("%Burned:" + this.percentageOfBurned);
        System.out.println("%Broken:" + this.percentageOfBroken);
        System.out.println("areaSize(1F):" + this.area1f);
        System.out.println("areaSize(ALL):" + this.areaAll);
        System.out.println("buildingType:" + this.type);
    }

    public String description() {
        String string = "(Unknown)";
        if (this.pb != null) {
            string = this.pb instanceof Pool.FireStation ? "(FireStation)" : (this.pb instanceof Pool.AmbulanceCenter ? "(AmbulanceCenter)" : (this.pb instanceof Pool.PoliceOffice ? "(PoliceOffice)" : (this.pb instanceof Pool.Refuge ? "(Refuge)" : "(Building)")));
        }
        return "BUILDING ID=" + this.pb.id + "(GID=" + this.id + ") " + string + ", " + this.floor + "Floor, Type=" + this.type + ", Center=(" + this.center.x + "," + this.center.y + ")";
    }

    public String description2() {
        if (this.pb != null) {
            return "Brokenness = " + this.pb.brokenness + ", Fieryness = " + this.pb.fieryness + ", Ignition = " + this.pb.ignition;
        }
        return " ";
    }

    public String descriptionAll() {
        return this.description() + ", " + this.description2();
    }

    public boolean justBurned() {
        return this.pb.justBurned;
    }

    public boolean justExtinguished() {
        return this.pb.justExtinguished;
    }

    public void clearStatus() {
        if (this.pb != null) {
            this.pb.clearStatus();
        }
    }

    public boolean inside(int n, int n2) {
        if (this.p == null) {
            return false;
        }
        return this.p.contains(n, n2);
    }

    public double damage(double d) {
        double d2 = 0.0;
        if (this.pb == null) {
            return 0.0;
        }
        d2 = this.pb.fieryness == 0 ? (this.pb.ignition != 0 ? 25.0 : 0.0) : fnTbl[this.pb.fieryness];
        return d * Math.max((double)this.pb.brokenness, d2) * (double)this.areaAll / 10000.0;
    }

    public double burnedArea() {
        if (this.pb == null) {
            return 0.0;
        }
        switch (this.pb.fieryness) {
            case 0: 
            case 1: 
            case 5: {
                return 0.0;
            }
        }
        return this.areaAll;
    }

    public boolean isOnScreen() {
        int n = 0;
        while (n < this.nNode) {
            if (super.isOnScreen(this.nodes[n].x, this.nodes[n].y)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

