/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class Pool {
    static final int TYPE_NULL = 0;
    static final int TYPE_FIRE_STATION = 185;
    static final int TYPE_AMBULANCE_TEAM = 234;
    static final int TYPE_RIVER_NODE = 201;
    static final int TYPE_FIRE_BRIGADE = 233;
    static final int TYPE_NODE = 200;
    static final int TYPE_POLICE_FORCE = 235;
    static final int TYPE_ROAD = 168;
    static final int TYPE_WORLD = 208;
    static final int TYPE_REFUGE = 184;
    static final int TYPE_BUILDING = 176;
    static final int TYPE_CIVILIAN = 232;
    static final int TYPE_AMBULANCE_CENTER = 186;
    static final int TYPE_POLICE_OFFICE = 187;
    static final int TYPE_RIVER = 169;
    static final int PROPERTY_TYPE = -2;
    static final int PROPERTY_ID = -1;
    static final int PROPERTY_NULL = 0;
    static final int PROPERTY_WATER_QUANTITY = 25;
    static final int PROPERTY_CARS_PASS_TO_TAIL = 35;
    static final int PROPERTY_CARS_PASS_TO_HEAD = 34;
    static final int PROPERTY_POSITION_HISTORY = 207;
    static final int PROPERTY_POCKET_TO_TURN_ACROSS = 129;
    static final int PROPERTY_BUILDING_ATTRIBUTES = 15;
    static final int PROPERTY_WIND_FORCE = 32;
    static final int PROPERTY_START_TIME = 29;
    static final int PROPERTY_FLOORS = 14;
    static final int PROPERTY_DAMAGE = 11;
    static final int PROPERTY_DIRECTION = 27;
    static final int PROPERTY_WIDTH = 38;
    static final int PROPERTY_BUILDING_APEXES = 131;
    static final int PROPERTY_BUILDING_AREA_TOTAL = 52;
    static final int PROPERTY_LONGITUDE = 30;
    static final int PROPERTY_BROKENNESS = 17;
    static final int PROPERTY_WIND_DIRECTION = 33;
    static final int PROPERTY_SHORTCUT_TO_TURN = 128;
    static final int PROPERTY_LINES_TO_TAIL = 42;
    static final int PROPERTY_LINES_TO_HEAD = 41;
    static final int PROPERTY_TAIL = 13;
    static final int PROPERTY_HEAD = 12;
    static final int PROPERTY_POSITION = 6;
    static final int PROPERTY_LATITUDE = 31;
    static final int PROPERTY_SIGNAL_TIMING = 130;
    static final int PROPERTY_HUMANS_PASS_TO_TAIL = 37;
    static final int PROPERTY_HUMANS_PASS_TO_HEAD = 36;
    static final int PROPERTY_LENGTH = 24;
    static final int PROPERTY_IGNITION = 48;
    static final int PROPERTY_BUILDING_AREA_GROUND = 51;
    static final int PROPERTY_ROAD_KIND = 19;
    static final int PROPERTY_BURIEDNESS = 23;
    static final int PROPERTY_STRETCHED_LENGTH = 26;
    static final int PROPERTY_FIERYNESS = 16;
    static final int PROPERTY_SIGNAL = 44;
    static final int PROPERTY_WIDTH_FOR_WALKERS = 43;
    static final int PROPERTY_ENTRANCES = 235;
    static final int PROPERTY_BUILDING_CODE = 50;
    static final int PROPERTY_EDGES = 242;
    static final int PROPERTY_MEDIAN_STRIP = 40;
    static final int PROPERTY_STAMINA = 9;
    static final int PROPERTY_Y = 4;
    static final int PROPERTY_X = 3;
    static final int PROPERTY_POSITION_EXTRA = 7;
    static final int PROPERTY_REPAIR_COST = 39;
    static final int PROPERTY_HP = 10;
    static final int PROPERTY_BLOCK = 22;
    public final Dictionary map = new Hashtable();
    public final Vector motionlesses = new Vector();
    public final Vector movings = new Vector();
    public int livings = 0;
    public int deads = 0;
    public int[] buildingBurned = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public int[] buildingBroken = new int[]{0, 0, 0, 0, 0};
    public int[] roadBlock = new int[]{0, 0, 0, 0, 0};
    public int allHp = 0;
    public int hp0 = 0;

    public static void error() {
        System.out.println("error!!");
        System.exit(1);
    }

    public _Object newObject(int n) {
        _Object _Object2;
        switch (n) {
            default: {
                Pool.error();
                return null;
            }
            case 208: {
                _Object2 = new World();
                break;
            }
            case 176: {
                _Object2 = new Building();
                break;
            }
            case 232: {
                _Object2 = new Civilian();
                break;
            }
            case 233: {
                _Object2 = new FireCompany();
                break;
            }
            case 185: {
                _Object2 = new FireStation();
                break;
            }
            case 234: {
                _Object2 = new AmbulanceTeam();
                break;
            }
            case 186: {
                _Object2 = new AmbulanceCenter();
                break;
            }
            case 235: {
                _Object2 = new PoliceForce();
                break;
            }
            case 187: {
                _Object2 = new PoliceOffice();
                break;
            }
            case 184: {
                _Object2 = new Refuge();
                break;
            }
            case 168: {
                _Object2 = new Road();
                break;
            }
            case 200: {
                _Object2 = new Node();
                break;
            }
            case 169: {
                _Object2 = new River();
                break;
            }
            case 201: {
                _Object2 = new RiverNode();
            }
        }
        return _Object2;
    }

    public void restructure(DataInputStream dataInputStream) throws IOException {
        boolean bl = false;
        int n = dataInputStream.readInt();
        while (n != 0) {
            int n2;
            int n3;
            _Object _Object2;
            Integer n4 = new Integer(dataInputStream.readInt());
            _Object _Object3 = (_Object)this.map.get(n4);
            if (_Object3 == null) {
                _Object3 = this.newObject(n);
                _Object3.id = n4;
                this.map.put(n4, _Object3);
                if (_Object3 instanceof MotionlessObject) {
                    this.motionlesses.addElement(_Object3);
                }
                if (_Object3 instanceof MovingObject) {
                    this.movings.addElement(_Object3);
                }
                _Object3.inputAllProperty(this.map, dataInputStream);
                if (_Object3 instanceof Humanoid) {
                    this.allHp += ((Humanoid)_Object3).hp;
                    this.hp0 += ((Humanoid)_Object3).hp;
                    if (((Humanoid)_Object3).hp > 0) {
                        if (((Humanoid)_Object3).buriedness > 0) {
                            // empty if block
                        }
                        ++this.livings;
                    } else {
                        ++this.deads;
                    }
                } else if (_Object3 instanceof Building) {
                    _Object2 = (Building)_Object3;
                    int n5 = ((Building)_Object2).fieryness;
                    this.buildingBurned[n5] = this.buildingBurned[n5] + 1;
                    int n6 = ((Building)_Object2).brokenness / 25;
                    this.buildingBroken[n6] = this.buildingBroken[n6] + 1;
                } else if (_Object3 instanceof Road) {
                    int n7 = (int)((double)((Road)_Object3).block * 4.0 / (double)((Road)_Object3).width);
                    this.roadBlock[n7] = this.roadBlock[n7] + 1;
                }
            } else if (_Object3 instanceof Humanoid) {
                _Object2 = (Humanoid)_Object3;
                n3 = _Object2.hp;
                n2 = _Object2.buriedness;
                this.allHp -= n3;
                _Object3.inputAllProperty(this.map, dataInputStream);
                this.allHp += _Object2.hp;
                if (n2 != _Object2.buriedness) {
                    if (n2 > _Object2.buriedness) {
                        _Object2.digged = true;
                    }
                    if (_Object2.buriedness <= 0) {
                        if (_Object2.hp <= 0) {
                            System.err.println("Agent #" + _Object2.id + " was found as a dead body");
                        } else {
                            System.err.println("Agent #" + _Object2.id + " was saved (hp = " + _Object2.hp + ")");
                            _Object2.justSaved = true;
                        }
                    }
                }
                if (n3 > 0 != _Object2.hp > 0) {
                    if (n3 > 0) {
                        System.err.println("Agent #" + _Object2.id + " Dead, " + (this.livings - 1) + " People left");
                        _Object2.justDead = true;
                        --this.livings;
                        ++this.deads;
                    } else {
                        ++this.livings;
                        --this.deads;
                    }
                }
            } else if (_Object3 instanceof Building) {
                _Object2 = (Building)_Object3;
                n3 = ((Building)_Object2).fieryness;
                n2 = ((Building)_Object2).brokenness;
                _Object3.inputAllProperty(this.map, dataInputStream);
                if (n3 != ((Building)_Object2).fieryness) {
                    int n8 = n3;
                    this.buildingBurned[n8] = this.buildingBurned[n8] - 1;
                    int n9 = ((Building)_Object2).fieryness;
                    this.buildingBurned[n9] = this.buildingBurned[n9] + 1;
                    if (((Building)_Object2).fieryness >= 1 && ((Building)_Object2).fieryness <= 4) {
                        ((Building)_Object2).justBurned = true;
                    } else if (((Building)_Object2).fieryness == 5 || ((Building)_Object2).fieryness == 6) {
                        System.err.println("Building #" + _Object3.id + " was just Extinguished (" + ((Building)_Object2).fieryness + ")");
                        ((Building)_Object2).justExtinguished = true;
                    }
                }
                if (n2 != ((Building)_Object2).brokenness) {
                    int n10 = n2 / 25;
                    this.buildingBroken[n10] = this.buildingBroken[n10] - 1;
                    int n11 = ((Building)_Object2).brokenness / 25;
                    this.buildingBroken[n11] = this.buildingBroken[n11] + 1;
                }
            } else if (_Object3 instanceof Road) {
                _Object2 = (Road)_Object3;
                n3 = ((Edge)_Object2).block;
                _Object3.inputAllProperty(this.map, dataInputStream);
                if (n3 != ((Edge)_Object2).block) {
                    ((Edge)_Object2).blockChanged = true;
                    int n12 = (int)((double)n3 * 4.0 / (double)((Road)_Object3).width);
                    this.roadBlock[n12] = this.roadBlock[n12] - 1;
                    int n13 = (int)((double)((Road)_Object3).block * 4.0 / (double)((Road)_Object3).width);
                    this.roadBlock[n13] = this.roadBlock[n13] + 1;
                }
            } else {
                _Object3.inputAllProperty(this.map, dataInputStream);
            }
            n = dataInputStream.readInt();
        }
    }

    public static class RiverNode
    extends Vertex {
    }

    public static class Node
    extends Vertex {
    }

    public static class Vertex
    extends PointObject {
    }

    public static class River
    extends Edge {
    }

    public static class Road
    extends Edge {
    }

    public static class Edge
    extends MotionlessObject {
        public Integer head = new Integer(0);
        public Integer tail = new Integer(0);
        public int length;
        public int width = 10;
        public int block = 0;
        public boolean blockChanged = false;

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            switch (n) {
                default: {
                    super.input(dictionary, dataInputStream, n);
                    break;
                }
                case 12: {
                    this.head = new Integer(dataInputStream.readInt());
                    break;
                }
                case 13: {
                    this.tail = new Integer(dataInputStream.readInt());
                    break;
                }
                case 24: {
                    this.length = dataInputStream.readInt();
                    break;
                }
                case 38: {
                    this.width = dataInputStream.readInt();
                    break;
                }
                case 22: {
                    this.block = dataInputStream.readInt();
                }
            }
        }
    }

    public static class Refuge
    extends Building {
    }

    public static class PoliceOffice
    extends Building {
    }

    public static class PoliceForce
    extends Humanoid {
    }

    public static class AmbulanceCenter
    extends Building {
    }

    public static class AmbulanceTeam
    extends Humanoid {
    }

    public static class FireStation
    extends Building {
    }

    public static class FireCompany
    extends Humanoid {
    }

    public static class Civilian
    extends Humanoid {
    }

    public static class Building
    extends PointObject {
        public int fieryness;
        public int brokenness;
        public int ignition;
        public boolean justBurned = false;
        public boolean justExtinguished = false;
        Integer entrance = new Integer(0);

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            switch (n) {
                default: {
                    super.input(dictionary, dataInputStream, n);
                    break;
                }
                case 16: {
                    this.fieryness = dataInputStream.readInt();
                    break;
                }
                case 17: {
                    this.brokenness = dataInputStream.readInt();
                    break;
                }
                case 48: {
                    this.ignition = dataInputStream.readInt();
                    break;
                }
                case 235: {
                    int n2;
                    while ((n2 = dataInputStream.readInt()) != 0) {
                        this.entrance = new Integer(n2);
                    }
                    break block0;
                }
            }
        }

        public void clearStatus() {
            this.justBurned = false;
            this.justExtinguished = false;
        }
    }

    public static class Humanoid
    extends MovingObject {
        public static final int hpMax = 10000;
        public int stamina = 10000;
        public int hp = 10000;
        public int damage = 0;
        public int buriedness = 0;
        public boolean digged = false;
        public boolean justSaved = false;
        public boolean justDead = false;

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            switch (n) {
                default: {
                    super.input(dictionary, dataInputStream, n);
                    break;
                }
                case 9: {
                    this.stamina = dataInputStream.readInt();
                    break;
                }
                case 10: {
                    this.hp = dataInputStream.readInt();
                    break;
                }
                case 11: {
                    this.damage = dataInputStream.readInt();
                    break;
                }
                case 23: {
                    this.buriedness = dataInputStream.readInt();
                }
            }
        }

        public void claerStatus() {
            this.digged = false;
            this.justSaved = false;
            this.justDead = false;
        }
    }

    public static class MovingObject
    extends _Object {
        public Integer position = new Integer(0);
        public int positionExtra;

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            switch (n) {
                default: {
                    super.input(dictionary, dataInputStream, n);
                    break;
                }
                case 6: {
                    this.position = new Integer(dataInputStream.readInt());
                    break;
                }
                case 7: {
                    this.positionExtra = dataInputStream.readInt();
                }
            }
        }
    }

    public static class PointObject
    extends MotionlessObject {
        public int x;
        public int y;

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            switch (n) {
                default: {
                    super.input(dictionary, dataInputStream, n);
                    break;
                }
                case 3: {
                    this.x = dataInputStream.readInt();
                    break;
                }
                case 4: {
                    this.y = dataInputStream.readInt();
                }
            }
        }
    }

    public static class MotionlessObject
    extends _Object {
    }

    public static class World
    extends _Object {
    }

    public static class _Object {
        public int id;

        public void inputAllProperty(Dictionary dictionary, DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            while (n != 0) {
                this.input(dictionary, dataInputStream, n);
                n = dataInputStream.readInt();
            }
        }

        protected void input(Dictionary dictionary, DataInputStream dataInputStream, int n) throws IOException {
            if (n < 128) {
                dataInputStream.readInt();
            } else if (n < 192) {
                int n2 = dataInputStream.readInt();
                while (n2 > 0) {
                    dataInputStream.readInt();
                    n2 -= 4;
                }
            } else {
                int n3;
                while ((n3 = dataInputStream.readInt()) != 0) {
                }
            }
        }
    }
}

