/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

public class LongUDPSocket {
    final int m_frameSize = 14336;
    final int m_wait = 20;
    final int m_headerSize = 8;
    static int id = 1;
    protected DatagramSocket _socket;
    protected Vector _packets = new Vector();
    protected InetAddress _address;
    protected int _port;

    public LongUDPSocket() throws SocketException {
        this._socket = new DatagramSocket();
    }

    public LongUDPSocket(int n) throws SocketException {
        this._socket = new DatagramSocket(n);
    }

    public void send(byte[] byArray, InetAddress inetAddress, int n) throws IOException {
        int n2 = byArray.length;
        int n3 = (n2 + 14336 - 1) / 14336;
        if (n3 == 0) {
            n3 = 1;
        }
        byte[] byArray2 = new byte[14344];
        int n4 = 0;
        while (n4 < n3) {
            byArray2[0] = 0;
            byArray2[1] = 8;
            byArray2[2] = (byte)(id >> 8 & 0xFF);
            byArray2[3] = (byte)(id & 0xFF);
            byArray2[4] = (byte)(n4 >> 8 & 0xFF);
            byArray2[5] = (byte)(n4 & 0xFF);
            byArray2[6] = (byte)(n3 >> 8 & 0xFF);
            byArray2[7] = (byte)(n3 & 0xFF);
            int n5 = 14336;
            if (n4 == n3 - 1) {
                n5 = n2 % 14336;
                if (n2 != 0 && n5 == 0) {
                    n5 = 14336;
                }
            }
            System.arraycopy(byArray, n4 * 14336, byArray2, 8, n5);
            this._socket.send(new DatagramPacket(byArray2, n5 + 8, inetAddress, n));
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n4;
        }
        ++id;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public InputStream receive() throws IOException {
        while (true) {
            byte[] byArray = new byte[16384];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this._socket.receive(datagramPacket);
            int n = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            int n2 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
            int n3 = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
            if (n3 == 1) {
                this._address = datagramPacket.getAddress();
                this._port = datagramPacket.getPort();
                return new ByteArrayInputStream(byArray, 8, datagramPacket.getLength() - 8);
            }
            Enumeration enumeration = this._packets.elements();
            Packet packet = null;
            int n4 = 0;
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                packet = (Packet)enumeration.nextElement();
                if (packet.id == n && packet.port == datagramPacket.getPort() && packet.address.equals(datagramPacket.getAddress())) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                packet = new Packet();
                packet.address = datagramPacket.getAddress();
                packet.port = datagramPacket.getPort();
                packet.id = n;
                packet.data = new Vector(n3);
                int n5 = 0;
                while (n5 < n3) {
                    packet.data.addElement(null);
                    ++n5;
                }
                Frame frame = new Frame();
                frame.size = datagramPacket.getLength();
                frame.data = byArray;
                packet.data.setElementAt(frame, n2);
                this._packets.insertElementAt(packet, 0);
                if (this._packets.size() <= 16) continue;
                this._packets.removeElementAt(this._packets.size() - 1);
                continue;
            }
            Frame frame = new Frame();
            frame.size = datagramPacket.getLength();
            frame.data = byArray;
            packet.data.setElementAt(frame, n2);
            int n6 = 0;
            while (n6 < packet.data.size()) {
                if (packet.data.elementAt(n6) == null) break;
                ++n6;
            }
            this._packets.removeElementAt(n4);
            if (n6 >= packet.data.size()) {
                Vector<ByteArrayInputStream> vector = new Vector<ByteArrayInputStream>(n2);
                Enumeration enumeration2 = packet.data.elements();
                while (enumeration2.hasMoreElements()) {
                    Frame frame2 = (Frame)enumeration2.nextElement();
                    vector.addElement(new ByteArrayInputStream(frame2.data, 8, frame2.size - 8));
                }
                this._address = packet.address;
                this._port = packet.port;
                return new SequenceInputStream(vector.elements());
            }
            this._packets.insertElementAt(packet, 0);
        }
    }

    protected static class Packet {
        public InetAddress address;
        public int port;
        public int id;
        public Vector data;

        protected Packet() {
        }
    }

    protected static class Frame {
        public int size;
        public byte[] data;

        protected Frame() {
        }
    }
}

