
--
-- Copyright (C) 2023  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;

with pictobj;
with pictobj2;


with gl, gl.binding, gl.pointers;  use gl;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------

with glfw3; use glfw3;
with zoomwheel;

---------------------------

with text_io; use text_io;

----------------------------------------------------------------





package gametypes is


	wall_texid, egg_texid, pgmtexshadid, pgmtexid : gluint := 0;

	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;

	matrixid, uniftex, matid,unitex : glint;


	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	fourthpi : constant float  := onepi/4.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright, good : integer;



	oldTimeKb : float := 0.0;
	deltaT : float;






-- begin string pointers for getUniformLocation:

	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);

-- end string pointers for getUniformLocation:



	-- mm = modelmatrix,
	-- vm = viewmatrix,
	-- pm = perspectivematrix,

	mv,mvp, pm, vm, mm :  mat44 := identity;


	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);


	rotx,roty,rotz : float := 0.0;


----------------------- begin stuff from main ---------------------------

	mainWin :  access glfWwindow;



	Nwid,Nhit, Wwid,Whit, Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;



	package myint_io is new text_io.integer_io(integer);

	major, minor, profile, flags, mtu :  glint;


	ppo: pictobj.pictangle;
	ppo2: pictobj2.pictangle;

	brick, whoosh, fanfare, shriek, clap: glint;

	okmultisamp: boolean := false;

---------------------------------------------------------------

	mute,
	goup,godown,goleft,goright,
	goaway,gonear, tryNextSkin,
	doRestart,
	winner, hint,
	help, show_axes,
	playedonce, userexit: boolean := false;

	--zeye_default : constant float := 12.0;
	--zeye : float := zeye_default;

	type vf3 is array(1..3) of float;
	type vi3 is array(1..3) of integer;
	type gfparray is array( integer range <> ) of vf3;
	type giparray is array( integer range <> ) of vi3;

	--subtype rngp2 is integer range 1..5;  s->5,
	--subtype rngp4 is integer range 0..10; s->10
	--subtype rngp5 is integer range 1..9;  s->9,
	--subtype rngp6 is integer range 1..9;  s->9, m->9,

	zsave: gldouble; -- used during help screen

end gametypes;

