
# Auxillary build script for OSX using AdaCore.

# In nov2021 my Xcode was upgraded to 10.1, which
# caused my TBD files to become "out-of-sync"
# with SDK libraries (subsequently fixed).

# This script gives specific paths
# to libraries & frameworks, if needed.


#!/bin/sh
#
# Mac OS-X compile script 
#
# note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#==================================================





if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# using Xcode compiler...
# first, create oal.o:
g++ ../src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-I../src/adabindings/adaOpenAL/OalBinding \
-I../src/adabindings/adaOpenAL/OalBinding/incoal



export PATH=$HOME/opt/GNAT/2020/bin:$PATH


export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks



gnatmake  $1 -O3  \
-o $2 \
-D $PWD/obj \
-I$PWD/../src \
-I$PWD/../src/adautils \
-I$PWD/../src/adabindings/gl \
-I$PWD/../src/adabindings/glfwada \
-I$PWD/../src/adabindings/AdaPngLib \
-I$PWD/../src/adabindings/adaOpenAL \
-I$PWD/../src/adabindings/adaOpenAL/OalBinding \
-I$PWD/../src/adabindings/FreeTypeAda \
-largs \
oal.o \
-L$SDKROOT/usr/lib \
-lm -lz -lc++ \
$PWD/../libs/osx/libglfw3.a \
$PWD/../libs/osx/libfreetype.a \
$PWD/../libs/osx/libpng16.a \
$PWD/../libs/osx/libbz2.a \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework Metal \
\
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread

mv $2 $PWD/../reliquarium.app/Contents/MacOS/



# -- Copyright (C) 2023  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

