
# Build script for OSX using gcc v11.2.0 gnat
# Example script that avoids Xcode g++:
#
# 100% GNU (no Xcode compilers):
#

# In nov2021 my Xcode was upgraded to 10.1 but
# my MacBookPro TBD files became "out-of-sync"
# with SDK libraries. Here, I now give specific path
# to libraries & frameworks.


#!/bin/sh

# this ensures a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi

export GROOT=/opt/gcc-11.2.0/bin
export PATH=$GROOT:$PATH



# first, create oal.o:
$GROOT/g++ \
adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal


#---------------------------------------------------

export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks


# note that this setup requires
# -lstdc++ rather than -lc++


$GROOT/gnatmake  $1 -O3  \
-o $2 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-I$PWD/adabindings/FreeTypeAda \
-largs \
oal.o \
$PWD/libs/osx/libglfw3.a \
$PWD/libs/osx/libfreetype.a \
$PWD/libs/osx/libpng16.a \
$PWD/libs/osx/libbz2.a \
\
-L$SDKROOT/usr/lib \
-lm -lz  -lstdc++ \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework Metal \
\
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread 


mv $2 $PWD/reliquarium.app/Contents/MacOS/

# -- Copyright (C) 2023  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

