
# Linux
# gnu Ada [GNAT] compile script for Reliquarium
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libglfw.so

# Note that libfreetype.so.6.12.1 needs
# special preparation using "patchelf"
# in order to allow it to find dependencies
# under GnuCompilerCollection-GNAT.
# Not so using AdaCore Ada.

#########################################################





# first, create oal.o:
g++ ../src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-I../src/adabindings/adaOpenAL/OalBinding \
-I../src/adabindings/adaOpenAL/OalBinding/incoal





gnatmake $1 -o $1 \
-O3 -gnat12 \
-D obj \
-I../src \
-I../src/adautils \
-I../src/adabindings/gl \
-I../src/adabindings/glfwada \
-I../src/adabindings/AdaPngLib \
-I../src/adabindings/FreeTypeAda \
-I../src/adabindings/adaOpenAL \
-I../src/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
-lGL -lX11 -lpthread -lstdc++ -lz -lm -ldl \
-lopenal \
-Wl,-rpath,'$ORIGIN/libs/gnu' \
-Wl,-rpath,'$ORIGIN/../../libs/gnu' \
-L$PWD/../libs/gnu \
-lfreetype -lpng15 -lglfw

mv $1 ../bin/gnat/


#-lgnarl_pic -lgnat_pic \

# note that the rpath line above allows EXEs
# in relic/bin/gnat/ to find the runtime libraries
# in relic/libs/gnu/


# -- Copyright (C) 2023  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

