#!/bin/sh
#
# Mac OS-X compile script
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the GNU Ada compiler, gnatmake, is installed
# along with Xcode and its g++ compiler.
#
# uses GLFW,SFML static libraries since they are unusual
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
##################################################




if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# priority path for AdaCore:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH

# using AdaCore g++ compiler...
# first, create oal.o:
g++ ../src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-I../src/adabindings/adaOpenAL/OalBinding \
-I../src/adabindings/adaOpenAL/OalBinding/incoal




gnatmake  $1 -O3  \
-o $2 \
-D $PWD/obj \
-I$PWD/../src \
-I$PWD/../src/adautils \
-I$PWD/../src/adabindings/gl \
-I$PWD/../src/adabindings/glfwada \
-I$PWD/../src/adabindings/AdaPngLib \
-I$PWD/../src/adabindings/adaOpenAL \
-I$PWD/../src/adabindings/adaOpenAL/OalBinding \
-I$PWD/../src/adabindings/FreeTypeAda \
-largs \
oal.o \
-lm -lz -lstdc++ \
$PWD/../libs/osx/libglfw3.a \
$PWD/../libs/osx/libfreetype.a \
$PWD/../libs/osx/libpng16.a \
$PWD/../libs/osx/libbz2.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework Metal \
\
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread

mv $2 $PWD/../reliquarium.app/Contents/MacOS/



# -- Copyright (C) 2022  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

