package net.morilib.db.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class RelationsResultSet extends UnupdatableResultSet {

	Relation rel;
	RelationsStatement stmt;
	private Object last;
	private RelationCursor cursor;
	private RelationTuple tuple = null;
	private int rownum = 0;

	RelationsResultSet(RelationsStatement s, Relation execute) {
		stmt = s;
		rel = execute;
		cursor = null;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return false;
	}

	@Override
	public boolean next() throws SQLException {
		if(rel == null) {
			throw ErrorBundle.getDefault(20002);
		} else if(cursor == null) {
			return first();
		} else if(cursor.hasNext()) {
			try {
				rownum++;
				tuple = cursor.next();
				return true;
			} catch (IOException e) {
				throw ErrorBundle.getDefault(20003);
			}
		} else {
			tuple = null;
		}
		return false;
	}

	@Override
	public void close() throws SQLException {
		if(rel == null) {
			throw ErrorBundle.getDefault(20002);
		} else {
			rel = null;
			cursor = null;
		}
	}

	@Override
	public boolean wasNull() throws SQLException {
		return last.equals("");
	}

	@Override
	public String getString(int columnIndex) throws SQLException {
		return getObject(columnIndex).toString();
	}

	@Override
	public boolean getBoolean(int columnIndex) throws SQLException {
		return !getObject(columnIndex).equals(Rational.ZERO);
	}

	@Override
	public byte getByte(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return (byte)((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public short getShort(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return (short)((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public int getInt(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return (byte)((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public long getLong(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return (byte)((Rational)o).castLong();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public float getFloat(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return (float)((Rational)o).doubleValue();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public double getDouble(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return ((Rational)o).doubleValue();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public BigDecimal getBigDecimal(int columnIndex,
			int scale) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof Rational) {
			return ((Rational)o).toBigDecimal(scale);
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public byte[] getBytes(int columnIndex) throws SQLException {
		return getObject(columnIndex).toString().getBytes();
	}

	@Override
	public Date getDate(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof java.util.Date) {
			return new Date(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public Time getTime(int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof java.util.Date) {
			return new Time(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public Timestamp getTimestamp(
			int columnIndex) throws SQLException {
		Object o = getObject(columnIndex);

		if(o instanceof java.util.Date) {
			return new Timestamp(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public InputStream getAsciiStream(
			int columnIndex) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnIndex).toString().getBytes());
	}

	@Override
	public InputStream getUnicodeStream(
			int columnIndex) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnIndex).toString().getBytes());
	}

	@Override
	public InputStream getBinaryStream(
			int columnIndex) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnIndex).toString().getBytes());
	}

	@Override
	public String getString(String columnLabel) throws SQLException {
		return getObject(columnLabel).toString();
	}

	@Override
	public boolean getBoolean(String columnLabel) throws SQLException {
		return !getObject(columnLabel).equals(Rational.ZERO);
	}

	@Override
	public byte getByte(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return (byte)((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public short getShort(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return (short)((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public int getInt(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return ((Rational)o).castInt();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public long getLong(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return ((Rational)o).castLong();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public float getFloat(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return (float)((Rational)o).doubleValue();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public double getDouble(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return ((Rational)o).doubleValue();
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public BigDecimal getBigDecimal(String columnLabel,
			int scale) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof Rational) {
			return ((Rational)o).toBigDecimal(scale);
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public byte[] getBytes(String columnLabel) throws SQLException {
		return getObject(columnLabel).toString().getBytes();
	}

	@Override
	public Date getDate(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof java.util.Date) {
			return new Date(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public Time getTime(String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof java.util.Date) {
			return new Time(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public Timestamp getTimestamp(
			String columnLabel) throws SQLException {
		Object o = getObject(columnLabel);

		if(o instanceof java.util.Date) {
			return new Timestamp(((java.util.Date)o).getTime());
		} else {
			throw ErrorBundle.getDefault(20004);
		}
	}

	@Override
	public InputStream getAsciiStream(
			String columnLabel) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnLabel).toString().getBytes());
	}

	@Override
	public InputStream getUnicodeStream(
			String columnLabel) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnLabel).toString().getBytes());
	}

	@Override
	public InputStream getBinaryStream(
			String columnLabel) throws SQLException {
		return new ByteArrayInputStream(
				getObject(columnLabel).toString().getBytes());
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		return null;
	}

	@Override
	public void clearWarnings() throws SQLException {
		// ignore it
	}

	@Override
	public String getCursorName() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		return new RelationsResultSetMetaData(this);
	}

	@Override
	public Object getObject(int columnIndex) throws SQLException {
		List<SqlColumnDefinition> l;

		if(rel == null) {
			throw ErrorBundle.getDefault(20002);
		} else if(cursor == null || tuple == null) {
			throw ErrorBundle.getDefault(20003);
		} else {
			l = rel.getColumnNames();
			if(columnIndex < 1 || columnIndex > l.size()) {
				throw ErrorBundle.getDefault(10045, columnIndex);
			}
			return getObject(l.get(columnIndex - 1).getName());
		}
	}

	@Override
	public Object getObject(String columnLabel) throws SQLException {
		if(rel == null) {
			throw ErrorBundle.getDefault(20002);
		} else if(cursor == null || tuple == null) {
			throw ErrorBundle.getDefault(20003);
		} else {
			return tuple.get(columnLabel);
		}
	}

	@Override
	public int findColumn(String columnLabel) throws SQLException {
		List<String> l;
		int j;

		l = new ArrayList<String>(tuple.toMap().keySet());
		if((j = l.indexOf(columnLabel)) < 0) {
			throw ErrorBundle.getDefault(10009, columnLabel);
		}
		return j;
	}

	@Override
	public Reader getCharacterStream(
			int columnIndex) throws SQLException {
		return new StringReader(getObject(columnIndex).toString());
	}

	@Override
	public Reader getCharacterStream(
			String columnLabel) throws SQLException {
		return new StringReader(getObject(columnLabel).toString());
	}

	@Override
	public BigDecimal getBigDecimal(
			int columnIndex) throws SQLException {
		return getBigDecimal(columnIndex, 20);
	}

	@Override
	public BigDecimal getBigDecimal(
			String columnLabel) throws SQLException {
		return getBigDecimal(columnLabel, 20);
	}

	@Override
	public boolean isBeforeFirst() throws SQLException {
		return tuple == null && cursor == null;
	}

	@Override
	public boolean isAfterLast() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean isFirst() throws SQLException {
		return rownum == 1;
	}

	@Override
	public boolean isLast() throws SQLException {
		return !cursor.hasNext();
	}

	@Override
	public void beforeFirst() throws SQLException {
		tuple = null;
		cursor = null;
	}

	@Override
	public void afterLast() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean first() throws SQLException {
		try {
			cursor = rel.iterator();
			if(cursor.hasNext()) {
				rownum = 1;
				tuple = cursor.next();
				return tuple != null;
			} else {
				rownum = 0;
				tuple = null;
				return false;
			}
		} catch(IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public boolean last() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public int getRow() throws SQLException {
		return rownum;
	}

	@Override
	public boolean absolute(int row) throws SQLException {
		if(row > 0) {
			first();
			return relative(row);
		} else {
			throw new SQLFeatureNotSupportedException();
		}
	}

	@Override
	public boolean relative(int rows) throws SQLException {
		if(rows > 0) {
			for(int i = 0; i < rows; i++) {
				if(!cursor.hasNext())  return false;
				try {
					cursor.next();
				} catch(IOException e) {
					throw ErrorBundle.getDefault(10037);
				}
			}
			return true;
		} else {
			throw new SQLFeatureNotSupportedException();
		}
	}

	@Override
	public boolean previous() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		// ignore it
	}

	@Override
	public int getFetchDirection() throws SQLException {
		return ResultSet.FETCH_FORWARD;
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		// ignore it
	}

	@Override
	public int getFetchSize() throws SQLException {
		return 0;
	}

	@Override
	public int getType() throws SQLException {
		return ResultSet.TYPE_FORWARD_ONLY;
	}

	@Override
	public int getConcurrency() throws SQLException {
		return ResultSet.CONCUR_READ_ONLY;
	}

	@Override
	public boolean rowUpdated() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean rowInserted() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean rowDeleted() throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Statement getStatement() throws SQLException {
		return stmt;
	}

	@Override
	public Object getObject(int columnIndex,
			Map<String, Class<?>> map) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Ref getRef(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Blob getBlob(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Clob getClob(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Array getArray(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Object getObject(String columnLabel,
			Map<String, Class<?>> map) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Ref getRef(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Blob getBlob(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Clob getClob(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Array getArray(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public Date getDate(int columnIndex,
			Calendar cal) throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getDate(columnIndex));
		return new Date(c.getTimeInMillis());
	}

	@Override
	public Date getDate(String columnLabel,
			Calendar cal) throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getDate(columnLabel));
		return new Date(c.getTimeInMillis());
	}

	@Override
	public Time getTime(int columnIndex,
			Calendar cal) throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getTime(columnIndex));
		return new Time(c.getTimeInMillis());
	}

	@Override
	public Time getTime(String columnLabel,
			Calendar cal) throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getTime(columnLabel));
		return new Time(c.getTimeInMillis());
	}

	@Override
	public Timestamp getTimestamp(int columnIndex, Calendar cal)
			throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getTime(columnIndex));
		return new Timestamp(c.getTimeInMillis());
	}

	@Override
	public Timestamp getTimestamp(String columnLabel, Calendar cal)
			throws SQLException {
		Calendar c;

		(c = (Calendar)cal.clone()).setTime(getTime(columnLabel));
		return new Timestamp(c.getTimeInMillis());
	}

	@Override
	public URL getURL(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public URL getURL(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public RowId getRowId(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public RowId getRowId(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public int getHoldability() throws SQLException {
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	@Override
	public boolean isClosed() throws SQLException {
		return rel == null;
	}

	@Override
	public NClob getNClob(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public NClob getNClob(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public SQLXML getSQLXML(int columnIndex) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public SQLXML getSQLXML(String columnLabel) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public String getNString(int columnIndex) throws SQLException {
		return getString(columnIndex);
	}

	@Override
	public String getNString(String columnLabel) throws SQLException {
		return getString(columnLabel);
	}

	@Override
	public Reader getNCharacterStream(
			int columnIndex) throws SQLException {
		return getCharacterStream(columnIndex);
	}

	@Override
	public Reader getNCharacterStream(
			String columnLabel) throws SQLException {
		return getCharacterStream(columnLabel);
	}

}
