/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.grinEdit.UtilXMLRPC;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class SpringEdge
extends PhysicalLaw {
    private Vector target;
    public double defaultNormalLength = 1.0;
    public double defaultSpringStrength = 0.1;

    public SpringEdge(Vector target) {
        this.target = target;
    }

    public boolean apply() {
        Vector edgeList = this.target;
        int i = 0;
        while (i < edgeList.size()) {
            double length;
            RenderableEdge e = (RenderableEdge)edgeList.get(i);
            double[] dir = Vec.sub(e.v2.position, e.v1.position);
            double dist = Vec.mag(dir);
            double[] ndir = Vec.normalize(dir);
            double k = e.k;
            if (k < 0.0) {
                k = this.defaultSpringStrength;
            }
            if ((length = e.length) < 0.0) {
                length = this.defaultNormalLength;
            }
            double power = (length - dist) * k;
            double[] force = Vec.scale(ndir, power);
            e.v2.velocityList.add(force);
            e.v1.velocityList.add(Vec.inv(force));
            ++i;
        }
        return true;
    }

    public int tolerance() {
        return -1;
    }

    public void rpc_defaultNormalLength(Object o) {
        this.defaultNormalLength = UtilXMLRPC.ToDouble(o);
    }

    public void rpc_defaultSpringStrength(Object o) {
        this.defaultSpringStrength = UtilXMLRPC.ToDouble(o);
    }

    public Hashtable rpc_getParams() {
        Hashtable<String, Double> result = new Hashtable<String, Double>();
        result.put("defaultNormalLength", this.defaultNormalLength);
        result.put("defaultSpringStrength", this.defaultSpringStrength);
        return result;
    }
}

