/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Vector;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.layout.MassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class Aggregator {
    public Vector law = new Vector();

    public void addLaw(PhysicalLaw l) {
        this.law.add(l);
    }

    public void aggregate() {
        this.initialize();
        boolean isAllSatisfied = true;
        int i = 0;
        while (i < this.law.size()) {
            PhysicalLaw p = (PhysicalLaw)this.law.get(i);
            boolean isSatisfied = p.apply();
            if (!isSatisfied) {
                isAllSatisfied = false;
            }
            ++i;
        }
        this.updatePos();
        int MAX_ITER = 10;
        int iter = 0;
        while (iter < MAX_ITER) {
            this.initialize();
            isAllSatisfied = true;
            int i2 = 0;
            while (i2 < this.law.size()) {
                boolean isSatisfied;
                PhysicalLaw p = (PhysicalLaw)this.law.get(i2);
                if (p.tolerance() > i2 && !(isSatisfied = p.apply())) {
                    isAllSatisfied = false;
                }
                ++i2;
            }
            this.updatePos();
            if (isAllSatisfied) break;
            ++iter;
        }
    }

    private void initialize() {
        Mediator med = Mediator.getInstance();
        Vector vs = med.graph.vertexList;
        int i = 0;
        while (i < vs.size()) {
            MassPoint v = (MassPoint)vs.get(i);
            v.velocityList = new Vector();
            ++i;
        }
    }

    private void updatePos() {
        Mediator med = Mediator.getInstance();
        Vector vs = med.graph.vertexList;
        int i = 0;
        while (i < vs.size()) {
            MassPoint v = (MassPoint)vs.get(i);
            double[] vel = new double[2];
            int j = 0;
            while (j < v.velocityList.size()) {
                double[] f = (double[])v.velocityList.get(j);
                Vec.addD(vel, f);
                ++j;
            }
            v.position = Vec.add(v.position, vel);
            ++i;
        }
    }

    public Object getLaw(int index) {
        return this.law.get(index);
    }
}

