/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Iterator;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.nishiohirokazu.graph.RenderableGraph;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Selection;
import org.nishiohirokazu.grinEdit.XMLRPCHandler;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseMediator;
import org.nishiohirokazu.layout.SpringEdge;
import org.nishiohirokazu.swt.MenuWrapper;

public class Mediator {
    private static Mediator instance;
    public Selection selection = new Selection(this);
    public boolean pause;
    public RenderableGraph graph = new RenderableGraph();
    public MouseMediator mouseMed;
    private MenuWrapper menuWrapper;
    private XMLRPCHandler xmlrpc_handler;

    public static Mediator getInstance() {
        if (instance == null) {
            instance = new Mediator();
        }
        return instance;
    }

    public Vector getSelectedEdges() {
        return this.selection.getEdges();
    }

    public Vector getSelectedVertex() {
        return this.selection.getVertex();
    }

    public Vector getMarginalEdges() {
        return this.selection.getMarginalEdges();
    }

    public void setSelection(Vector vertexes) {
        this.selection.set(vertexes);
    }

    public MouseMediator getMouseMediator() {
        if (this.mouseMed == null) {
            this.mouseMed = new MouseMediator();
        }
        return this.mouseMed;
    }

    private Mediator() {
    }

    public void setGraph(RenderableGraph g) {
        this.graph = g;
    }

    public RenderableGraph getGraph() {
        return this.graph;
    }

    public Vector getEdges() {
        return this.graph.edgeList;
    }

    public Vector getVertexList() {
        return this.graph.vertexList;
    }

    public Vector getVertexInRange(int left, int top, int right, int bottom) {
        Vector<RenderableVertex> result = new Vector<RenderableVertex>();
        int i = 0;
        while (i < this.graph.vertexList.size()) {
            RenderableVertex v = (RenderableVertex)this.graph.vertexList.get(i);
            double[] pos = v.screenPos;
            if (((double)left - pos[0]) * ((double)right - pos[0]) < 0.0 && ((double)top - pos[1]) * ((double)bottom - pos[1]) < 0.0) {
                result.add(v);
            }
            ++i;
        }
        return result;
    }

    public MenuWrapper getMenuWrapper() {
        if (this.menuWrapper == null) {
            this.menuWrapper = new MenuWrapper(Infrastructure.getShell());
        }
        return this.menuWrapper;
    }

    public String[] getMouseOperationNames() {
        String[] result = new String[this.mouseMed.oparations.size()];
        Iterator iter = this.mouseMed.oparations.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name;
            result[i] = name = (String)iter.next();
            ++i;
        }
        return result;
    }

    public void setServer(WebServer server) {
        Infrastructure.server = server;
    }

    public XMLRPCHandler getXMLRPCHandler() {
        if (this.xmlrpc_handler == null) {
            this.xmlrpc_handler = new XMLRPCHandler();
        }
        return this.xmlrpc_handler;
    }

    public Vector getLawList() {
        return this.graph.aggregator.law;
    }

    public void setDefaultSpringStrength(double d) {
        if (this.graph.isDefaultSetting()) {
            SpringEdge sp = (SpringEdge)this.graph.aggregator.getLaw(0);
            sp.defaultSpringStrength = d;
        }
    }

    public double getDefaultSpringStrength() {
        if (this.graph.isDefaultSetting()) {
            SpringEdge sp = (SpringEdge)this.graph.aggregator.getLaw(0);
            return sp.defaultSpringStrength;
        }
        return -1.0;
    }
}

