/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.nishiohirokazu.graph.Arrow;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilXMLRPC;
import org.nishiohirokazu.swt.ColorHolder;

public class BoxVertex
extends RenderableVertex {
    private Point size;
    int margin = 3;
    Color bgcolor = ColorHolder.GRINGREEN;
    Point bound;
    Color frameColor = ColorHolder.BLACK;
    boolean hasSelflink;
    Color letterColor = ColorHolder.BLACK;
    public String label = "";

    public void rpc_label(Object o) {
        this.label = o.toString();
        this.bound = null;
    }

    public void rpc_bgcolor(Object rgb) {
        this.bgcolor = ColorHolder.get((Vector)rgb);
    }

    public void rpc_frame_color(Object rgb) {
        this.frameColor = ColorHolder.get((Vector)rgb);
    }

    public void rpc_letter_color(Object rgb) {
        this.letterColor = ColorHolder.get((Vector)rgb);
    }

    public void rpc_self_link(Object o) {
        this.hasSelflink = (Boolean)o;
    }

    public void rpc_bound(Object o) {
        this.bound = UtilXMLRPC.Vector2Point((Vector)o);
    }

    public Hashtable rpc_getParams() {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("bgcolor", UtilXMLRPC.Color2Vector(this.bgcolor));
        result.put("frame_color", UtilXMLRPC.Color2Vector(this.frameColor));
        result.put("letter_color", UtilXMLRPC.Color2Vector(this.letterColor));
        result.put("self_link", this.hasSelflink);
        result.put("bound", UtilXMLRPC.Point2Vector(this.bound));
        result.put("label", this.label);
        return result;
    }

    private void drawSelfLink(GC gc) {
        int radius = this.bound.y / 2;
        gc.drawOval((int)(this.screenPos[0] + (double)(this.bound.x / 2) - (double)radius), (int)(this.screenPos[1] - (double)(this.bound.y / 2) - (double)radius), radius * 2, radius * 2);
        double[] end = new double[]{this.screenPos[0] + (double)(this.bound.x / 2) - (double)radius, this.screenPos[1] - (double)(this.bound.y / 2)};
        double[] ndir = new double[]{0.312, -0.95};
        Arrow.draw(gc, end, ndir);
    }

    public void render(Object target) {
        GC gc = (GC)target;
        if (this.bound == null) {
            this.size = this.label != "" ? gc.textExtent(this.label) : new Point(0, 0);
            this.bound = new Point(this.size.x + this.margin * 2, this.size.y + this.margin * 2);
        }
        if (this.hasSelflink) {
            this.drawSelfLink(gc);
        }
        if (this.selected) {
            gc.setBackground(ColorHolder.SELECTED_VERTEX);
        } else {
            gc.setBackground(this.bgcolor);
        }
        gc.fillRectangle((int)(this.screenPos[0] - (double)(this.bound.x / 2)), (int)(this.screenPos[1] - (double)(this.bound.y / 2)), this.bound.x, this.bound.y);
        gc.setForeground(this.frameColor);
        gc.drawRectangle((int)(this.screenPos[0] - (double)(this.bound.x / 2)), (int)(this.screenPos[1] - (double)(this.bound.y / 2)), this.bound.x, this.bound.y);
        gc.setForeground(this.letterColor);
        gc.drawString(this.label, (int)(this.screenPos[0] - (double)(this.size.x / 2)), (int)(this.screenPos[1] - (double)(this.size.y / 2)));
        gc.setBackground(ColorHolder.WHITE);
    }

    public double calcOffset(double[] ndir) {
        Point b = this.bound;
        double offset = b == null || b.x == 0 || b.y == 0 ? 0.0 : (Math.abs((double)b.x * ndir[1]) < Math.abs((double)b.y * ndir[0]) ? Math.abs((double)b.x / ndir[0] / 2.0) : Math.abs((double)b.y / ndir[1] / 2.0));
        return offset;
    }

    public String toString() {
        if (this.label != "") {
            return this.label;
        }
        return super.toString();
    }
}

