/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.dummy_package.sample_impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JApplet;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.mouseOperation.MO_MoveVertex;
import org.nishiohirokazu.grinEdit.mouseOperation.MO_Scaling;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseMediator;

public class SampleApplet
extends JApplet {
    private Mediator med;
    private Vector vertexList = new Vector();
    private Dimension size;
    private Image bgImg;
    private Graphics bg;

    public void start() {
        this.med = Mediator.getInstance();
        this.vertexList.add(this.med.graph.addVertex());
        int i = 1;
        while (i < 100) {
            RenderableVertex v = this.med.graph.addVertex();
            this.vertexList.add(v);
            this.med.graph.addEdge((RenderableVertex)this.vertexList.get(i / 2), v);
            ++i;
        }
        this.size = this.getSize();
        this.bgImg = this.createImage(this.size.width, this.size.height);
        this.bg = this.bgImg.getGraphics();
        MouseMediator mm = this.med.getMouseMediator();
        this.addMouseListener(mm);
        this.addMouseMotionListener(mm);
        mm.add("move", new MO_MoveVertex(true));
        mm.add("scale", new MO_Scaling());
        mm.setLeft("move");
        mm.setRight("scale");
        Timer t = new Timer();
        TimerTask tt = new TimerTask(){

            public void run() {
                SampleApplet.this.updateScreen();
            }
        };
        t.schedule(tt, 0L, 10L);
    }

    public void updateScreen() {
        if (!this.med.pause) {
            this.med.graph.layoutStep();
            Graphics g = this.getGraphics();
            if (g != null) {
                this.bg.setColor(Color.WHITE);
                this.bg.fillRect(0, 0, this.size.width, this.size.height);
                this.bg.setColor(Color.BLACK);
                this.med.graph.render(this.bg);
                g.drawImage(this.bgImg, 0, 0, this);
            }
        }
    }
}

