/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.ItemList;

public class JSONObject
extends Hashtable {
    public String toString() {
        ItemList list = new ItemList();
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            list.add(JSONObject.toString(entry.getKey().toString(), entry.getValue()));
        }
        return "{" + list.toString() + "}";
    }

    public static String toString(String key, Object value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(JSONObject.escape(key));
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return sb.toString();
        }
        if (value instanceof String) {
            sb.append("\"");
            sb.append(JSONObject.escape((String)value));
            sb.append("\"");
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - ss.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

