/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    /*
     * Unable to fully structure code
     */
    public static boolean canProgressMonitorBeUsed(IProgressMonitor monitor1, IProgressMonitor monitor2) {
        if (monitor1 != monitor2) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((monitor1 = ((ProgressMonitorWrapper)monitor1).getWrappedProgressMonitor()) != monitor2) continue;
            return true;
lbl5:
            // 2 sources

            ** while (monitor1 instanceof ProgressMonitorWrapper)
        }
lbl6:
        // 1 sources

        return false;
    }

    public static void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread t = Thread.currentThread();
        if (t instanceof ModalContextThread) {
            return (ModalContextThread)t;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread2) {
        return thread2 instanceof ModalContextThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue(operation != null && monitor != null);
        ++modalLevel;
        try {
            if (monitor != null) {
                monitor.setCanceled(false);
            }
            if (!fork || !runInSeparateThread) {
                ModalContext.runInCurrentThread(operation, monitor);
            } else {
                ModalContextThread t = ModalContext.getCurrentModalContextThread();
                if (t != null) {
                    Assert.isTrue(ModalContext.canProgressMonitorBeUsed(monitor, t.progressMonitor));
                    ModalContext.runInCurrentThread(operation, monitor);
                } else {
                    t = new ModalContextThread(operation, monitor, display);
                    if (operation instanceof IThreadListener) {
                        ((IThreadListener)((Object)operation)).threadChange(t);
                    }
                    t.start();
                    t.block();
                    Throwable throwable = t.throwable;
                    if (throwable != null) {
                        if (debug && !(throwable instanceof InterruptedException) && !(throwable instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable instanceof InvocationTargetException) {
                            throw (InvocationTargetException)throwable;
                        }
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (!(throwable instanceof OperationCanceledException)) throw new InvocationTargetException(throwable);
                        throw new InterruptedException(throwable.getMessage());
                    }
                }
            }
            Object var6_8 = null;
            --modalLevel;
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            --modalLevel;
            throw throwable;
        }
    }

    private static void runInCurrentThread(IRunnableWithProgress runnable, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (runnable != null) {
                runnable.run(progressMonitor);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
        catch (Error e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void setDebugMode(boolean debugMode) {
        debug = debugMode;
    }

    private static class ModalContextThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private Throwable throwable;
        private IProgressMonitor progressMonitor;
        private Display display;
        private volatile boolean continueEventDispatching = true;
        private Thread callingThread;

        ModalContextThread(IRunnableWithProgress operation, IProgressMonitor monitor, Display display) {
            super("ModalContext");
            Assert.isTrue(monitor != null && display != null);
            this.runnable = operation;
            this.progressMonitor = new AccumulatingProgressMonitor(monitor, display);
            this.display = display;
            this.callingThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this.runnable != null) {
                        this.runnable.run(this.progressMonitor);
                    }
                }
                catch (InvocationTargetException e) {
                    this.throwable = e;
                }
                catch (InterruptedException e) {
                    this.throwable = e;
                }
                catch (RuntimeException e) {
                    this.throwable = e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Error e) {
                    this.throwable = e;
                }
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                if (this.runnable instanceof IThreadListener) {
                    ((IThreadListener)((Object)this.runnable)).threadChange(this.callingThread);
                }
                this.display.syncExec(new Runnable(this){
                    final /* synthetic */ ModalContextThread this$1;
                    {
                        this.this$1 = modalContextThread;
                    }

                    public void run() {
                    }
                });
                this.continueEventDispatching = false;
                this.display.asyncExec(null);
                throw throwable;
            }
            {
                Object var2_8 = null;
            }
            if (this.runnable instanceof IThreadListener) {
                ((IThreadListener)((Object)this.runnable)).threadChange(this.callingThread);
            }
            this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            this.continueEventDispatching = false;
            this.display.asyncExec(null);
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                while (this.continueEventDispatching) {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    this.throwable = e;
                }
            }
        }
    }
}

