/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private ServiceTracker xmlTracker;
    static /* synthetic */ Class class$0;

    public EclipseBundleListener(ExtensionRegistry registry) {
        this.registry = registry;
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.xml.parsers.SAXParserFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.xmlTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.xmlTracker.open();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i]);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        this.registry.remove(bundle.getBundleId());
    }

    private void addBundle(Bundle bundle) {
        if (this.registry.hasNamespace(bundle.getBundleId())) {
            return;
        }
        Contribution bundleModel = this.getBundleModel(bundle);
        if (bundleModel == null) {
            return;
        }
        if ("org.eclipse.core.runtime".equals(bundleModel.getNamespace())) {
            Messages.reloadMessages();
        }
        this.registry.add(bundleModel);
    }

    private boolean isSingleton(Bundle bundle) {
        Dictionary allHeaders = bundle.getHeaders("");
        String symbolicNameHeader = (String)allHeaders.get("Bundle-SymbolicName");
        try {
            ManifestElement[] symbolicNameElements;
            if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader)).length > 0) {
                String singleton = symbolicNameElements[0].getDirective("singleton");
                if (singleton == null) {
                    singleton = symbolicNameElements[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(singleton)) {
                    int status = 1;
                    String manifestVersion = (String)allHeaders.get("Bundle-ManifestVersion");
                    if (manifestVersion == null) {
                        if (InternalPlatform.getDefault().getBundle(symbolicNameElements[0].getValue()) == bundle) {
                            return true;
                        }
                        status = 4;
                    }
                    if (InternalPlatform.DEBUG_REGISTRY || status == 4) {
                        String message = NLS.bind((String)Messages.parse_nonSingleton, (Object)bundle.getLocation());
                        InternalPlatform.getDefault().log(new Status(status, "org.eclipse.core.runtime", 0, message, null));
                    }
                    return false;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Contribution getBundleModel(Bundle bundle) {
        Contribution contribution;
        Bundle[] hosts;
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        if (!this.isSingleton(bundle)) {
            return null;
        }
        boolean isFragment = InternalPlatform.getDefault().isFragment(bundle);
        if (isFragment && (hosts = InternalPlatform.getDefault().getHosts(bundle)) != null && !this.isSingleton(hosts[0])) {
            return null;
        }
        InputStream is = null;
        String manifestType = null;
        String manifestName = isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        try {
            URL url = bundle.getEntry(manifestName);
            if (url != null) {
                is = url.openStream();
                manifestType = isFragment ? "fragment" : "plugin";
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (is == null) {
            return null;
        }
        try {
            try {
                String message = NLS.bind((String)Messages.parse_problems, (Object)bundle.getLocation());
                MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, message, null);
                ResourceBundle b = null;
                try {
                    b = ResourceTranslator.getResourceBundle(bundle);
                }
                catch (MissingResourceException missingResourceException) {}
                ExtensionsParser parser2 = new ExtensionsParser(problems);
                Contribution bundleModel = new Contribution(bundle);
                parser2.parseManifest(this.xmlTracker, new InputSource(is), manifestType, manifestName, this.registry.getObjectManager(), bundleModel, b);
                if (problems.getSeverity() != 0) {
                    InternalPlatform.getDefault().log(problems);
                }
                contribution = bundleModel;
                Object var11_18 = null;
            }
            catch (ParserConfigurationException e) {
                this.logParsingError(bundle, e);
                Contribution contribution2 = null;
                Object var11_19 = null;
                try {
                    is.close();
                    return contribution2;
                }
                catch (IOException iOException) {}
                return contribution2;
            }
            catch (SAXException e) {
                this.logParsingError(bundle, e);
                Contribution contribution3 = null;
                Object var11_20 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                return contribution3;
            }
            catch (IOException e) {
                this.logParsingError(bundle, e);
                Contribution contribution4 = null;
                Object var11_21 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                return contribution4;
            }
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        is.close();
        return contribution;
    }

    private void logParsingError(Bundle bundle, Exception e) {
        String message = NLS.bind((String)Messages.parse_failedParsingManifest, (Object)bundle.getLocation());
        InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, message, e));
    }
}

