/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.model.messaging {
	
	import jp.co.fujitsu.reffi.client.flex.events.ModelProcessEvent;
	import jp.co.fujitsu.reffi.client.flex.model.BaseModel;
	
	import mx.messaging.Producer;
	import mx.messaging.events.ChannelEvent;
	import mx.messaging.events.ChannelFaultEvent;
	import mx.messaging.messages.AsyncMessage;
	import mx.messaging.messages.IMessage;
	
	/**
	 * <p>[概 要]</p>
	 * サーバ定義されているdestinationにメッセージを送信する機能モデルクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * destinationプロパティで設定されたdestinationへ、messageプロパティで設定された
	 * メッセージを送信します。<br>
	 * 送信メッセージのペイロードはmessageBodyプロパティ値が適用されます。
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @example
	 * 任意のdestinationにメッセージを送信する
	 * <listing version="3.0">
        public class RemarkSendAction extends BaseAction {
        
            override protected function reserveModels(models:Array):void {
                models.push(Class(ProducerCore));
            }
    
            override public function nextModel(index:int, prev:ModelProcessEvent, next:BaseModel):Boolean {
                switch (index) {
                    case 0:
                        ProducerCore(next).destination = TextInput(getComponentByName("channelName")).text;
                        ProducerCore(next).messageBody = TextInput(getComponentByName("chatRemark")).text;
                        break;
                }
                return true;
            }
        }
	 * </listing>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class ProducerCore extends BaseModel {

		// メッセージ送信先
		private var _destination:String;

		// 送信メッセージ格納オブジェクト
		private var _message:IMessage;

		// 送信メッセージペイロード
		private var _messageBody:Object;
		
		/**
		 * <p>[概 要]</p>
		 * メッセージ送信先destinationです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get destination():String{
			return this._destination;
		}
		public function set destination(destination:String):void{
			this._destination = destination;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 送信メッセージペイロードが格納されるMessageI/Fです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @default AsyncMessage
		 */
		public function get message():IMessage {
			return this._message;
		}
		public function set message(message:IMessage):void {
			this._message = message;
		}

		/**
		 * <p>[概 要]</p>
		 * 送信メッセージペイロードです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get messageBody():Object {
			return this._messageBody;
		}
		public function set messageBody(messageBody:Object):void {
			this._messageBody = messageBody;
		}

		/**
		 * <p>[概 要]</p>
		 * コンストラクタです.
		 * 
		 * <p>[詳 細]</p>
		 * プロパティを初期化します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function ProducerCore() {
			this.message = new AsyncMessage();
		}

		/**
		 * <p>[概 要]</p>
		 * LCDS及びBlazeDSで定義されているサーバ側destinationへメッセージを送信します.
		 * 
		 * <p>[詳 細]</p>
		 * destinationプロパティ値へ、messageプロパティ値を送信します。<br>
		 * messageBodyプロパティが設定されている場合、
		 * messageBodyプロパティ値が送信されるペイロードになります。
		 * 
		 * <p>[備 考]</p>
		 */
		override protected function mainProc() : void {
			super.mainProc();
			
			// 送信先デスティネーション
			var destination:String = this.destination;
			
			// 送信メッセージオブジェクト
			var message:IMessage = this.message;
			
			// メッセージペイロード
			var messageBody:Object = this.messageBody;
			
			// ペイロードが設定されていたら送信メッセージオブジェクトに設定
			if(messageBody != null) {
				message.body = messageBody;
			}

			// メッセージ送信オブジェクト
			var producer:Producer = new Producer();
			// 送信成功、失敗イベントハンドラ追加
			producer.addEventListener(ChannelEvent.CONNECT, resultHandler);
			producer.addEventListener(ChannelFaultEvent.FAULT, faultHandler);
			// destination設定
			producer.destination = destination;
			// メッセージ送信
			producer.send(message);
		}
		
		/**
		 * <p>[概 要]</p>
		 * 送信成功ハンドラです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event メッセージ送信イベント
		 */
		public final function resultHandler(event:ChannelEvent):void{
			onSuccess(event);
			
			// モデル終了イベントを生成	
			var modelSuccessEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.SUCCESS);
			modelSuccessEvent.cause = event;
			dispatchModelSuccess(modelSuccessEvent);
			
			// モデル完了イベントを生成			
			var modelFinishedEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.FINISHED);
			modelFinishedEvent.cause = event;
			dispatchModelFinished(modelFinishedEvent);
		}

		/**
		 * <p>[概 要]</p>
		 * メッセージ送信成功処理実装用オーバーライドメソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event メッセージ送信イベント
		 */
		protected function onSuccess(event:ChannelEvent):void{
			
		}
				
		/**
		 * <p>[概 要]</p>
		 * 送信失敗ハンドラです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event メッセージ送信失敗イベント
		 */
		public final function faultHandler(event:ChannelFaultEvent):void{
			onFailure(event);

			// モデル失敗イベントを生成	
			var modelFinishedEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.FAILURE);
			modelFinishedEvent.cause = event;
			dispatchModelFinished(modelFinishedEvent);
		}
		
		/**
		 * <p>[概 要]</p>
		 * メッセージ送信失敗処理用オーバーライドメソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event メッセージ受信失敗イベント
		 */
		protected function onFailure(event:ChannelFaultEvent):void{
			
		}
	}
}
