/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.events {
	
	import flash.events.Event;

	/**
	 * <p>[概 要]</p>
	 * モデル実行イベントクラス.
	 * 
	 * <p>[詳 細]</p>
	 * モデルが以下の状態になった時に発行されるイベント情報を保持します。
	 * <ul>
	 *   <li>SUCCESS：成功</li>
	 *   <li>FAILURE：失敗</li>
	 *   <li>FINISHED：完了</li>
	 * </ul>
	 * これらのイベントが、モデル実行を監視しているコントローラにキャッチされることで
	 * イベント処理フローが継続されます。
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class ModelProcessEvent extends Event {

		/** モデルが正常終了したことを示す定数です */
		public static const SUCCESS:String = "success";
		
		/** モデルが異常終了したことを示す定数です */
		public static const FAILURE:String = "failure";

		/** モデルが完全終了したことを示す定数です */
		public static const FINISHED:String = "finished";


		// モデルが終了する原因となったイベント
		private var _cause:Event;
		
		/**
		 * <p>[概 要]</p>
		 * モデルが終了する原因となったイベントです.
		 * 
		 * <p>[詳 細]</p>
		 * このプロパティから、通信イベントの結果イベント等にアクセスできます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get cause():Event{
			return this._cause;
		}
		public function set cause(cause:Event):void{
			this._cause = cause;
		}

		/**
		 * <p>[概 要]</p>
		 * コンストラクタです.
		 * 
		 * <p>[詳 細]</p>
		 * 与えられた引数を元にEventクラスのコンストラクタをコールします。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param type モデルから発行されたイベントタイプ
		 * @param bubbles 
		 * @param cancelable 
		 */
		public function ModelProcessEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) {
			super(type, bubbles, cancelable);
		}


		/**
		 * <p>[概 要]</p>
		 * このクラスオブジェクトの複製を返却します.
		 * 
		 * <p>[詳 細]</p>
		 * ModelProcessEventのコピーを作成する。
		 * <p/>
		 * @return 複製されたModelProcessEventオブジェクト
		 */
		 override public function clone():Event{
			var ret:ModelProcessEvent = new ModelProcessEvent(this.type, this.bubbles, this.cancelable);
			ret.cause = this.cause;
			return ret;
		}
	}
}
