/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.model;

import android.os.Handler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import jp.co.fujitsu.reffi.client.android.controller.BaseController;
import jp.co.fujitsu.reffi.client.android.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.listener.ModelProcessListener;
import jp.co.fujitsu.reffi.client.android.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseModel
implements Model,
Callable<Object> {
    private Object result;
    private ParameterMapping parameterMapping;
    private BaseController controller;
    private int executeIndex;
    private List<ModelProcessListener> listenerList = new ArrayList<ModelProcessListener>();
    private int successCount;
    private boolean skip;
    private boolean async;
    private Handler handler;

    @Override
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public ParameterMapping getParameterMapping() {
        return this.parameterMapping;
    }

    public void setParameterMapping(ParameterMapping parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    public BaseController getController() {
        return this.controller;
    }

    public void setController(BaseController controller) {
        this.controller = controller;
    }

    public int getExecuteIndex() {
        return this.executeIndex;
    }

    public void setExecuteIndex(int executeIndex) {
        this.executeIndex = executeIndex;
    }

    public List<ModelProcessListener> getListenerList() {
        return this.listenerList;
    }

    public void setListenerList(List<ModelProcessListener> listenerList) {
        this.listenerList = listenerList;
    }

    @Override
    public void addModelProcessListener(ModelProcessListener listener) {
        this.getListenerList().add(listener);
    }

    public void removeModelProcessListener(ModelProcessListener listener) {
        this.getListenerList().remove(listener);
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    protected int incrementSuccessCount() {
        return this.successCount++;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public Object call() throws Exception {
        this.run();
        return this.getResult();
    }

    public void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            if (this.preproc()) {
                this.mainproc();
                this.postproc();
            } else {
                this.fireModelFinished(new ModelProcessEvent(this));
            }
        }
        catch (Exception e) {
            e = this.trap(e);
            if (e != null) {
                ModelProcessEvent evt = new ModelProcessEvent(this);
                evt.setException(e);
                this.fireModelFailure(evt);
            }
        }
        finally {
            this.finalproc();
        }
    }

    protected boolean preproc() throws Exception {
        return true;
    }

    protected void mainproc() throws Exception {
    }

    protected void postproc() throws Exception {
    }

    protected Exception trap(Exception e) {
        return e;
    }

    protected void finalproc() {
    }

    public void done() throws Exception {
    }

    public void fireModelSuccess(final ModelProcessEvent evt) {
        this.incrementSuccessCount();
        this.getHandler().post(new Runnable(){

            public void run() {
                for (ModelProcessListener listener : BaseModel.this.listenerList) {
                    listener.modelSuccess(evt);
                }
            }
        });
    }

    public void fireModelFailure(final ModelProcessEvent evt) {
        this.getHandler().post(new Runnable(){

            public void run() {
                for (ModelProcessListener listener : BaseModel.this.listenerList) {
                    listener.modelFailure(evt);
                }
            }
        });
    }

    public void fireModelFinished(final ModelProcessEvent evt) {
        this.getHandler().post(new Runnable(){

            public void run() {
                for (ModelProcessListener listener : BaseModel.this.listenerList) {
                    listener.modelFinished(evt);
                }
            }
        });
    }
}

