/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.helper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import jp.co.fujitsu.reffi.client.swing.controller.BaseController;
import jp.co.fujitsu.reffi.client.swing.helper.ClassNode;
import jp.co.fujitsu.reffi.client.swing.helper.CorrelationBuilder;

public class CorrelationImageViewer
extends Panel
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -911530005188004749L;
    public ClassNode[] classNodes;
    Thread relaxer;
    boolean stress;
    int numMouseButtonsDown = 0;
    public BaseController controller;
    ClassNode pick;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    final Color controllerNodeColor = new Color(255, 100, 100);
    final Color viewNodeColor = new Color(230, 230, 230);
    final Color actionNodeColor = new Color(230, 200, 125);
    final Color modelNodeColor = new Color(125, 230, 125);
    final Color fixedColor = new Color(255, 100, 100);
    final Color selectColor = Color.pink;
    final Color nodeColor = new Color(250, 220, 100);
    final Color stressColor = Color.darkGray;
    final Color arcColor1 = Color.black;
    final Color arcColor2 = Color.pink;
    final Color arcColor3 = Color.red;
    boolean firstRendering = false;

    public CorrelationImageViewer() {
        this.addMouseListener(this);
        ClassNode controller = new ClassNode(0, "dummy", "DummyController");
        controller.fixed = true;
        this.classNodes = controller.toArray();
    }

    public void buildNodes(BaseController controller) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ClassNode controllerNode = CorrelationBuilder.build(controller);
        this.classNodes = controllerNode.toArray();
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        while (this.relaxer == me) {
            this.relax();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    synchronized void relax() {
        int i;
        for (i = 1; i < this.classNodes.length; ++i) {
            ClassNode classNode = this.classNodes[i];
            double vx = classNode.getParent().x - classNode.x;
            double vy = classNode.getParent().y - classNode.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = (classNode.getLineLength() - len) / (len * 3.0);
            double dx = f * vx;
            double dy = f * vy;
            classNode.getParent().x += dx;
            classNode.getParent().y += dy;
            classNode.x -= dx;
            classNode.y -= dy;
        }
        for (i = 1; i < this.classNodes.length; ++i) {
            ClassNode n1 = this.classNodes[i];
            double dx = 0.0;
            double dy = 0.0;
            for (int j = 0; j < this.classNodes.length; ++j) {
                if (i == j) continue;
                ClassNode n2 = this.classNodes[j];
                double vx = n1.x - n2.x;
                double vy = n1.y - n2.y;
                double len = vx * vx + vy * vy;
                if (len == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(len < 10000.0)) continue;
                dx += vx / len;
                dy += vy / len;
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 2.0;
            n1.x += dx / dlen;
            n1.y += dy / dlen;
        }
        Dimension d = this.getSize();
        for (int i2 = 1; i2 < this.classNodes.length; ++i2) {
            ClassNode n = this.classNodes[i2];
            if (!n.fixed) {
                n.x += Math.max(-5.0, Math.min(5.0, n.dx));
                n.y += Math.max(-5.0, Math.min(5.0, n.dy));
            }
            if (n.x < 0.0) {
                n.x = 0.0;
            } else if (n.x > (double)d.width) {
                n.x = d.width;
            }
            if (n.y < 0.0) {
                n.y = 0.0;
            } else if (n.y > (double)d.height) {
                n.y = d.height;
            }
            n.dx /= 2.0;
            n.dy /= 2.0;
        }
        this.repaint();
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        for (int i = 1; i < this.classNodes.length; ++i) {
            ClassNode classNode = this.classNodes[i];
            int x1 = (int)classNode.x;
            int x2 = (int)classNode.getParent().x;
            int y1 = (int)classNode.y;
            int y2 = (int)classNode.getParent().y;
            int len = (int)Math.abs(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)) - classNode.getLineLength());
            this.offgraphics.setColor(len < 10 ? this.arcColor1 : (len < 20 ? this.arcColor2 : this.arcColor3));
            this.offgraphics.drawLine(x1, y1, x2, y2);
            if (!this.stress) continue;
            String lbl = "actionPerformed";
            this.offgraphics.setColor(this.stressColor);
            this.offgraphics.drawString(lbl, x1 + (x2 - x1) / 2, y1 + (y2 - y1) / 2);
        }
        FontMetrics fm = this.offgraphics.getFontMetrics();
        for (int i = 0; i < this.classNodes.length; ++i) {
            ClassNode classNode = this.classNodes[i];
            if (!this.firstRendering) {
                classNode.x = d.width / 2;
                classNode.y = d.height / 2;
            }
            this.paintNode(this.offgraphics, this.classNodes[i], fm);
        }
        g.drawImage(this.offscreen, 0, 0, null);
        this.firstRendering = true;
    }

    public void paintNode(Graphics g, ClassNode n, FontMetrics fm) {
        int x = (int)n.x;
        int y = (int)n.y;
        g.setColor(n == this.pick ? this.selectColor : (n.getParent() == null ? this.fixedColor : this.nodeColor));
        if (n.getNodeType() == 0) {
            g.setColor(this.controllerNodeColor);
            Dimension d = this.getSize();
            n.x = d.getWidth() / 2.0;
            n.y = d.getHeight() / 2.0;
        } else if (n.getNodeType() == 1) {
            g.setColor(this.viewNodeColor);
        } else if (n.getNodeType() == 2) {
            g.setColor(this.actionNodeColor);
        } else if (n.getNodeType() == 3) {
            g.setColor(this.modelNodeColor);
        }
        int w = fm.stringWidth(n.getName()) + 10;
        int h = fm.getHeight() + 4;
        g.fillRect(x - w / 2, y - h / 2, w, h);
        g.setColor(Color.black);
        g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        g.drawString(n.getName(), x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ++this.numMouseButtonsDown;
        this.addMouseMotionListener(this);
        double bestdist = Double.MAX_VALUE;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.classNodes.length; ++i) {
            ClassNode n = this.classNodes[i];
            double dist = (n.x - (double)x) * (n.x - (double)x) + (n.y - (double)y) * (n.y - (double)y);
            if (!(dist < bestdist)) continue;
            this.pick = n;
            bestdist = dist;
        }
        this.pickfixed = this.pick.fixed;
        this.pick.fixed = true;
        this.pick.x = x;
        this.pick.y = y;
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        --this.numMouseButtonsDown;
        this.removeMouseMotionListener(this);
        this.pick.fixed = this.pickfixed;
        this.pick.x = e.getX();
        this.pick.y = e.getY();
        if (this.numMouseButtonsDown == 0) {
            this.pick = null;
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.pick.x = e.getX();
        this.pick.y = e.getY();
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void stop() {
        this.relaxer = null;
    }
}

