/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.event;

import java.util.EventObject;

import jp.co.fujitsu.reffi.client.nexaweb.model.Model;

/**
 * <p>[概 要] </p>
 * モデル処理の成功、失敗情報を保持するイベントクラスです。
 * 
 * <p>[詳 細] </p>
 * モデルレイヤ実装において、処理が成功した場合、失敗した場合にこのオブジェクトが
 * 生成され、コントローラ内のモデル処理結果イベントハンドラに譲渡されます。<br>
 * 上記リスナはモデルを起動したアクションのnextModel、successForward、failureFoward
 * に同オブジェクトを譲渡します。<br>
 * 
 * <p>[備 考] </p>
 * 
 * 
 * <p>[環 境] JDK 6.0 Update 11</p>
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi 
 */
public class ModelProcessEvent extends EventObject {
	/** シリアルバージョン番号 */
	private static final long serialVersionUID = 1434883436721714559L;
	/** モデル処理成功結果です。 */
	private Object result;
	/** モデル処理失敗例外です。 */
	private Exception exception;
	
	/**
	 * <p>[概 要] </p>
	 * モデル処理成功結果を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * resultフィールドを返却します。
	 * 
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return モデル処理成功結果
	 */
	public Object getResult() {
		return this.result;
	}

	/**
	 * <p>[概 要] </p>
	 * モデル処理成功結果を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * resultフィールドを、引数resultで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param result モデル処理成功結果
	 */
	public void setResult(Object result) {
		this.result = result;
	}

	/**
	 * <p>[概 要] </p>
	 * モデル処理失敗例外を取得します。
	 * 
	 * <p>[詳 細] </p>
	 * exceptionフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return モデル処理失敗例外
	 */
	public Exception getException() {
		return this.exception;
	}

	/**
	 * <p>[概 要] </p>
	 * モデル処理失敗例外を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * exceptionフィールドを引数exceptionで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param exception モデル処理失敗例外
	 */
	public void setException(Exception exception) {
		this.exception = exception;
	}

	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * 引数modelをイベントソースとして親コンストラクタをコールします。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param model イベントソース（イベントを発行したモデル）
	 */
	public ModelProcessEvent(Model model) {
		super(model);
	}
}
