/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.parser;

import com.nexaweb.xml.Element;
import java.util.HashMap;
import java.util.Map;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ButtonValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.CheckBoxValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ComboBoxValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValues;
import jp.co.fujitsu.reffi.client.nexaweb.parser.HorizontalSliderValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.LabelValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ListBoxValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.Parser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.PasswordFieldValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.RadioButtonValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.TableValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.TextAreaValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.TextFieldValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.TextViewValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.VerticalSliderValueParser;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public class ElementValueParser
implements Parser {
    public static final Map<String, Class<? extends Parser>> PARSERS = new HashMap<String, Class<? extends Parser>>();

    @Override
    public ElementValues parse(Element element) throws Exception {
        ElementValues ret = null;
        try {
            String localName = element.getLocalName();
            Parser parser = null;
            if (!PARSERS.containsKey(localName)) {
                return null;
            }
            parser = PARSERS.get(localName).newInstance();
            ret = (ElementValues)parser.parse(element);
        }
        catch (IllegalAccessException e) {
            throw new CoreLogicException("EFC0011");
        }
        catch (InstantiationException e) {
            throw new CoreLogicException("EFC0012");
        }
        return ret;
    }

    public static void addParser(String elementName, Class<? extends Parser> parser) {
        PARSERS.put(elementName, parser);
    }

    static {
        PARSERS.put("button", ButtonValueParser.class);
        PARSERS.put("label", LabelValueParser.class);
        PARSERS.put("passwordField", PasswordFieldValueParser.class);
        PARSERS.put("textField", TextFieldValueParser.class);
        PARSERS.put("checkBox", CheckBoxValueParser.class);
        PARSERS.put("radioButton", RadioButtonValueParser.class);
        PARSERS.put("comboBox", ComboBoxValueParser.class);
        PARSERS.put("listBox", ListBoxValueParser.class);
        PARSERS.put("horizontalSlider", HorizontalSliderValueParser.class);
        PARSERS.put("verticalSlider", VerticalSliderValueParser.class);
        PARSERS.put("textArea", TextAreaValueParser.class);
        PARSERS.put("textView", TextViewValueParser.class);
        PARSERS.put("table", TableValueParser.class);
    }
}

